/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.runtime;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stp.im.runtime.IElementDefiningProperties;
import org.eclipse.stp.im.runtime.IProperty;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementDefiningPropertiesImpl
implements IElementDefiningProperties {
    private String name = null;
    private String runtimeId = null;
    private String registeringBundleId = null;
    private String iconPath = null;
    private List<IProperty> properties;
    private Map<String, IProperty> propertyMap = null;

    public String getRuntimeId() {
        return this.runtimeId;
    }

    public void setRuntimeId(String runtimeId) {
        this.runtimeId = runtimeId;
    }

    public ElementDefiningPropertiesImpl(String name, String runtimeID) {
        this.name = name;
        this.propertyMap = new HashMap<String, IProperty>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return "Element With Properties [" + this.name + "]";
    }

    @Override
    public List<IProperty> getDefinedProperties() {
        return this.properties;
    }

    @Override
    public void setDefinedProperties(List<IProperty> properties) {
        this.properties = properties;
        this.propertyMap.clear();
        for (IProperty prop : properties) {
            this.propertyMap.put(prop.getName(), prop);
        }
    }

    @Override
    public IProperty getDefinedPropertyByName(String propertyName) {
        return this.propertyMap.get(propertyName);
    }

    @Override
    public String getIconPath() {
        return this.iconPath;
    }

    @Override
    public String getRegisteringBundleId() {
        return this.registeringBundleId;
    }

    @Override
    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
    }

    @Override
    public void setRegisteringBundleId(String registeringBundleId) {
        this.registeringBundleId = registeringBundleId;
    }
}

