/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.integration;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.util.Geometry;
import org.eclipse.stp.policy.model.All;
import org.eclipse.stp.policy.model.Assertion;
import org.eclipse.stp.policy.model.Policy;
import org.eclipse.stp.policy.model.PolicyComponent;
import org.eclipse.stp.policy.model.PolicyComposite;
import org.eclipse.stp.policy.model.impl.AllImpl;
import org.eclipse.stp.policy.model.impl.PolicyImpl;
import org.eclipse.stp.policy.model.impl.PolicyProvider;
import org.eclipse.stp.policy.wtp.editor.Logger;
import org.eclipse.stp.policy.wtp.editor.PolicyMultiPageEditor;
import org.eclipse.stp.policy.wtp.editor.integration.EditPolicyAssertionDetailCallback;
import org.eclipse.stp.policy.wtp.editor.integration.PolicyDetailEditorInput;
import org.eclipse.stp.policy.wtp.editor.model.AssertionModel;
import org.eclipse.stp.policy.wtp.editor.model.PolicyCompositeModel;
import org.eclipse.stp.policy.wtp.editor.util.DragOperations;
import org.eclipse.stp.policy.wtp.editor.util.EditorDropTarget;
import org.eclipse.stp.policy.wtp.editor.util.ExistingWindowProvider;
import org.eclipse.stp.policy.wtp.editor.util.WorkbenchWindowDropTarget;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPart3;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.internal.EditorPane;
import org.eclipse.ui.internal.EditorSashContainer;
import org.eclipse.ui.internal.EditorSite;
import org.eclipse.ui.internal.EditorStack;
import org.eclipse.wst.wsdl.ui.internal.asd.facade.IASDObject;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;
import org.w3c.dom.Element;

public class XefOpenExternalEditorHelper
implements IOpenExternalEditorHelper {
    private IFile wsdlFile;
    private IEditorPart ownerEditor;
    private Object object;
    private static final String XEF_ID = "org.eclipse.stp.ui.xef.editor.XefEditor";

    public XefOpenExternalEditorHelper(IEditorPart ownerEditor, IFile wsdlFile) {
        this.ownerEditor = ownerEditor;
        this.wsdlFile = wsdlFile;
    }

    public void setModel(Object object) {
        this.object = object;
    }

    public void openExternalEditor() {
        IProject project = this.wsdlFile.getProject();
        try {
            Policy policy = PolicyImpl.create(null);
            All all = policy.createAll();
            Element element = ((AllImpl)all).getElement();
            PolicyCompositeModel policyCompositeModel = null;
            AssertionModel assertionModel = null;
            boolean openAddDialog = false;
            if (this.object instanceof AssertionModel) {
                assertionModel = (AssertionModel)((Object)this.object);
                policyCompositeModel = (PolicyCompositeModel)assertionModel.getParent();
            } else if (this.object instanceof PolicyCompositeModel) {
                policyCompositeModel = (PolicyCompositeModel)((Object)this.object);
                openAddDialog = true;
            }
            EditPolicyAssertionDetailCallback callback = new EditPolicyAssertionDetailCallback(policyCompositeModel);
            int selection = -1;
            PolicyComposite policyComposite = policyCompositeModel.getPolicyComposite();
            int index = 0;
            List<PolicyComponent> policyComponents = policyComposite.getPolicyComponents();
            for (PolicyComponent policyComponent : policyComponents) {
                Assertion assertion = null;
                if (policyComponent.getType() == 5) {
                    assertion = (Assertion)policyComponent;
                }
                if (assertion != null && assertionModel != null && assertionModel.getAssertion().equals(assertion)) {
                    selection = index;
                }
                policyComponent.serialize(element);
                ++index;
            }
            String text = policyCompositeModel.getText();
            InputStream streamIn = null;
            if (policy instanceof PolicyImpl) {
                PolicyProvider provider = new PolicyProvider(((PolicyImpl)policy).getElement().getOwnerDocument());
                provider.getDocument().getDocumentElement().setAttribute("xmlns:wsp", "http://www.w3.org/ns/ws-policy");
                streamIn = provider.serialize();
            }
            PolicyDetailEditorInput ed = new PolicyDetailEditorInput(text, streamIn, project, callback);
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage workbenchPage = activeWindow.getActivePage();
            IEditorPart partExisting = workbenchPage.findEditor((IEditorInput)ed);
            IEditorPart part = IDE.openEditor((IWorkbenchPage)workbenchPage, (IEditorInput)ed, (String)XEF_ID);
            if (partExisting == null) {
                TabStackHelper.addToTabStack(this.ownerEditor, part, policyCompositeModel);
            }
            if (openAddDialog && part instanceof IWorkbenchPart3) {
                ((IWorkbenchPart3)part).setPartProperty("OPEN_ADD_DIALOG", "");
            }
            if (selection != -1 && part instanceof IWorkbenchPart3) {
                ((IWorkbenchPart3)part).setPartProperty("SELECT_ELEMENT", Integer.toString(selection));
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    public boolean linkApplicable() {
        boolean applicable = false;
        if (this.object instanceof IASDObject) {
            applicable = !((IASDObject)this.object).isReadOnly();
        }
        return applicable;
    }

    public boolean isValid() {
        return true;
    }

    public void showPreview() {
    }

    public static IOpenExternalEditorHelper getExternalEditorOpener() {
        Object adapted;
        IEditorPart editorPart;
        IOpenExternalEditorHelper openExternalEditorHelper = null;
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (page != null && (editorPart = page.getActiveEditor()) != null && (adapted = editorPart.getAdapter(IOpenExternalEditorHelper.class)) instanceof IOpenExternalEditorHelper) {
            openExternalEditorHelper = (IOpenExternalEditorHelper)adapted;
        }
        return openExternalEditorHelper;
    }

    public static void dispose(IEditorPart owner) {
        TabStackHelper.dispose(owner, true);
    }

    public static void save(IEditorPart owner) {
        TabStackHelper.save(owner);
    }

    private static class TabStackHelper {
        private static EditorStack secondStack = null;
        private static Map<IEditorPart, List<IEditorPart>> subWindows = new HashMap<IEditorPart, List<IEditorPart>>();

        private TabStackHelper() {
        }

        public static void addToTabStack(IEditorPart owner, IEditorPart part, PolicyCompositeModel policyCompositeModel) {
            if (secondStack == null || !secondStack.getVisible()) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
                EditorDropTarget dropTarget = new EditorDropTarget(new ExistingWindowProvider(activeWindow), 0, 1024);
                DragOperations.drag((IWorkbenchPart)part, dropTarget, false);
                secondStack = (EditorStack)((EditorSite)part.getEditorSite()).getPane().getContainer();
                workbench.addWorkbenchListener(new IWorkbenchListener(){

                    public void postShutdown(IWorkbench workbench) {
                    }

                    public boolean preShutdown(IWorkbench workbench, boolean forced) {
                        TabStackHelper.dispose();
                        return true;
                    }
                });
            } else {
                WorkbenchWindowDropTarget dropTarget = new WorkbenchWindowDropTarget(new ExistingWindowProvider(secondStack.getWorkbenchWindow())){

                    public Point getLocation() {
                        Control parentControl = ((EditorSashContainer)secondStack.getContainer()).getControl();
                        Rectangle localBounds = secondStack.getEditors()[0].getBounds();
                        Rectangle globalBounds = Geometry.toDisplay((Control)parentControl, (Rectangle)localBounds);
                        Point c = Geometry.centerPoint((Rectangle)globalBounds);
                        return c;
                    }

                    public String toString() {
                        return String.valueOf(secondStack.toString()) + " location ";
                    }
                };
                DragOperations.drag((IWorkbenchPart)part, dropTarget, false);
            }
            TabStackHelper.addListeners(owner, part, policyCompositeModel);
            if (!subWindows.containsKey(owner)) {
                subWindows.put(owner, new ArrayList());
            }
            subWindows.get(owner).add(part);
        }

        private static void addListeners(final IEditorPart owner, IEditorPart part, final PolicyCompositeModel policyCompositeModel) {
            if (policyCompositeModel != null) {
                IWorkbench workbench = PlatformUI.getWorkbench();
                final IWorkbenchWindow activeWindow = workbench.getActiveWorkbenchWindow();
                final IWorkbenchPartReference reference = ((EditorSite)part.getEditorSite()).getPartReference();
                activeWindow.getActivePage().addPartListener(new IPartListener2(){

                    public void partActivated(IWorkbenchPartReference partRef) {
                        if (reference.equals(partRef)) {
                            activeWindow.getActivePage().bringToTop((IWorkbenchPart)owner);
                            PolicyMultiPageEditor.selectItem((Object)policyCompositeModel, owner);
                        }
                    }

                    public void partBroughtToTop(IWorkbenchPartReference partRef) {
                    }

                    public void partClosed(IWorkbenchPartReference partRef) {
                    }

                    public void partDeactivated(IWorkbenchPartReference partRef) {
                    }

                    public void partHidden(IWorkbenchPartReference partRef) {
                    }

                    public void partInputChanged(IWorkbenchPartReference partRef) {
                    }

                    public void partOpened(IWorkbenchPartReference partRef) {
                    }

                    public void partVisible(IWorkbenchPartReference partRef) {
                    }
                });
                PolicyMultiPageEditor.selectItem((Object)policyCompositeModel, owner);
            }
            part.addPropertyListener(new IPropertyListener(){

                public void propertyChanged(Object source, int propId) {
                    if (propId == 257) {
                        IEditorPart part = (IEditorPart)source;
                        for (IEditorPart owner : subWindows.keySet()) {
                            if (!((List)subWindows.get(owner)).contains(source)) continue;
                            if (part.isDirty()) {
                                ((PolicyMultiPageEditor)owner).setDirty(true);
                                continue;
                            }
                            boolean dirtyKids = false;
                            for (IEditorPart kid : (List)subWindows.get(owner)) {
                                dirtyKids |= kid.isDirty();
                            }
                            ((PolicyMultiPageEditor)owner).setDirty(dirtyKids);
                        }
                    }
                }
            });
        }

        private static void dispose() {
            for (IEditorPart owner : subWindows.keySet()) {
                TabStackHelper.dispose(owner, false);
            }
            subWindows.clear();
        }

        private static void dispose(IEditorPart owner, boolean cleanOwner) {
            if (!subWindows.containsKey(owner)) {
                return;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage workbenchPage = workbench.getActiveWorkbenchWindow().getActivePage();
            EditorPane[] editors = secondStack.getEditors();
            List<IEditorPart> ownedEditors = subWindows.get(owner);
            int i = 0;
            while (i < editors.length) {
                IEditorPart kid = editors[i].getEditorReference().getEditor(false);
                if (ownedEditors.contains(kid)) {
                    workbenchPage.closeEditor(kid, true);
                }
                ++i;
            }
            ownedEditors.clear();
            if (cleanOwner) {
                subWindows.remove(owner);
            }
        }

        private static void save(IEditorPart owner) {
            if (!subWindows.containsKey(owner)) {
                return;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage workbenchPage = workbench.getActiveWorkbenchWindow().getActivePage();
            EditorPane[] editors = secondStack.getEditors();
            List<IEditorPart> ownedEditors = subWindows.get(owner);
            int i = 0;
            while (i < editors.length) {
                IEditorPart kid = editors[i].getEditorReference().getEditor(false);
                if (ownedEditors.contains(kid)) {
                    workbenchPage.saveEditor(kid, false);
                }
                ++i;
            }
        }
    }
}

