/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.preferences;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.stp.policy.wtp.editor.Messages;
import org.eclipse.stp.policy.wtp.editor.preferences.ProjectSettings;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.Hyperlink;

public class ProjectPropertiesPage
extends PropertyPage {
    private static final int EDIT_STYLE = 2052;
    private Text schemaPathText = null;
    private Button overrideGlobalButton;
    private ProjectSettings settings;

    protected Control createContents(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.noDefaultAndApplyButton();
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)new GridLayout(2, false));
        this.settings = ProjectSettings.getSettings(this.getProject());
        this.overrideGlobalButton = new Button(result, 32);
        this.overrideGlobalButton.setSelection(this.settings.isOverridesDefaults());
        this.overrideGlobalButton.setText(Messages.OverridesGlobalSettings_LABEL);
        this.overrideGlobalButton.setFocus();
        this.overrideGlobalButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProjectPropertiesPage.this.settings.setOverridesDefaults(ProjectPropertiesPage.this.overrideGlobalButton.getSelection());
                ProjectPropertiesPage.this.updateWidgets();
            }
        });
        Hyperlink link = new Hyperlink(result, 0);
        GridData layout = new GridData(128);
        link.setLayoutData((Object)layout);
        link.setUnderlined(true);
        link.setForeground(ColorConstants.blue);
        link.setText(Messages.ConfigureWorkspaceSettings_LABEL);
        link.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                String id = this.getPreferencePageID();
                if (PreferencesUtil.createPreferenceDialogOn((Shell)ProjectPropertiesPage.this.getShell(), (String)id, (String[])new String[]{id}, null).open() == 0) {
                    ProjectPropertiesPage.this.updateWidgets();
                }
            }

            private String getPreferencePageID() {
                return "org.eclipse.stp.policy.wtp.editor.preferences.generalpreferences";
            }
        });
        ProjectPropertiesPage.createLabel(result, "Schema directory relative path:");
        this.schemaPathText = new Text(result, 2052);
        this.schemaPathText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.schemaPathText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProjectPropertiesPage.this.settings.setSchemasPath(ProjectPropertiesPage.this.schemaPathText.getText());
                ProjectPropertiesPage.this.validatePage();
            }
        });
        this.updateWidgets();
        return result;
    }

    private void updateWidgets() {
        this.schemaPathText.setText(this.settings.getSchemasPath());
        this.schemaPathText.setEnabled(this.settings.isOverridesDefaults());
    }

    private static Label createLabel(Composite parent, String label) {
        Label devLabel = new Label(parent, 0);
        devLabel.setText(label);
        return devLabel;
    }

    private boolean validatePage() {
        String errMsg = null;
        if (errMsg == null) {
            errMsg = this.validatePath(this.schemaPathText.getText());
        }
        if (errMsg != null) {
            this.setMessage(errMsg, 3);
            this.setValid(false);
            return false;
        }
        this.setMessage(null);
        this.setValid(true);
        return true;
    }

    private String validatePath(String pathDir) {
        if (!this.settings.isOverridesDefaults()) {
            return null;
        }
        if (pathDir.length() == 0) {
            return "The selected path must be specified.";
        }
        IFolder folder = this.getProject().getFolder(pathDir);
        if (!folder.exists()) {
            return "The selected path is not existing directory.";
        }
        return null;
    }

    protected void performApply() {
        super.performApply();
        this.settings.save();
    }

    public boolean performOk() {
        boolean bRet = super.performOk();
        this.settings.save();
        return bRet;
    }

    private IProject getProject() {
        IAdaptable element = this.getElement();
        if (element instanceof IProject) {
            return (IProject)this.getElement();
        }
        if (element instanceof JavaProject) {
            return ((JavaProject)element).getProject();
        }
        return null;
    }
}

