/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.common.java.Messages;
import org.eclipse.stp.sca.common.java.ScaCommonJdtPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanAxisCodeAction
implements IObjectActionDelegate {
    private List<IPackageFragment> packageFragments = new ArrayList<IPackageFragment>();
    private IWorkbenchPart part;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.part = targetPart;
    }

    public void run(IAction action) {
        String value;
        IRunnableWithProgress runnable = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                monitor.beginTask(Messages.CleanAxisCodeAction_0, -1);
                try {
                    try {
                        for (IPackageFragment packageFragment : CleanAxisCodeAction.this.packageFragments) {
                            CleanAxisCodeAction.this.cleanPackageAndSubPackages(packageFragment, monitor);
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            new ProgressMonitorDialog(this.part.getSite().getShell()).run(false, true, runnable);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        IPreferenceStore ps = ScaCommonJdtPlugin.getDefault().getPreferenceStore();
        if (ps.getString("org.eclipse.stp.sca.common.internal.jdt.preferences.axisLibrariesPrompt") != "never") {
            MessageDialogWithToggle dlg = MessageDialogWithToggle.openYesNoQuestion((Shell)this.part.getSite().getShell(), (String)Messages.CleanAxisCodeAction_1, (String)Messages.CleanAxisCodeAction_2, (String)Messages.CleanAxisCodeAction_3, (boolean)false, (IPreferenceStore)ps, (String)"org.eclipse.stp.sca.common.internal.jdt.preferences.removeAxisLibraries");
            if (dlg.getToggleState()) {
                ps.setValue("org.eclipse.stp.sca.common.internal.jdt.preferences.axisLibrariesPrompt", "never");
            } else if (dlg.getReturnCode() == 2) {
                ps.setValue("org.eclipse.stp.sca.common.internal.jdt.preferences.removeAxisLibraries", "always");
            } else {
                ps.setValue("org.eclipse.stp.sca.common.internal.jdt.preferences.removeAxisLibraries", "never");
            }
        }
        if ((value = ps.getString("org.eclipse.stp.sca.common.internal.jdt.preferences.removeAxisLibraries")).equals("always")) {
            this.unconfigureAxisLibraries();
        }
    }

    protected void cleanPackageAndSubPackages(IPackageFragment packageFragment, IProgressMonitor monitor) {
        try {
            this.cleanJavaPackage(packageFragment, monitor);
            IResource res = packageFragment.getUnderlyingResource();
            if (res instanceof IContainer) {
                IResource[] resources;
                IResource[] iResourceArray = resources = ((IContainer)res).members();
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    if (monitor.isCanceled()) {
                        monitor.done();
                        return;
                    }
                    IJavaElement javaElement = JavaCore.create((IResource)r);
                    if (javaElement != null && javaElement instanceof IPackageFragment) {
                        this.cleanPackageAndSubPackages((IPackageFragment)javaElement, monitor);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (!selection.isEmpty() & selection instanceof IStructuredSelection) {
            for (Object o : (IStructuredSelection)selection) {
                IJavaProject javaProject = null;
                if (o instanceof IProject) {
                    javaProject = JavaCore.create((IProject)((IProject)o));
                } else if (o instanceof IJavaProject) {
                    javaProject = (IJavaProject)o;
                }
                if (javaProject == null) continue;
                try {
                    IPackageFragmentRoot[] roots;
                    IPackageFragmentRoot[] iPackageFragmentRootArray = roots = javaProject.getAllPackageFragmentRoots();
                    int n = roots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IPackageFragmentRoot root = iPackageFragmentRootArray[n2];
                        if (root.getKind() == 1) {
                            IJavaElement[] iJavaElementArray = root.getChildren();
                            int n3 = iJavaElementArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                IJavaElement elt = iJavaElementArray[n4];
                                if (elt instanceof IPackageFragment) {
                                    this.packageFragments.add((IPackageFragment)elt);
                                }
                                ++n4;
                            }
                        }
                        ++n2;
                    }
                }
                catch (JavaModelException e) {
                    e.printStackTrace();
                }
            }
        }
        action.setEnabled(this.packageFragments.size() > 0);
    }

    private void unconfigureAxisLibraries() {
        try {
            List<String> axisDependencies = Arrays.asList(".*axis.*\\.jar", ".*javax.wsdl.*\\.jar", ".*jaxrpc.*\\.jar", ".*commons-discovery.*\\.jar", ".*saaj.*\\.jar", ".*org.apache.commons.logging.*\\.jar");
            IJavaProject javaProject = this.packageFragments.get(0).getJavaProject();
            HashSet<IClasspathEntry> entries = new HashSet<IClasspathEntry>();
            entries.addAll(Arrays.asList(javaProject.getRawClasspath()));
            HashSet<IClasspathEntry> entriesToRemove = new HashSet<IClasspathEntry>();
            block2: for (IClasspathEntry entry : entries) {
                for (String pattern : axisDependencies) {
                    if (!entry.getPath().toString().matches(pattern)) continue;
                    entriesToRemove.add(entry);
                    continue block2;
                }
            }
            entries.removeAll(entriesToRemove);
            javaProject.setRawClasspath(entries.toArray(new IClasspathEntry[entries.size()]), (IProgressMonitor)new NullProgressMonitor());
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void cleanJavaPackage(IPackageFragment packageFragment, IProgressMonitor monitor) {
        try {
            ICompilationUnit[] iCompilationUnitArray = packageFragment.getCompilationUnits();
            int n = iCompilationUnitArray.length;
            int n2 = 0;
            while (n2 < n) {
                ICompilationUnit cu = iCompilationUnitArray[n2];
                if (monitor.isCanceled()) {
                    monitor.done();
                    return;
                }
                this.cleanJavaPackage(cu, monitor);
                monitor.worked(1);
                ++n2;
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void cleanJavaPackage(final ICompilationUnit compilationUnit, final IProgressMonitor monitor) {
        String action = NLS.bind((String)Messages.CleanAxisCodeAction_12, (Object)compilationUnit.getResource().getName());
        monitor.setTaskName(action);
        List<String> methodsToDelete = Arrays.asList("getDeserializer", "getSerializer", "getTypeDesc", "writeDetails");
        List<String> fieldsToDelete = Arrays.asList("typeDesc");
        List<String> typesToDelete = Arrays.asList("org.apache.axis.client.Service", "org.apache.axis.client.Stub", "javax.xml.rpc.Service");
        try {
            IType[] types;
            IType[] iTypeArray = types = compilationUnit.getTypes();
            int n = types.length;
            int n2 = 0;
            while (n2 < n) {
                IType type = iTypeArray[n2];
                for (String t : this.getSuperTypes(type, false)) {
                    if (!typesToDelete.contains(t)) continue;
                    compilationUnit.delete(true, monitor);
                    return;
                }
                monitor.worked(1);
                if (type.getResource().getName().endsWith("Proxy.java")) {
                    compilationUnit.delete(true, monitor);
                    return;
                }
                monitor.worked(1);
                IMethod[] iMethodArray = type.getMethods();
                int n3 = iMethodArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMethod method = iMethodArray[n4];
                    if (methodsToDelete.contains(method.getElementName())) {
                        method.delete(true, monitor);
                    }
                    ++n4;
                }
                monitor.worked(1);
                iMethodArray = type.getFields();
                n3 = iMethodArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IMethod field = iMethodArray[n4];
                    if (fieldsToDelete.contains(field.getElementName())) {
                        field.delete(true, monitor);
                    }
                    ++n4;
                }
                monitor.worked(1);
                iMethodArray = type.getInitializers();
                n3 = iMethodArray.length;
                n4 = 0;
                while (n4 < n3) {
                    IMethod initializer = iMethodArray[n4];
                    if (Modifier.isStatic(initializer.getFlags()) && initializer.getSource().contains("typeDesc")) {
                        initializer.delete(true, monitor);
                    }
                    ++n4;
                }
                monitor.worked(1);
                List<String> parents = this.getSuperTypes(type, true);
                if (parents.size() > 0 && parents.get(0).equals("org.apache.axis.AxisFault")) {
                    ASTParser parser = ASTParser.newParser((int)3);
                    parser.setSource(compilationUnit);
                    parser.setResolveBindings(true);
                    parser.setStatementsRecovery(true);
                    parser.setFocalPosition(type.getNameRange().getOffset());
                    CompilationUnit cu = (CompilationUnit)parser.createAST(monitor);
                    ASTVisitor superClassVisitor = new ASTVisitor(){

                        public boolean visit(TypeDeclaration typeNode) {
                            CleanAxisCodeAction.this.replaceFaultAxis(compilationUnit, typeNode, monitor);
                            return super.visit(typeNode);
                        }
                    };
                    cu.accept(superClassVisitor);
                }
                monitor.worked(1);
                ++n2;
            }
            if (compilationUnit.isWorkingCopy()) {
                compilationUnit.reconcile(3, true, null, monitor);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
    }

    private void replaceFaultAxis(ICompilationUnit compilationUnit, TypeDeclaration typeNode, IProgressMonitor monitor) {
        if (typeNode.getSuperclassType() != null) {
            ITypeBinding binding = typeNode.resolveBinding();
            if ((binding = binding.getSuperclass()) != null && "org.apache.axis.AxisFault".equals(binding.getQualifiedName())) {
                AST ast = typeNode.getSuperclassType().getAST();
                ASTRewrite rewrite = ASTRewrite.create((AST)ast);
                Name name = ast.newName("java.lang.Exception");
                SimpleType newType = ast.newSimpleType(name);
                rewrite.set((ASTNode)typeNode, (StructuralPropertyDescriptor)TypeDeclaration.SUPERCLASS_TYPE_PROPERTY, (Object)newType, null);
                try {
                    ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                    IPath path = compilationUnit.getPath();
                    try {
                        bufferManager.connect(path, LocationKind.IFILE, null);
                        ITextFileBuffer textFileBuffer = bufferManager.getTextFileBuffer(path, LocationKind.IFILE);
                        IDocument document = textFileBuffer.getDocument();
                        TextEdit edit = rewrite.rewriteAST(document, null);
                        edit.apply(document);
                        textFileBuffer.commit(monitor, true);
                    }
                    finally {
                        bufferManager.disconnect(path, LocationKind.IFILE, null);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private List<String> getSuperTypes(IType type, boolean getSuperClassOnly) {
        ArrayList<String> types = new ArrayList<String>();
        try {
            String superClass = type.getSuperclassName();
            if (superClass != null) {
                types.add(superClass);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        if (!getSuperClassOnly) {
            try {
                String[] interfaces = type.getSuperInterfaceNames();
                if (interfaces != null) {
                    types.addAll(Arrays.asList(interfaces));
                }
            }
            catch (JavaModelException e) {
                e.printStackTrace();
            }
        }
        ArrayList<String> result = new ArrayList<String>();
        try {
            for (String t : types) {
                String[][] tt = type.resolveType(t);
                if (tt == null) continue;
                String pckName = tt[0][0];
                pckName = String.valueOf(pckName) + (pckName.length() > 0 ? "." : "");
                pckName = String.valueOf(pckName) + tt[0][1];
                result.add(pckName);
            }
        }
        catch (JavaModelException e) {
            e.printStackTrace();
        }
        return result;
    }
}

