/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.stp.sca.common.internal.builder.ScaMarkerHelper;
import org.eclipse.stp.sca.common.internal.provisional.builder.ScaAbstractValidationExtension;
import org.eclipse.stp.sca.common.internal.provisional.builder.ScaValidator;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaResourceFiltersEPManager;
import org.eclipse.stp.sca.common.utils.ResourceUtils;

public class ScaIncrementalBuilder
extends IncrementalProjectBuilder {
    public static String SCA_BUILDER_EXTENSION_POINT = "org.eclipse.stp.sca.common.scaBuilderExtension";
    private ScaValidator scaValidator = new ScaValidator();

    public ScaIncrementalBuilder() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor(SCA_BUILDER_EXTENSION_POINT);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement filterElement = extensions[i];
            String theClassName = filterElement.getAttribute("class");
            if (theClassName != null && theClassName.length() != 0) {
                try {
                    Object theClass = filterElement.createExecutableExtension("class");
                    this.scaValidator.addValidationExtension((ScaAbstractValidationExtension)theClass);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6) {
            this.fullBuild(monitor);
        } else {
            IResourceDelta delta = this.getDelta(this.getProject());
            if (delta == null) {
                this.fullBuild(monitor);
            } else {
                this.incrementalBuild(delta, monitor);
            }
        }
        return null;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        try {
            ScaIncrementalBuilder.clearScaMarkers((IResource)this.getProject(), 2);
            List<IFile> compositeFiles = ResourceUtils.getFiles((IContainer)this.getProject(), "composite");
            compositeFiles = ScaResourceFiltersEPManager.getInstance().filterAllowedFiles(compositeFiles);
            this.scaValidator.clearResources();
            for (IFile file : compositeFiles) {
                this.scaValidator.loadResource(file.getLocation().toFile());
            }
            Map<Diagnostic, File> diagnostics = this.scaValidator.performValidation();
            ScaMarkerHelper.createAllScaMarkers(diagnostics);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void clearScaMarkers(IResource resource, int depth) {
        try {
            resource.deleteMarkers("org.eclipse.stp.sca.common.composite", true, depth);
            resource.deleteMarkers("org.eclipse.stp.sca.common.fDiagram", true, depth);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        ScaIncrementalBuilder.clearScaMarkers((IResource)this.getProject(), 2);
        ValidatingScaDeltaVisitor visitor = new ValidatingScaDeltaVisitor(monitor);
        delta.accept((IResourceDeltaVisitor)visitor);
        if (visitor.javaResourcesChanged) {
            this.fullBuild(monitor);
            return;
        }
        List<IFile> filesToValidate = ScaResourceFiltersEPManager.getInstance().filterAllowedFiles(visitor.getAllowedFiles());
        for (IFile file : filesToValidate) {
            this.scaValidator.loadResource(file.getLocation().toFile());
        }
        Map<Diagnostic, File> diagnostics = this.scaValidator.performValidation();
        ScaMarkerHelper.createAllScaMarkers(diagnostics);
    }

    protected void checkCancel(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.forgetLastBuiltState();
            throw new OperationCanceledException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ValidatingScaDeltaVisitor
    implements IResourceDeltaVisitor {
        private IProgressMonitor monitor;
        private List<IFile> allowedFiles = new ArrayList<IFile>();
        private boolean javaResourcesChanged = false;

        public ValidatingScaDeltaVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IFile file;
            ScaIncrementalBuilder.this.checkCancel(this.monitor);
            IResource resource = delta.getResource();
            if (resource instanceof IProject && !((IProject)resource).isOpen()) {
                return false;
            }
            if (resource instanceof IFile && (file = (IFile)resource).getFileExtension().equals("composite")) {
                ScaIncrementalBuilder.this.scaValidator.removeResource(file.getLocation().toFile());
                if (file.exists()) {
                    this.allowedFiles.add(file);
                }
            }
            return true;
        }

        public List<IFile> getAllowedFiles() {
            return this.allowedFiles;
        }
    }
}

