/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.provisional.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaAbstractResourcesFilter;
import org.eclipse.stp.sca.common.utils.ResourceFilterUtils;
import org.eclipse.stp.sca.common.utils.ResourceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaResourceFiltersEPManager {
    public static String SCA_FILTERS_EXTENSION_POINT = "org.eclipse.stp.sca.common.scaResourceFilters";
    private static ScaResourceFiltersEPManager instance = new ScaResourceFiltersEPManager();
    private Collection<ScaAbstractResourcesFilter<?>> filters = new ArrayList();
    private ResourceFilterUtils<IFile> fileFilterUtils = new ResourceFilterUtils();
    private ResourceFilterUtils<IFolder> folderFilterUtils = new ResourceFilterUtils();

    private ScaResourceFiltersEPManager() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] extensions = reg.getConfigurationElementsFor(SCA_FILTERS_EXTENSION_POINT);
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement filterElement = extensions[i];
            String theClassName = filterElement.getAttribute("class");
            if (theClassName != null && theClassName.length() != 0) {
                try {
                    Object theClass = filterElement.createExecutableExtension("class");
                    this.filters.add((ScaAbstractResourcesFilter)theClass);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public static ScaResourceFiltersEPManager getInstance() {
        return instance;
    }

    public boolean isFolderToSkip(IFolder folder) {
        for (ScaAbstractResourcesFilter<?> filter : this.filters) {
            if (!filter.isFolderToSkip(folder)) continue;
            return true;
        }
        return false;
    }

    public Set<IFolder> getFoldersToSkip(IProject project) {
        HashSet<IFolder> folders = new HashSet<IFolder>();
        for (ScaAbstractResourcesFilter<?> filter : this.filters) {
            Set<IFolder> fs = filter.getFoldersToSkip(project);
            if (fs == null) continue;
            folders.addAll(fs);
        }
        return folders;
    }

    public Collection<IFolder> getValidFolders(IProject project) {
        List<IFolder> foldersToFilter = ResourceUtils.getFolders((IContainer)project);
        Set<IFolder> foldersToSkip = this.getFoldersToSkip(project);
        return this.folderFilterUtils.filterAllowedResources(foldersToFilter, foldersToSkip);
    }

    public List<IFile> filterAllowedFiles(List<IFile> filesToFilter) {
        if (filesToFilter.isEmpty()) {
            return filesToFilter;
        }
        Set<IFolder> foldersToSkip = this.getFoldersToSkip(filesToFilter.get(0).getProject());
        return this.fileFilterUtils.filterAllowedResources(filesToFilter, foldersToSkip);
    }
}

