/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.utils;

import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DomUtils {
    public static String getNodeName(Node node) {
        String name;
        String string = name = node.getNamespaceURI() != null ? node.getLocalName() : node.getNodeName();
        if (name.contains(":")) {
            String[] parts = name.split(":");
            name = parts[parts.length - 1];
        }
        return name;
    }

    public static String lookupNamespaceURI(String prefix, Node node) {
        return DomUtils.getNamespaceMappings(node).get(prefix);
    }

    public static String lookupNamespacePrefix(String namespaceURI, Node node) {
        for (Map.Entry<String, String> entry : DomUtils.getNamespaceMappings(node).entrySet()) {
            if (!entry.getValue().equals(namespaceURI)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Map<String, String> getNamespaceMappings(Node node) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        boolean firstLoop = true;
        Node n = node;
        while (n != null) {
            if (firstLoop && n.getNamespaceURI() != null) {
                namespaces.put("", n.getNamespaceURI());
                firstLoop = false;
            }
            if (n.getAttributes() != null) {
                int i = 0;
                while (i < n.getAttributes().getLength()) {
                    String attrName = n.getAttributes().item(i).getNodeName();
                    if (attrName.startsWith("xmlns")) {
                        String prefix = "";
                        if (attrName.contains(":")) {
                            prefix = attrName.split(":")[1];
                        }
                        String uri = n.getAttributes().item(i).getNodeValue();
                        namespaces.put(prefix, uri);
                    }
                    ++i;
                }
            }
            n = n.getParentNode();
        }
        return namespaces;
    }
}

