/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.java;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.editparts.AbstractConnectionEditPart;
import org.eclipse.gmf.runtime.common.core.service.AbstractProvider;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.common.ui.resources.FileChangeManager;
import org.eclipse.gmf.runtime.common.ui.resources.IFileObserver;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.AbstractDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.CreateDecoratorsOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecorator;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.decorator.IDecoratorTarget;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.sca.BaseReference;
import org.eclipse.stp.sca.BaseService;
import org.eclipse.stp.sca.Binding;
import org.eclipse.stp.sca.Implementation;
import org.eclipse.stp.sca.Interface;
import org.eclipse.stp.sca.common.utils.ScaSignature;
import org.eclipse.stp.sca.diagram.java.Activator;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditor;
import org.eclipse.stp.sca.diagram.part.ScaDiagramEditorPlugin;
import org.eclipse.stp.sca.diagram.part.ScaVisualIDRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class ScaBuilderDecoratorProvider
extends AbstractProvider
implements IDecoratorProvider {
    private static final String KEY = "scaBuilderStatus";
    private static final String MARKER_TYPE = "org.eclipse.stp.sca.common.composite";
    private static MarkerObserver fileObserver;
    private static Map allDecorators;
    private static Map<String, String> scaSignatureToViewId;

    static {
        allDecorators = new HashMap();
        scaSignatureToViewId = new HashMap<String, String>();
    }

    public void createDecorators(IDecoratorTarget decoratorTarget) {
        EditPart editPart = (EditPart)decoratorTarget.getAdapter(EditPart.class);
        if (editPart instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart || editPart instanceof AbstractConnectionEditPart) {
            View view;
            Object model = editPart.getModel();
            if (model instanceof View && !((view = (View)model) instanceof Edge) && !view.isSetElement()) {
                return;
            }
            EditDomain ed = editPart.getViewer().getEditDomain();
            if (!(ed instanceof DiagramEditDomain)) {
                return;
            }
            if (((DiagramEditDomain)ed).getEditorPart() instanceof ScaDiagramEditor) {
                decoratorTarget.installDecorator((Object)KEY, (IDecorator)new ScaBuilderStatusDecorator(decoratorTarget));
            }
        }
    }

    public boolean provides(IOperation operation) {
        if (!(operation instanceof CreateDecoratorsOperation)) {
            return false;
        }
        IDecoratorTarget decoratorTarget = ((CreateDecoratorsOperation)operation).getDecoratorTarget();
        View view = (View)decoratorTarget.getAdapter(View.class);
        return view != null && "Sca".equals(ScaVisualIDRegistry.getModelID((View)view));
    }

    public static void refreshDecorators(View view) {
        ScaBuilderDecoratorProvider.refreshDecorators(ViewUtil.getIdStr((View)view), view.getDiagram());
    }

    private static void refreshDecorators(String viewId, Diagram diagram) {
        List decorators;
        List list = decorators = viewId != null ? (List)allDecorators.get(viewId) : null;
        if (decorators == null || decorators.isEmpty() || diagram == null) {
            return;
        }
        Diagram fdiagram = diagram;
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    TransactionUtil.getEditingDomain((EObject)fdiagram).runExclusive(new Runnable(){

                        public void run() {
                            for (IDecorator decorator : decorators) {
                                decorator.refresh();
                            }
                        }
                    });
                }
                catch (Exception e) {
                    ScaDiagramEditorPlugin.getInstance().logError("Decorator refresh failure", (Throwable)e);
                }
            }
        });
    }

    private static class MarkerObserver
    implements IFileObserver {
        private Diagram diagram;

        private MarkerObserver(Diagram diagram) {
            this.diagram = diagram;
        }

        public void handleFileRenamed(IFile oldFile, IFile file) {
        }

        public void handleFileMoved(IFile oldFile, IFile file) {
        }

        public void handleFileDeleted(IFile file) {
        }

        public void handleFileChanged(IFile file) {
        }

        public void handleMarkerAdded(IMarker marker) {
            if (marker.getAttribute("signature", null) != null) {
                this.handleMarkerChanged(marker);
            }
        }

        public void handleMarkerDeleted(IMarker marker, Map attributes) {
            String scaSignature = (String)attributes.get("signature");
            String viewId = this.getViewId(scaSignature, this.diagram);
            if (viewId == null) {
                viewId = (String)scaSignatureToViewId.get(scaSignature);
                scaSignatureToViewId.remove(scaSignature);
            }
            if (viewId != null) {
                ScaBuilderDecoratorProvider.refreshDecorators(viewId, this.diagram);
            }
        }

        public void handleMarkerChanged(IMarker marker) {
            if (!ScaBuilderDecoratorProvider.MARKER_TYPE.equals(this.getType(marker))) {
                return;
            }
            String scaSignature = marker.getAttribute("signature", "");
            String viewId = this.getViewId(scaSignature, this.diagram);
            if (viewId == null) {
                viewId = (String)scaSignatureToViewId.get(scaSignature);
                scaSignatureToViewId.remove(scaSignature);
            } else {
                scaSignatureToViewId.put(scaSignature, viewId);
            }
            if (viewId != null) {
                ScaBuilderDecoratorProvider.refreshDecorators(viewId, this.diagram);
            }
        }

        private String getType(IMarker marker) {
            try {
                return marker.getType();
            }
            catch (CoreException e) {
                ScaDiagramEditorPlugin.getInstance().logError("Validation marker refresh failure", (Throwable)e);
                return "";
            }
        }

        public String getViewId(String scaSignature, Diagram diagram) {
            TreeIterator it = diagram.eAllContents();
            while (it.hasNext()) {
                String sig;
                View view;
                EObject eo = (EObject)it.next();
                if (!(eo instanceof View) || (eo = (view = (View)eo).getElement()) == null || !(sig = new ScaSignature(eo).toString()).equals(scaSignature)) continue;
                return ViewUtil.getIdStr((View)view);
            }
            return null;
        }
    }

    public static class ScaBuilderStatusDecorator
    extends AbstractDecorator {
        private String viewId;

        public ScaBuilderStatusDecorator(IDecoratorTarget decoratorTarget) {
            super(decoratorTarget);
            try {
                final View view = (View)this.getDecoratorTarget().getAdapter(View.class);
                TransactionUtil.getEditingDomain((EObject)view).runExclusive(new Runnable(){

                    public void run() {
                        ScaBuilderStatusDecorator.this.viewId = view != null ? ViewUtil.getIdStr((View)view) : null;
                    }
                });
            }
            catch (Exception e) {
                ScaDiagramEditorPlugin.getInstance().logError("ViewID access failure", (Throwable)e);
            }
        }

        private String getScaSignature(View view) {
            EObject eo = view.getElement();
            if (eo == null) {
                return null;
            }
            return new ScaSignature(eo).toString();
        }

        public void refresh() {
            String scaSignature;
            boolean getOverlay;
            this.removeDecoration();
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null || view.eResource() == null) {
                return;
            }
            EditPart editPart = (EditPart)this.getDecoratorTarget().getAdapter(EditPart.class);
            if (editPart == null || editPart.getViewer() == null) {
                return;
            }
            boolean bl = getOverlay = view.getElement() != null;
            if (getOverlay) {
                boolean bl2 = getOverlay = view.getElement() instanceof Implementation || view.getElement() instanceof Binding || view.getElement() instanceof Interface || view.getElement() instanceof BaseService || view.getElement() instanceof BaseReference;
            }
            if ((scaSignature = this.getScaSignature(view)) == null) {
                return;
            }
            int severity = 0;
            IMarker foundMarker = null;
            IFile resource = WorkspaceSynchronizer.getFile((Resource)view.eResource());
            if (resource == null || !resource.exists()) {
                return;
            }
            if (!resource.getFileExtension().equalsIgnoreCase("composite_diagram")) {
                return;
            }
            IPath path = new Path(resource.getName()).removeFileExtension().addFileExtension("composite");
            if ((resource = resource.getParent().getFile(path)) == null || !resource.exists()) {
                return;
            }
            IMarker[] markers = null;
            try {
                markers = resource.findMarkers(ScaBuilderDecoratorProvider.MARKER_TYPE, true, 2);
            }
            catch (CoreException e) {
                ScaDiagramEditorPlugin.getInstance().logError("Validation markers refresh failure", (Throwable)e);
            }
            if (markers == null || markers.length == 0) {
                return;
            }
            Label toolTip = null;
            int i = 0;
            while (i < markers.length) {
                IMarker marker = markers[i];
                String attribute = marker.getAttribute("signature", "");
                if (attribute.equals(scaSignature)) {
                    int nextSeverity = marker.getAttribute("severity", 0);
                    Image nextImage = this.getImage(nextSeverity, getOverlay);
                    if (foundMarker == null) {
                        foundMarker = marker;
                        toolTip = new Label(marker.getAttribute("message", ""), nextImage);
                    } else {
                        if (toolTip.getChildren().isEmpty()) {
                            Label comositeLabel = new Label();
                            FlowLayout fl = new FlowLayout(false);
                            fl.setMinorSpacing(0);
                            comositeLabel.setLayoutManager((LayoutManager)fl);
                            comositeLabel.add((IFigure)toolTip);
                            toolTip = comositeLabel;
                        }
                        toolTip.add((IFigure)new Label(marker.getAttribute("message", ""), nextImage));
                    }
                    severity = nextSeverity > severity ? nextSeverity : severity;
                }
                ++i;
            }
            if (foundMarker == null) {
                return;
            }
            if (editPart instanceof GraphicalEditPart) {
                if (view instanceof Edge) {
                    this.setDecoration(this.getDecoratorTarget().addConnectionDecoration(this.getImage(severity, getOverlay), 50, true));
                } else {
                    int margin = -1;
                    margin = MapModeUtil.getMapMode((IFigure)((GraphicalEditPart)editPart).getFigure()).DPtoLP(margin);
                    IDecoratorTarget.Direction direction = getOverlay ? (view.getElement() instanceof BaseService || view.getElement() instanceof BaseReference ? IDecoratorTarget.Direction.CENTER : (view.getElement() instanceof Binding ? IDecoratorTarget.Direction.SOUTH_WEST : (view.getElement() instanceof Interface ? IDecoratorTarget.Direction.NORTH_WEST : (view.getElement() instanceof Implementation ? IDecoratorTarget.Direction.SOUTH_WEST : IDecoratorTarget.Direction.NORTH_EAST)))) : IDecoratorTarget.Direction.NORTH_EAST;
                    this.setDecoration(this.getDecoratorTarget().addShapeDecoration(this.getImage(severity, getOverlay), direction, margin, true));
                }
                this.getDecoration().setToolTip(toolTip);
            }
        }

        private Image getImage(int severity, boolean getOverlay) {
            if (!getOverlay) {
                String imageName = "IMG_OBJS_ERROR_TSK";
                switch (severity) {
                    case 2: {
                        imageName = "IMG_OBJS_ERROR_TSK";
                        break;
                    }
                    case 1: {
                        imageName = "IMG_OBJS_WARN_TSK";
                        break;
                    }
                    default: {
                        imageName = "IMG_OBJS_INFO_TSK";
                    }
                }
                return PlatformUI.getWorkbench().getSharedImages().getImage(imageName);
            }
            switch (severity) {
                case 2: {
                    return Activator.getDefault().getImageRegistry().get("ErrorOverlayForSCAdiagrams");
                }
                case 1: {
                    return Activator.getDefault().getImageRegistry().get("WarningOverlayForSCAdiagrams");
                }
            }
            return null;
        }

        public void activate() {
            if (this.viewId == null) {
                return;
            }
            ArrayList<ScaBuilderStatusDecorator> list = (ArrayList<ScaBuilderStatusDecorator>)allDecorators.get(this.viewId);
            if (list == null) {
                list = new ArrayList<ScaBuilderStatusDecorator>(2);
                list.add(this);
                allDecorators.put(this.viewId, list);
            } else if (!list.contains((Object)this)) {
                list.add(this);
            }
            View view = (View)this.getDecoratorTarget().getAdapter(View.class);
            if (view == null) {
                return;
            }
            Diagram diagramView = view.getDiagram();
            if (diagramView == null) {
                return;
            }
            if (fileObserver == null) {
                FileChangeManager fileChangeManager = FileChangeManager.getInstance();
                MarkerObserver markerObserver = new MarkerObserver(diagramView);
                fileObserver = markerObserver;
                fileChangeManager.addFileObserver((IFileObserver)markerObserver);
            }
        }

        public void deactivate() {
            if (this.viewId == null) {
                return;
            }
            List list = (List)allDecorators.get(this.viewId);
            if (list != null) {
                list.remove((Object)this);
                if (list.isEmpty()) {
                    allDecorators.remove(this.viewId);
                }
            }
            if (fileObserver != null && allDecorators.isEmpty()) {
                FileChangeManager.getInstance().removeFileObserver((IFileObserver)fileObserver);
                fileObserver = null;
            }
            super.deactivate();
        }
    }
}

