/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.java.dnd;

import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.JavaImplementation;
import org.eclipse.stp.sca.common.classloader.ScaClassLoader;
import org.eclipse.stp.sca.diagram.java.Activator;
import org.eclipse.stp.sca.introspection.JavaInterfaceResolver;
import org.eclipse.stp.sca.introspection.metadata.MetaData;

public class Utils {
    static int getJavaType(IFile file, String className) {
        Class clazz;
        block12: {
            block11: {
                block10: {
                    block9: {
                        block8: {
                            try {
                                ScaClassLoader classLoader = Utils.getClassLoader(file);
                                clazz = classLoader.loadClass(className);
                                if (!clazz.isInterface()) break block8;
                                return 1;
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                                return -1;
                            }
                        }
                        if (!clazz.isLocalClass()) break block9;
                        return 2;
                    }
                    if (!clazz.isMemberClass()) break block10;
                    return 3;
                }
                if (!clazz.isAnonymousClass()) break block11;
                return 4;
            }
            if (!clazz.isSynthetic()) break block12;
            return 5;
        }
        if (clazz.isPrimitive()) {
            return 6;
        }
        return 0;
    }

    static Object computeComponentName(String className) {
        return String.valueOf(className.substring(className.lastIndexOf(".") + 1, className.length())) + "Component";
    }

    static void launchIntrospection(Component component) {
        ScaClassLoader scaClassLoader = Utils.getClassLoader(component);
        if (scaClassLoader == null) {
            return;
        }
        JavaInterfaceResolver javaInterfaceResolver = new JavaInterfaceResolver((ClassLoader)scaClassLoader);
        Class cl = null;
        try {
            if (component.getImplementation() == null) {
                return;
            }
            cl = scaClassLoader.loadClass(((JavaImplementation)component.getImplementation()).getClass_());
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return;
        }
        MetaData ccmd = new MetaData(cl);
        javaInterfaceResolver.resolveServices(component, ccmd);
        javaInterfaceResolver.resolveReferences(component, ccmd);
    }

    public static ScaClassLoader getClassLoader(Component component) {
        Resource eResource = component.eResource();
        URI eUri = eResource.getURI();
        IFile compositeFile = null;
        if (!eUri.isPlatformResource()) {
            return null;
        }
        String platformString = eUri.toPlatformString(true);
        compositeFile = (IFile)ResourcesPlugin.getWorkspace().getRoot().findMember(platformString);
        return Utils.getClassLoader(compositeFile);
    }

    public static ScaClassLoader getClassLoader(IFile compositeFile) {
        IJavaProject javaProject = Utils.getAssociatedJavaProject(compositeFile);
        if (javaProject == null) {
            return null;
        }
        URL[] urls = null;
        try {
            ArrayList<URL> urlList = new ArrayList<URL>();
            String projectLocation = compositeFile.getProject().getLocationURI().toString();
            String binLocation = String.valueOf(javaProject.getOutputLocation().toString().replace(String.valueOf(javaProject.getProject().getName()) + "/", "")) + "/";
            java.net.URI uri = new java.net.URI(String.valueOf(projectLocation) + binLocation);
            urlList.add(uri.toURL());
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(false);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry iClasspathEntry = iClasspathEntryArray[n2];
                ++n2;
            }
            urls = new URL[urlList.size()];
            int i = 0;
            while (i < urlList.size()) {
                urls[i] = (URL)urlList.get(i);
                ++i;
            }
        }
        catch (URISyntaxException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.diagram.java", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return null;
        }
        catch (MalformedURLException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.diagram.java", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return null;
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.diagram.java", e.getMessage(), (Throwable)e);
            Activator.getDefault().getLog().log((IStatus)status);
            return null;
        }
        return new ScaClassLoader(urls, Utils.class.getClassLoader());
    }

    private static IJavaProject getAssociatedJavaProject(IFile compositeFile) {
        IProject project = compositeFile.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        if (javaProject == null || !javaProject.exists()) {
            String msg = "No Java project defined for" + compositeFile.getName();
            Status status = new Status(4, "org.eclipse.stp.sca.diagram.java", msg);
            Activator.getDefault().getLog().log((IStatus)status);
            return null;
        }
        return javaProject;
    }
}

