/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.navigator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.util.WorkspaceSynchronizer;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.stp.sca.diagram.navigator.ScaAbstractNavigatorItem;
import org.eclipse.stp.sca.diagram.navigator.ScaNavigatorGroup;
import org.eclipse.stp.sca.diagram.navigator.ScaNavigatorItem;
import org.eclipse.stp.sca.diagram.part.Messages;
import org.eclipse.stp.sca.diagram.part.ScaVisualIDRegistry;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonContentProvider;

public class ScaNavigatorContentProvider
implements ICommonContentProvider {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Viewer myViewer;
    private AdapterFactoryEditingDomain myEditingDomain;
    private WorkspaceSynchronizer myWorkspaceSynchronizer;
    private Runnable myViewerRefreshRunnable;

    public ScaNavigatorContentProvider() {
        TransactionalEditingDomain editingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        this.myEditingDomain = (AdapterFactoryEditingDomain)editingDomain;
        this.myEditingDomain.setResourceToReadOnlyMap((Map)new HashMap(){

            public Object get(Object key) {
                if (!this.containsKey(key)) {
                    this.put(key, Boolean.TRUE);
                }
                return super.get(key);
            }
        });
        this.myViewerRefreshRunnable = new Runnable(){

            public void run() {
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.refresh();
                }
            }
        };
        this.myWorkspaceSynchronizer = new WorkspaceSynchronizer(editingDomain, new WorkspaceSynchronizer.Delegate(){

            public void dispose() {
            }

            public boolean handleResourceChanged(Resource resource) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceDeleted(Resource resource) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }

            public boolean handleResourceMoved(Resource resource, URI newURI) {
                for (Resource nextResource : ScaNavigatorContentProvider.this.myEditingDomain.getResourceSet().getResources()) {
                    nextResource.unload();
                }
                if (ScaNavigatorContentProvider.this.myViewer != null) {
                    ScaNavigatorContentProvider.this.myViewer.getControl().getDisplay().asyncExec(ScaNavigatorContentProvider.this.myViewerRefreshRunnable);
                }
                return true;
            }
        });
    }

    public void dispose() {
        this.myWorkspaceSynchronizer.dispose();
        this.myWorkspaceSynchronizer = null;
        this.myViewerRefreshRunnable = null;
        for (Resource resource : this.myEditingDomain.getResourceSet().getResources()) {
            resource.unload();
        }
        ((TransactionalEditingDomain)this.myEditingDomain).dispose();
        this.myEditingDomain = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement instanceof IFile) {
            IFile file = (IFile)parentElement;
            URI fileURI = URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
            Resource resource = this.myEditingDomain.getResourceSet().getResource(fileURI, true);
            ArrayList result = new ArrayList();
            result.addAll(this.createNavigatorItems(this.selectViewsByType((Collection)resource.getContents(), "Sca"), file, false));
            return result.toArray();
        }
        if (parentElement instanceof ScaNavigatorGroup) {
            ScaNavigatorGroup group = (ScaNavigatorGroup)((Object)parentElement);
            return group.getChildren();
        }
        if (parentElement instanceof ScaNavigatorItem) {
            ScaNavigatorItem navigatorItem = (ScaNavigatorItem)((Object)parentElement);
            if (navigatorItem.isLeaf() || !this.isOwnView(navigatorItem.getView())) {
                return EMPTY_ARRAY;
            }
            return this.getViewChildren(navigatorItem.getView(), parentElement);
        }
        return EMPTY_ARRAY;
    }

    private Object[] getViewChildren(View view, Object parentElement) {
        switch (ScaVisualIDRegistry.getVisualID(view)) {
            case 1000: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup links = new ScaNavigatorGroup(Messages.NavigatorGroupName_DocumentRoot_1000_links, "icons/linksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 2001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 4001);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 4002);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 4003);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                connectedViews = this.getDiagramLinksByType(Collections.singleton(view), 4004);
                links.addChildren(this.createNavigatorItems(connectedViews, (Object)links, false));
                if (!links.isEmpty()) {
                    result.add(links);
                }
                return result.toArray();
            }
            case 2001: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7001);
                connectedViews = this.getChildrenByType(connectedViews, 3001);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7002);
                connectedViews = this.getChildrenByType(connectedViews, 3006);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7003);
                connectedViews = this.getChildrenByType(connectedViews, 3011);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7004);
                connectedViews = this.getChildrenByType(connectedViews, 3012);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 3001: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup outgoinglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_Service_3001_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup incominglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_Service_3001_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7005);
                connectedViews = this.getChildrenByType(connectedViews, 3002);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7005);
                connectedViews = this.getChildrenByType(connectedViews, 3003);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7005);
                connectedViews = this.getChildrenByType(connectedViews, 3026);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7005);
                connectedViews = this.getChildrenByType(connectedViews, 3027);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7006);
                connectedViews = this.getChildrenByType(connectedViews, 3004);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7006);
                connectedViews = this.getChildrenByType(connectedViews, 3005);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7006);
                connectedViews = this.getChildrenByType(connectedViews, 3028);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7006);
                connectedViews = this.getChildrenByType(connectedViews, 3029);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4002);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4004);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3006: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup outgoinglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_Reference_3006_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7007);
                connectedViews = this.getChildrenByType(connectedViews, 3007);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7007);
                connectedViews = this.getChildrenByType(connectedViews, 3008);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7007);
                connectedViews = this.getChildrenByType(connectedViews, 3030);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7007);
                connectedViews = this.getChildrenByType(connectedViews, 3031);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7008);
                connectedViews = this.getChildrenByType(connectedViews, 3009);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7008);
                connectedViews = this.getChildrenByType(connectedViews, 3010);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7008);
                connectedViews = this.getChildrenByType(connectedViews, 3032);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7008);
                connectedViews = this.getChildrenByType(connectedViews, 3033);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4001);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4004);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 3012: {
                ArrayList result = new ArrayList();
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7009);
                connectedViews = this.getChildrenByType(connectedViews, 3013);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7011);
                connectedViews = this.getChildrenByType(connectedViews, 3018);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7012);
                connectedViews = this.getChildrenByType(connectedViews, 3023);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7010);
                connectedViews = this.getChildrenByType(connectedViews, 3024);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7010);
                connectedViews = this.getChildrenByType(connectedViews, 3025);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7010);
                connectedViews = this.getChildrenByType(connectedViews, 3042);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7010);
                connectedViews = this.getChildrenByType(connectedViews, 3043);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7010);
                connectedViews = this.getChildrenByType(connectedViews, 3044);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7010);
                connectedViews = this.getChildrenByType(connectedViews, 3045);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7010);
                connectedViews = this.getChildrenByType(connectedViews, 3046);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                return result.toArray();
            }
            case 3013: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup incominglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_ComponentService_3013_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7013);
                connectedViews = this.getChildrenByType(connectedViews, 3014);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7013);
                connectedViews = this.getChildrenByType(connectedViews, 3015);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7013);
                connectedViews = this.getChildrenByType(connectedViews, 3034);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7013);
                connectedViews = this.getChildrenByType(connectedViews, 3035);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7014);
                connectedViews = this.getChildrenByType(connectedViews, 3016);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7014);
                connectedViews = this.getChildrenByType(connectedViews, 3017);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7014);
                connectedViews = this.getChildrenByType(connectedViews, 3036);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7014);
                connectedViews = this.getChildrenByType(connectedViews, 3037);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4002);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4003);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4004);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                return result.toArray();
            }
            case 3018: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup incominglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_ComponentReference_3018_incominglinks, "icons/incomingLinksNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup outgoinglinks = new ScaNavigatorGroup(Messages.NavigatorGroupName_ComponentReference_3018_outgoinglinks, "icons/outgoingLinksNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getChildrenByType(Collections.singleton(view), 7015);
                connectedViews = this.getChildrenByType(connectedViews, 3019);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7015);
                connectedViews = this.getChildrenByType(connectedViews, 3020);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7015);
                connectedViews = this.getChildrenByType(connectedViews, 3038);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7015);
                connectedViews = this.getChildrenByType(connectedViews, 3039);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7016);
                connectedViews = this.getChildrenByType(connectedViews, 3021);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7016);
                connectedViews = this.getChildrenByType(connectedViews, 3022);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7016);
                connectedViews = this.getChildrenByType(connectedViews, 3040);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getChildrenByType(Collections.singleton(view), 7016);
                connectedViews = this.getChildrenByType(connectedViews, 3041);
                result.addAll(this.createNavigatorItems(connectedViews, parentElement, false));
                connectedViews = this.getIncomingLinksByType(Collections.singleton(view), 4001);
                incominglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)incominglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4003);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                connectedViews = this.getOutgoingLinksByType(Collections.singleton(view), 4004);
                outgoinglinks.addChildren(this.createNavigatorItems(connectedViews, (Object)outgoinglinks, true));
                if (!incominglinks.isEmpty()) {
                    result.add(incominglinks);
                }
                if (!outgoinglinks.isEmpty()) {
                    result.add(outgoinglinks);
                }
                return result.toArray();
            }
            case 4001: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_ReferencePromote2_4001_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_ReferencePromote2_4001_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 3018);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 3006);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4002: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_ServicePromote2_4002_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_ServicePromote2_4002_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 3013);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 3001);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4003: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_Wire_4003_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_Wire_4003_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 3013);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 3018);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
            case 4004: {
                ArrayList<ScaNavigatorGroup> result = new ArrayList<ScaNavigatorGroup>();
                ScaNavigatorGroup target = new ScaNavigatorGroup(Messages.NavigatorGroupName_BaseReferenceTarget2_4004_target, "icons/linkTargetNavigatorGroup.gif", parentElement);
                ScaNavigatorGroup source = new ScaNavigatorGroup(Messages.NavigatorGroupName_BaseReferenceTarget2_4004_source, "icons/linkSourceNavigatorGroup.gif", parentElement);
                Collection connectedViews = this.getLinksTargetByType(Collections.singleton(view), 3001);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksTargetByType(Collections.singleton(view), 3013);
                target.addChildren(this.createNavigatorItems(connectedViews, (Object)target, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 3006);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                connectedViews = this.getLinksSourceByType(Collections.singleton(view), 3018);
                source.addChildren(this.createNavigatorItems(connectedViews, (Object)source, true));
                if (!target.isEmpty()) {
                    result.add(target);
                }
                if (!source.isEmpty()) {
                    result.add(source);
                }
                return result.toArray();
            }
        }
        return EMPTY_ARRAY;
    }

    private Collection getLinksSourceByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeSource = nextEdge.getSource();
            if (!type.equals(nextEdgeSource.getType()) || !this.isOwnView(nextEdgeSource)) continue;
            result.add(nextEdgeSource);
        }
        return result;
    }

    private Collection getLinksTargetByType(Collection edges, int visualID) {
        ArrayList<View> result = new ArrayList<View>();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (Edge nextEdge : edges) {
            View nextEdgeTarget = nextEdge.getTarget();
            if (!type.equals(nextEdgeTarget.getType()) || !this.isOwnView(nextEdgeTarget)) continue;
            result.add(nextEdgeTarget);
        }
        return result;
    }

    private Collection getOutgoingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getSourceEdges(), type));
        }
        return result;
    }

    private Collection getIncomingLinksByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getTargetEdges(), type));
        }
        return result;
    }

    private Collection getChildrenByType(Collection nodes, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (View nextNode : nodes) {
            result.addAll(this.selectViewsByType((Collection)nextNode.getChildren(), type));
        }
        return result;
    }

    private Collection getDiagramLinksByType(Collection diagrams, int visualID) {
        ArrayList result = new ArrayList();
        String type = ScaVisualIDRegistry.getType(visualID);
        for (Diagram nextDiagram : diagrams) {
            result.addAll(this.selectViewsByType((Collection)nextDiagram.getEdges(), type));
        }
        return result;
    }

    private Collection selectViewsByType(Collection views, String type) {
        ArrayList<View> result = new ArrayList<View>();
        for (View nextView : views) {
            if (!type.equals(nextView.getType()) || !this.isOwnView(nextView)) continue;
            result.add(nextView);
        }
        return result;
    }

    private boolean isOwnView(View view) {
        return "Sca".equals(ScaVisualIDRegistry.getModelID(view));
    }

    private Collection createNavigatorItems(Collection views, Object parent, boolean isLeafs) {
        ArrayList<ScaNavigatorItem> result = new ArrayList<ScaNavigatorItem>();
        Iterator it = views.iterator();
        while (it.hasNext()) {
            result.add(new ScaNavigatorItem((View)it.next(), parent, isLeafs));
        }
        return result;
    }

    public Object getParent(Object element) {
        if (element instanceof ScaAbstractNavigatorItem) {
            ScaAbstractNavigatorItem abstractNavigatorItem = (ScaAbstractNavigatorItem)((Object)element);
            return abstractNavigatorItem.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof IFile || this.getChildren(element).length > 0;
    }
}

