/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.outline;

import org.eclipse.core.resources.IFile;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stp.sca.common.utils.ResourceUtils;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.stp.sca.xmleditor.ScaXmlEditorPlugin;
import org.eclipse.stp.sca.xmleditor.utils.IncludesUtils;
import org.eclipse.stp.sca.xmleditor.utils.ScaUtils;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.w3c.dom.Node;

public class NodeActions {
    private Action openFileAction;
    private Action refreshViewerAction;
    private Action showPropertiesAction;
    static final ImageDescriptor showPropertiesActionImgDesc = ScaXmlEditorPlugin.getImageDescriptor("icons/full/elcl16/properties.gif");
    static final ImageDescriptor refreshViewerActionImgDesc = ScaXmlEditorPlugin.getImageDescriptor("icons/full/elcl16/refresh.gif");
    static final ImageDescriptor openFileActionImgDesc = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_OBJ_FOLDER");

    public void fillInContextMenu(TreeViewer treeViewer, IMenuManager manager) {
        ISelection selection;
        Object selected;
        if (this.openFileAction == null) {
            this.openFileAction = new Action(Messages.NodeActions_1, openFileActionImgDesc){

                public void run() {
                    try {
                        ISelection selection = treeViewer.getSelection();
                        Object selected = ((IStructuredSelection)selection).getFirstElement();
                        IFile editedFile = ResourceUtils.getIFileFromEditor();
                        IFile includedFile = IncludesUtils.getIncludedFile(selected, editedFile.getProject());
                        if (!includedFile.getName().endsWith(".composite")) {
                            ScaXmlEditorPlugin.log(Messages.NodeActions_4, null, 4);
                        }
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        IEditorDescriptor desc = PlatformUI.getWorkbench().getEditorRegistry().getDefaultEditor(includedFile.getName());
                        page.openEditor((IEditorInput)new FileEditorInput(includedFile), desc.getId());
                    }
                    catch (Exception e) {
                        ScaXmlEditorPlugin.log(null, e, 4);
                    }
                }
            };
        }
        if (this.refreshViewerAction == null) {
            this.refreshViewerAction = new Action(Messages.NodeActions_2, refreshViewerActionImgDesc){

                public void run() {
                    treeViewer.refresh();
                }
            };
        }
        if (this.showPropertiesAction == null) {
            this.showPropertiesAction = new Action(Messages.NodeActions_3, showPropertiesActionImgDesc){

                public void run() {
                    try {
                        ISelection selection = treeViewer.getSelection();
                        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                        page.showView("org.eclipse.ui.views.PropertySheet");
                        page.showView("org.eclipse.ui.views.ContentOutline");
                        treeViewer.setSelection(selection);
                    }
                    catch (Exception e) {
                        ScaXmlEditorPlugin.log(null, e, 4);
                    }
                }
            };
        }
        if (ScaUtils.isIncludeNode(selected = ((IStructuredSelection)(selection = treeViewer.getSelection())).getFirstElement())) {
            manager.add((IAction)this.openFileAction);
            manager.add((IAction)this.refreshViewerAction);
        }
        if (selected != null && Node.class.isAssignableFrom(selected.getClass())) {
            manager.add((IAction)this.showPropertiesAction);
        }
    }
}

