/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.outline;

import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.stp.sca.common.utils.DomUtils;
import org.eclipse.stp.sca.xmleditor.ImageRegistry;
import org.eclipse.stp.sca.xmleditor.utils.ScaUtils;
import org.eclipse.swt.graphics.Image;
import org.w3c.dom.Node;

public class ScaXmlLabelProvider
extends LabelProvider {
    public Image getImage(Object element) {
        if (element == null || !Node.class.isAssignableFrom(element.getClass())) {
            return null;
        }
        Node node = (Node)element;
        return ImageRegistry.getImage(node);
    }

    public String getText(Object element) {
        if (element == null) {
            return "";
        }
        if (element instanceof String) {
            return (String)element;
        }
        if (element instanceof Node) {
            Node node = (Node)element;
            String nodeName = DomUtils.getNodeName((Node)node);
            if ((nodeName = nodeName.toLowerCase()).equals("composite") || nodeName.equals("component") || nodeName.equals("service") || nodeName.equals("reference") || nodeName.equals("property")) {
                String name = ScaUtils.getAttributeValue(node, "name");
                return name == null ? "?" : name;
            }
            if (nodeName.equals("include")) {
                String includeName = ScaUtils.getAttributeValue(node, "name");
                includeName = includeName != null ? ScaUtils.removeNamespacePrefix(includeName) : "?";
                int lastIndex = includeName.lastIndexOf(125);
                if (lastIndex > 0) {
                    includeName = lastIndex < includeName.length() - 1 ? includeName.substring(lastIndex + 1) : "";
                }
                return "include " + includeName;
            }
            if (nodeName.equals("wire")) {
                String wireTarget;
                String wireSrc = ScaUtils.getAttributeValue(node, "source");
                if (wireSrc == null) {
                    wireSrc = "";
                }
                if ((wireTarget = ScaUtils.getAttributeValue(node, "target")) == null) {
                    wireTarget = "";
                }
                if (wireSrc.equals("") && wireTarget.equals("")) {
                    return "";
                }
                return String.valueOf(wireSrc) + " > " + wireTarget;
            }
            if (nodeName.startsWith("implementation.") || nodeName.startsWith("binding.") || nodeName.startsWith("interface.")) {
                return nodeName;
            }
            if (nodeName.equals("constrainingtype")) {
                String ctName = ScaUtils.getAttributeValue(node, "name");
                ctName = ctName != null ? ScaUtils.removeNamespacePrefix(ctName) : "?";
                return "Constraining Type " + ctName;
            }
            if (nodeName.equals("bindingtype")) {
                String type = ScaUtils.getAttributeValue(node, "type");
                type = type != null ? ScaUtils.removeNamespacePrefix(type) : "?";
                return "Binding Type " + type;
            }
            if (nodeName.equals("implementationtype")) {
                String type = ScaUtils.getAttributeValue(node, "type");
                type = type != null ? ScaUtils.removeNamespacePrefix(type) : "?";
                return "Implementation Type " + type;
            }
            if (nodeName.equals("runas")) {
                String role = ScaUtils.getAttributeValue(node, "role");
                role = role != null ? ScaUtils.removeNamespacePrefix(role) : "?";
                return "Run As " + role;
            }
            if (nodeName.equals("permitall")) {
                return "Permit All";
            }
            if (nodeName.equals("denyall")) {
                return "Deny All";
            }
            if (nodeName.equals("componenttype")) {
                return "Component Type";
            }
            return nodeName;
        }
        return "";
    }
}

