/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences.beans;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlItem;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaXmlElement
extends ScaXmlItem
implements Externalizable {
    private static int idCpt = 0;
    private int id;
    private int minOccurs = 0;
    private int maxOccurs = 1;
    private boolean unbounded = false;
    private ScaXmlElement parent;
    private ScaXmlPlatform platform;
    public final Set<ScaXmlAttribute> attributes = new HashSet<ScaXmlAttribute>();
    public final Set<ScaXmlElement> children = new HashSet<ScaXmlElement>();

    public ScaXmlElement() {
    }

    public ScaXmlElement(String name, ScaXmlPlatform platform) {
        this.id = idCpt++;
        this.name = name;
        this.platform = platform;
    }

    public ScaXmlElement(String name, ScaXmlElement parent) {
        this.id = idCpt++;
        this.name = name;
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public int getMinOccurs() {
        return this.minOccurs;
    }

    public void setMinOccurs(int minOccurs) {
        this.minOccurs = minOccurs;
    }

    public int getMaxOccurs() {
        return this.maxOccurs;
    }

    public void setMaxOccurs(int maxOccurs) {
        this.maxOccurs = maxOccurs;
    }

    public boolean isUnbounded() {
        return this.unbounded;
    }

    public void setUnbounded(boolean unbounded) {
        this.unbounded = unbounded;
    }

    public int getId() {
        return this.id;
    }

    public ScaXmlElement getParent() {
        return this.parent;
    }

    public void setParent(ScaXmlElement parent) {
        if (this.parent != null) {
            this.parent.children.remove(this);
        }
        this.parent = parent;
        if (parent != null) {
            parent.children.add(this);
        }
    }

    public ScaXmlPlatform getPlatform() {
        return this.platform;
    }

    public void setPlatform(ScaXmlPlatform platform) {
        this.platform = platform;
    }

    public ScaXmlPlatform getParentPlatform() {
        if (this.platform != null) {
            return this.platform;
        }
        return this.parent.getParentPlatform();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof ScaXmlElement)) {
            return false;
        }
        ScaXmlElement elt = (ScaXmlElement)obj;
        return this.id == elt.id;
    }

    @Override
    public int hashCode() {
        return this.id;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.id = in.readInt();
        if (idCpt < this.id) {
            idCpt = this.id + 1;
        }
        this.minOccurs = in.readInt();
        this.maxOccurs = in.readInt();
        this.unbounded = in.readBoolean();
        for (Object o : (Set)in.readObject()) {
            ScaXmlAttribute attr = (ScaXmlAttribute)o;
            attr.setElement(this);
            this.attributes.add(attr);
        }
        for (Object o : (Set)in.readObject()) {
            ScaXmlElement child = (ScaXmlElement)o;
            child.setParent(this);
            this.children.add(child);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeInt(this.id);
        out.writeInt(this.minOccurs);
        out.writeInt(this.maxOccurs);
        out.writeBoolean(this.unbounded);
        out.writeObject(this.attributes);
        out.writeObject(this.children);
    }

    public List<ScaXmlNamespace> getNameSpaces() {
        if (this.platform != null) {
            ArrayList<ScaXmlNamespace> ns = new ArrayList<ScaXmlNamespace>();
            for (Map.Entry<ScaXmlNamespace, List<ScaXmlElement>> entry : this.platform.nsToBindings.entrySet()) {
                if (!entry.getValue().contains(this)) continue;
                ns.add(entry.getKey());
            }
            for (Map.Entry<ScaXmlNamespace, List<ScaXmlElement>> entry : this.platform.nsToImplementations.entrySet()) {
                if (!entry.getValue().contains(this)) continue;
                ns.add(entry.getKey());
            }
            for (Map.Entry<ScaXmlNamespace, List<ScaXmlElement>> entry : this.platform.nsToInterfaces.entrySet()) {
                if (!entry.getValue().contains(this)) continue;
                ns.add(entry.getKey());
            }
            return ns;
        }
        if (this.parent != null) {
            return this.parent.getNameSpaces();
        }
        return Collections.emptyList();
    }

    public boolean hasNamespace(String nsUri) {
        for (ScaXmlNamespace ns : this.getNameSpaces()) {
            if (!ns.getName().equals(nsUri)) continue;
            return true;
        }
        return false;
    }
}

