/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.lang.ref.WeakReference;
import org.eclipse.draw2d.DefaultRangeModel;
import org.eclipse.draw2d.FreeformViewport;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.ScalableFreeformLayeredPane;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.AutoexposeHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ViewportAutoexposeHelper;
import org.eclipse.gmf.runtime.common.core.service.IOperation;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.render.editparts.RenderedDiagramRootEditPart;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.AbstractEditPartProvider;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateGraphicEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.CreateRootEditPartOperation;
import org.eclipse.gmf.runtime.diagram.ui.services.editpart.IEditPartOperation;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnEditPartFactory;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;
import org.eclipse.stp.bpmn.figures.splitviewsupport.FreeFormViewPortWithSplitters;
import org.eclipse.ui.PlatformUI;

public class BpmnEditPartProvider
extends AbstractEditPartProvider {
    private EditPartFactory factory;
    private boolean allowCaching;
    private WeakReference cachedPart;
    private WeakReference cachedView;
    private static final Insets EXPOSE_THRESHOLD = new Insets(24);

    public BpmnEditPartProvider() {
        this.setFactory(new BpmnEditPartFactory());
        this.setAllowCaching(true);
    }

    public final EditPartFactory getFactory() {
        return this.factory;
    }

    protected void setFactory(EditPartFactory factory) {
        this.factory = factory;
    }

    public final boolean isAllowCaching() {
        return this.allowCaching;
    }

    protected synchronized void setAllowCaching(boolean allowCaching) {
        this.allowCaching = allowCaching;
        if (!allowCaching) {
            this.cachedPart = null;
            this.cachedView = null;
        }
    }

    protected IGraphicalEditPart createEditPart(View view) {
        EditPart part = this.factory.createEditPart(null, (Object)view);
        if (part instanceof IGraphicalEditPart) {
            return (IGraphicalEditPart)part;
        }
        return null;
    }

    protected IGraphicalEditPart getCachedPart(View view) {
        if (this.cachedView != null && this.cachedView.get() == view) {
            return (IGraphicalEditPart)this.cachedPart.get();
        }
        return null;
    }

    public synchronized IGraphicalEditPart createGraphicEditPart(View view) {
        if (this.isAllowCaching()) {
            IGraphicalEditPart part = this.getCachedPart(view);
            this.cachedPart = null;
            this.cachedView = null;
            if (part != null) {
                return part;
            }
        }
        return this.createEditPart(view);
    }

    public synchronized boolean providesGen(IOperation operation) {
        if (operation instanceof CreateGraphicEditPartOperation) {
            View view = ((IEditPartOperation)operation).getView();
            if (!BpmnDiagramEditPart.MODEL_ID.equals(BpmnVisualIDRegistry.getModelID(view))) {
                return false;
            }
            if (this.isAllowCaching() && this.getCachedPart(view) != null) {
                return true;
            }
            IGraphicalEditPart part = this.createEditPart(view);
            if (part != null) {
                if (this.isAllowCaching()) {
                    this.cachedPart = new WeakReference<IGraphicalEditPart>(part);
                    this.cachedView = new WeakReference<View>(view);
                }
                return true;
            }
        }
        return false;
    }

    public boolean provides(IOperation operation) {
        if (operation instanceof CreateRootEditPartOperation) {
            return true;
        }
        return this.providesGen(operation);
    }

    public RootEditPart createRootEditPart(Diagram diagram) {
        RenderedDiagramRootEditPart rp = new RenderedDiagramRootEditPart(diagram.getMeasurementUnit()){

            public Object getAdapter(Class adapter) {
                if (adapter == AutoexposeHelper.class) {
                    return new MyViewportAutoexposeHelper((GraphicalEditPart)this, EXPOSE_THRESHOLD);
                }
                return super.getAdapter(adapter);
            }

            protected IFigure createFigure() {
                FreeformViewport superRes = (FreeformViewport)super.createFigure();
                FreeFormViewPortWithSplitters viewport = new FreeFormViewPortWithSplitters();
                viewport.setContents(superRes.getContents());
                return viewport;
            }

            protected ScalableFreeformLayeredPane createScalableFreeformLayeredPane() {
                if (PlatformUI.isWorkbenchRunning()) {
                    return super.createScalableFreeformLayeredPane();
                }
                return new ScalableFreeformLayeredPane();
            }
        };
        final Viewport vp = this.findViewport((GraphicalEditPart)rp);
        vp.setHorizontalRangeModel((RangeModel)new DefaultRangeModel(){

            public void setAll(int min, int ext, int max) {
                int x = vp.getClientArea().width + vp.getClientArea().x;
                if (Math.abs(max - x) < 2 * EXPOSE_THRESHOLD.right) {
                    super.setAll(min, ext, x + 2 * EXPOSE_THRESHOLD.right);
                } else {
                    super.setAll(min, ext, max);
                }
            }
        });
        return rp;
    }

    protected Viewport findViewport(GraphicalEditPart part) {
        IFigure figure = null;
        Viewport port = null;
        do {
            if (!((figure = figure == null ? part.getContentPane() : figure.getParent()) instanceof Viewport)) continue;
            port = (Viewport)figure;
            break;
        } while (figure != part.getFigure() && figure != null);
        return port;
    }

    private static class MyViewportAutoexposeHelper
    extends ViewportAutoexposeHelper {
        private Insets _threshold;
        private long _lastStepTime;

        public MyViewportAutoexposeHelper(GraphicalEditPart owner, Insets threshold) {
            super(owner, threshold);
            this._threshold = threshold;
        }

        public boolean detect(Point where) {
            this._lastStepTime = 0L;
            Viewport port = this.findViewport(this.owner);
            Rectangle rect = Rectangle.SINGLETON;
            port.getClientArea(rect);
            port.translateToParent((Translatable)rect);
            port.translateToAbsolute((Translatable)rect);
            Rectangle biggerRect = rect.getCopy();
            biggerRect.expand(this._threshold);
            if (!biggerRect.contains(where)) {
                return false;
            }
            rect.crop(this._threshold);
            return !rect.contains(where);
        }

        public boolean step(Point where) {
            long wait = System.currentTimeMillis() - this._lastStepTime;
            if (wait < 40L && wait > 0L) {
                return true;
            }
            this._lastStepTime = System.currentTimeMillis();
            Viewport port = this.findViewport(this.owner);
            Rectangle rect = Rectangle.SINGLETON;
            port.getClientArea(rect);
            port.translateToParent((Translatable)rect);
            port.translateToAbsolute((Translatable)rect);
            Rectangle biggerRect = rect.getCopy();
            biggerRect.expand(this._threshold);
            if (!biggerRect.contains(where)) {
                return false;
            }
            rect.crop(this._threshold);
            if (rect.contains(where)) {
                return false;
            }
            Point loc = port.getViewLocation();
            if (where.x < rect.x) {
                loc.x -= rect.x - where.x;
            } else if (where.x > rect.x + rect.width) {
                loc.x += 2 * (where.x - (rect.x + rect.width));
            }
            if (where.y < rect.y) {
                loc.y -= rect.y - where.y;
            } else if (where.y > rect.y + rect.height) {
                loc.y += 2 * (where.y - (rect.y + rect.height));
            }
            port.setViewLocation(loc);
            return true;
        }
    }
}

