/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.diagram.ui;

import java.lang.reflect.Method;
import org.eclipse.jface.window.ToolTip;
import org.eclipse.stp.bpmn.diagram.ui.IMenuItemWithDisableSupport;
import org.eclipse.stp.bpmn.diagram.ui.PopupMenuWithDisableSupport;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class TooltipManager {
    private static Method Menu_Get_Bound = null;
    private PopupMenuWithDisableSupport _rootMenu;
    private ToolTip _currentToolTip;
    private Control _parent;

    static int getMenuWidth(Menu menu) {
        try {
            if (Menu_Get_Bound == null) {
                Menu_Get_Bound = Menu.class.getDeclaredMethod("getBounds", new Class[0]);
                Menu_Get_Bound.setAccessible(true);
            }
            Rectangle rect = (Rectangle)Menu_Get_Bound.invoke((Object)menu, new Object[0]);
            return rect.width;
        }
        catch (Throwable throwable) {
            return 0;
        }
    }

    TooltipManager(PopupMenuWithDisableSupport rootMenu, Control parent) {
        this._rootMenu = rootMenu;
        this._parent = parent;
    }

    void showTooltip(Event event, MenuItem item, Object content) {
        if (!(content instanceof IMenuItemWithDisableSupport)) {
            return;
        }
        IMenuItemWithDisableSupport tooltip = (IMenuItemWithDisableSupport)content;
        this._currentToolTip = tooltip.getToolTip(this._parent);
        if (this._currentToolTip == null) {
            return;
        }
        int menuWidth = TooltipManager.getMenuWidth(this._rootMenu._rootMenu);
        this._currentToolTip.show(new Point(this._rootMenu.getLocationInTheDisplay().x + menuWidth, this._rootMenu.getLocationInTheDisplay().y));
    }

    void dispose() {
        if (this._currentToolTip != null) {
            this._currentToolTip.deactivate();
        }
    }
}

