/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gmf.runtime.draw2d.ui.figures.WrappingLabel;
import org.eclipse.stp.bpmn.figures.activities.ActivityPainter;

public class WrapLabelWithToolTip
extends WrappingLabel {
    private final IToolTipProvider _toolTipProvider;
    private String _lastToolTip;
    private boolean trunc = false;

    public WrapLabelWithToolTip(IToolTipProvider toolTipProvider, Dimension prefSize, Dimension minSize, boolean isWrap, int labelAlignmentWithinFigure, int textJustification) {
        this._toolTipProvider = toolTipProvider;
        this.prefSize = prefSize;
        this.minSize = minSize;
        this.setAlignment(labelAlignmentWithinFigure);
        this.setTextJustification(textJustification);
        super.setTextWrap(isWrap);
    }

    public String getTruncationString() {
        String sub = super.getTruncationString();
        if (this._toolTipProvider != null) {
            this.updateToolTip(sub);
        }
        return sub;
    }

    private void updateToolTip(String sub) {
        this.trunc = sub != null && sub.length() > 0 && !sub.equals(this.getText());
        String newToolTip = this._toolTipProvider.getToolTipText(this.trunc);
        if (newToolTip == null) {
            if (this._lastToolTip != null) {
                this._lastToolTip = null;
                this.setToolTip(ActivityPainter.createToolTipFigure(this._lastToolTip));
            }
        } else if (!newToolTip.equals(this._lastToolTip)) {
            this._lastToolTip = newToolTip;
            this.setToolTip(ActivityPainter.createToolTipFigure(this._lastToolTip));
        }
    }

    public static interface IToolTipProvider {
        public String getToolTipText(boolean var1);
    }
}

