/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.figures.router;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gmf.runtime.draw2d.ui.figures.PolylineConnectionEx;
import org.eclipse.gmf.runtime.draw2d.ui.geometry.PointListUtilities;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.ObliqueRouter;
import org.eclipse.gmf.runtime.draw2d.ui.internal.routers.OrthogonalRouter;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.figures.SubProcessFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityDiamondFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityNodeFigure;
import org.eclipse.stp.bpmn.figures.activities.ActivityOvalFigure;
import org.eclipse.stp.bpmn.figures.connectionanchors.IModelAwareAnchor;

public class RectilinearRouterEx
extends ObliqueRouter
implements OrthogonalRouter {
    private static int maxRoutingDepth = 10;
    private static int ALMOST_EQUAL = 3;
    public static final int NORMALIZE_ON_SHORTEST_SEGMENT_FIRST = 1;
    public static final int NORMALIZE_ON_VERTICAL_CENTER = 2;
    public static final int NORMALIZE_ON_HORIZONTAL_CENTER = 3;
    public static final int NORMALIZE_ON_HORIZONTAL_EXCEPT_FIRST_SEG = 4;
    public int normalizeBehavior = 1;

    public void routeBendpoints(Connection conn) {
        if (conn.getSourceAnchor() == null || conn.getTargetAnchor() == null || conn.getSourceAnchor().getOwner() == conn.getTargetAnchor().getOwner()) {
            return;
        }
        PointList points = new PointList();
        if (this.isClosestDistance(conn)) {
            points = this.routeClosestDistance(conn);
            this.routeAroundSelfForClosestDistance(conn, points);
            if (points.size() > 2) {
                conn.setPoints(points);
                return;
            }
        } else {
            points = this.routeFromConstraint(conn);
            if (points.size() == 2) {
                this.routeAroundSelfForClosestDistance(conn, points);
            }
        }
        this.routeLine(conn, 0, points);
        conn.setPoints(points);
    }

    public boolean isAvoidingObstructions(Connection conn) {
        if (conn instanceof PolylineConnectionEx) {
            return ((PolylineConnectionEx)conn).isAvoidObstacleRouting();
        }
        return false;
    }

    public boolean isClosestDistance(Connection conn) {
        if (conn instanceof PolylineConnectionEx) {
            return ((PolylineConnectionEx)conn).isClosestDistanceRouting();
        }
        return false;
    }

    protected boolean isReorienting(Connection conn) {
        return conn.getSourceAnchor().getOwner() == null || conn.getTargetAnchor().getOwner() == null;
    }

    protected boolean removePointsInViews(Connection conn, PointList newLine) {
        boolean bChanged = false;
        if (conn == null || newLine == null) {
            throw new IllegalArgumentException("null connection illegal");
        }
        if (newLine.size() < 3) {
            return false;
        }
        if (conn.getSourceAnchor().getOwner() == null) {
            return false;
        }
        if (conn.getTargetAnchor().getOwner() == null) {
            return false;
        }
        Rectangle startRect = new Rectangle(this.getOwnerBounds(conn.getSourceAnchor()));
        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
        conn.translateToRelative((Translatable)startRect);
        Rectangle endRect = new Rectangle(this.getOwnerBounds(conn.getTargetAnchor()));
        conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
        conn.translateToRelative((Translatable)endRect);
        PointList newPoints = new PointList(newLine.size());
        int i = 0;
        while (i < newLine.size()) {
            Point pt = newLine.getPoint(i);
            if (i == 0 || i == newLine.size() - 1) {
                newPoints.addPoint(pt);
            } else if (!startRect.contains(pt) && !endRect.contains(pt)) {
                newPoints.addPoint(pt);
            } else {
                bChanged = true;
            }
            ++i;
        }
        if (newPoints.size() != newLine.size()) {
            newLine.removeAllPoints();
            i = 0;
            while (i < newPoints.size()) {
                newLine.addPoint(new Point(newPoints.getPoint(i)));
                ++i;
            }
        }
        return bChanged;
    }

    protected boolean removeSegmentsInViews(Connection conn, PointList newLine) {
        PointList newPoints = new PointList(newLine.size());
        Point ptStart = new Point(newLine.getFirstPoint());
        Point ptEnd = new Point(newLine.getLastPoint());
        int i = 0;
        while (i < newLine.size()) {
            if (i != 0 && i != newLine.size() - 1) {
                newPoints.addPoint(new Point(newLine.getPoint(i)));
            }
            ++i;
        }
        if (newPoints.size() < 3) {
            return false;
        }
        int lastIntersect = 0;
        int count = 0;
        boolean found = false;
        boolean bChanged = false;
        if (conn.getSourceAnchor().getOwner() == null) {
            return false;
        }
        Rectangle startRect = new Rectangle(this.getOwnerBounds(conn.getSourceAnchor()));
        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)startRect);
        conn.translateToRelative((Translatable)startRect);
        int i2 = 0;
        while (i2 < newPoints.size() - 1) {
            boolean in2;
            boolean in1 = startRect.contains(newPoints.getPoint(i2));
            if (in1 != (in2 = startRect.contains(newPoints.getPoint(i2 + 1)))) {
                lastIntersect = count;
                found = true;
            } else if (!in1 && !in2) break;
            ++count;
            ++i2;
        }
        if (found) {
            i2 = 0;
            while (i2 <= lastIntersect) {
                newPoints.removePoint(0);
                bChanged = true;
                ++i2;
            }
        }
        lastIntersect = count = newLine.size() - 1;
        found = false;
        if (conn.getTargetAnchor().getOwner() == null) {
            return false;
        }
        Rectangle endRect = new Rectangle(this.getOwnerBounds(conn.getTargetAnchor()));
        conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)endRect);
        conn.translateToRelative((Translatable)endRect);
        int i3 = newPoints.size() - 1;
        while (i3 > 0) {
            boolean in2;
            boolean in1 = endRect.contains(newPoints.getPoint(i3));
            if (in1 != (in2 = endRect.contains(newPoints.getPoint(i3 - 1)))) {
                lastIntersect = count;
                found = true;
            } else if (!in1 && !in2) break;
            --count;
            --i3;
        }
        if (found) {
            i3 = newPoints.size() - 1;
            while (i3 >= lastIntersect) {
                newPoints.removePoint(newPoints.size() - 1);
                bChanged = true;
                --i3;
            }
        }
        if (newPoints.size() != newLine.size()) {
            newLine.removeAllPoints();
            newLine.addPoint(ptStart);
            i3 = 0;
            while (i3 < newPoints.size()) {
                newLine.addPoint(new Point(newPoints.getPoint(i3)));
                ++i3;
            }
            newLine.addPoint(ptEnd);
        }
        return bChanged;
    }

    public boolean isFeedback(Connection conn) {
        Dimension dim = new Dimension(100, 100);
        Dimension dimCheck = dim.getCopy();
        conn.translateToRelative((Translatable)dimCheck);
        return dim.equals((Object)dimCheck);
    }

    public PointList routeFromConstraint(Connection conn) {
        List bendpoints = (List)conn.getConnectionRouter().getConstraint(conn);
        if (bendpoints == null) {
            bendpoints = Collections.EMPTY_LIST;
        }
        PointList points = new PointList(bendpoints.size());
        int size = bendpoints.size();
        Point r1 = null;
        Point r2 = null;
        int i = 0;
        while (i < size) {
            Bendpoint bp = (Bendpoint)bendpoints.get(i);
            points.addPoint(bp.getLocation());
            ++i;
        }
        if (size == 0) {
            r1 = conn.getSourceAnchor().getReferencePoint().getCopy();
            conn.translateToRelative((Translatable)r1);
            points.addPoint(r1);
            r2 = conn.getTargetAnchor().getReferencePoint().getCopy();
            conn.translateToRelative((Translatable)r2);
            if (this.normalizeBehavior == 4 && !RectilinearRouterEx.areAlmostEqual(r1.x, r2.x)) {
                points.addPoint(new Point(r1.x, r2.y));
            }
            points.addPoint(r2);
            return points;
        }
        r1 = conn.getSourceAnchor().getReferencePoint().getCopy();
        conn.translateToRelative((Translatable)r1);
        r2 = conn.getTargetAnchor().getReferencePoint().getCopy();
        conn.translateToRelative((Translatable)r2);
        Point startBp = ((Bendpoint)bendpoints.get(0)).getLocation();
        Point endBp = ((Bendpoint)bendpoints.get(size - 1)).getLocation();
        if (RectilinearRouterEx.processAlmostZero(r1.x - startBp.x) == 0 && RectilinearRouterEx.processAlmostZero(r2.x - endBp.x) == 0 && RectilinearRouterEx.processAlmostZero(r1.y - startBp.y) == 0 && RectilinearRouterEx.processAlmostZero(r2.y - endBp.y) == 0) {
            return points;
        }
        int dX = RectilinearRouterEx.processAlmostZero(endBp.x - startBp.x);
        int dY = RectilinearRouterEx.processAlmostZero(endBp.y - startBp.y);
        int deltaX = RectilinearRouterEx.processAlmostZero(r1.x - startBp.x) + RectilinearRouterEx.processAlmostZero(r2.x - endBp.x);
        int deltaY = RectilinearRouterEx.processAlmostZero(r1.y - startBp.y) + RectilinearRouterEx.processAlmostZero(r2.y - endBp.y);
        ArrayList<AbsoluteBendpoint> newBps = new ArrayList<AbsoluteBendpoint>(size);
        PointList res = new PointList();
        res.addPoint(r1);
        newBps.add(new AbsoluteBendpoint(r1));
        int i2 = 1;
        while (i2 < size - 1) {
            Point pt = points.getPoint(i2);
            int distFromStartX = RectilinearRouterEx.processAlmostZero(pt.x - startBp.x);
            int distFromStartY = RectilinearRouterEx.processAlmostZero(pt.y - startBp.y);
            double weightX = dX != 0 ? distFromStartX / dX : 1;
            double weightY = dY != 0 ? distFromStartY / dY : 1;
            int newX = deltaX == 0 ? r1.x + distFromStartX : (int)((double)r1.x + (double)(distFromStartX + deltaX) * weightX);
            int newY = deltaY == 0 ? r1.y + distFromStartY : (int)((double)r1.y + (double)(distFromStartY + deltaY) * weightY);
            res.addPoint(newX, newY);
            newBps.add(new AbsoluteBendpoint(newX, newY));
            ++i2;
        }
        res.addPoint(r2);
        newBps.add(new AbsoluteBendpoint(r2));
        conn.getConnectionRouter().setConstraint(conn, newBps);
        return res;
    }

    private static final int processAlmostZero(int rawCompute) {
        if (rawCompute < ALMOST_EQUAL && rawCompute > -ALMOST_EQUAL) {
            return 0;
        }
        return rawCompute;
    }

    static final boolean areAlmostEqual(int one, int two) {
        return RectilinearRouterEx.processAlmostZero(one - two) == 0;
    }

    static final boolean areGrosslyEqual(int one, int two) {
        return Math.abs(one - two) <= 2 * ALMOST_EQUAL;
    }

    static final boolean areVaguelyEqual(int one, int two) {
        return Math.abs(one - two) <= ActivityEditPart.ACTIVITY_FIGURE_SIZE.height / 2;
    }

    public void routeLine(Connection conn, int nestedRoutingDepth, PointList pointList) {
        if (pointList.size() < 2) {
            return;
        }
        if (this.isReorienting(conn)) {
            return;
        }
        IMapMode mm = MapModeUtil.getMapMode((IFigure)conn);
        int minDistfromSide = mm.DPtoLP(16);
        PointList oldPointsCopy = pointList;
        PointList newPoints = new PointList();
        Point oldPointA = oldPointsCopy.removePoint(0);
        newPoints.addPoint(oldPointA);
        Point oldPointB = oldPointsCopy.removePoint(0);
        this.route2Points(oldPointA, oldPointB, newPoints, true, oldPointsCopy.size() == 0, minDistfromSide, conn);
        while (oldPointsCopy.size() > 0) {
            oldPointA = oldPointB;
            oldPointB = oldPointsCopy.removePoint(0);
            this.route2Points(oldPointA, oldPointB, newPoints, false, oldPointsCopy.size() == 0, minDistfromSide, conn);
        }
        int tolerance = 3;
        if (!this.isFeedback(conn)) {
            tolerance = mm.DPtoLP(3);
        }
        PointListUtilities.normalizeSegments((PointList)newPoints, (int)tolerance);
        pointList.addAll(newPoints);
        boolean normalizationChangedLine = false;
        normalizationChangedLine = this.removeSegmentsInViews(conn, pointList);
        normalizationChangedLine |= this.removePointsInViews(conn, pointList);
        if ((normalizationChangedLine |= PointListUtilities.normalizeSegments((PointList)pointList, (int)tolerance)) && ++nestedRoutingDepth < maxRoutingDepth) {
            this.routeLine(conn, nestedRoutingDepth, pointList);
        }
    }

    private void route2Points(Point oldPointA, Point oldPointB, PointList newPoints, boolean isFirst, boolean isLast, int minDistFromSide, Connection conn) {
        Point aPlus = null;
        Point bMinus = null;
        switch (this.normalizeBehavior) {
            case 4: {
                if (isFirst) break;
            }
            case 3: {
                if (isFirst && isLast && RectilinearRouterEx.areGrosslyEqual(oldPointA.y, oldPointB.y)) {
                    newPoints.removeAllPoints();
                    int midY = (oldPointA.y + oldPointB.y) / 2;
                    newPoints.addPoint(new Point(oldPointA.x, midY));
                    newPoints.addPoint(new Point(oldPointB.x, midY));
                    break;
                }
                if (!isFirst && !isLast && (RectilinearRouterEx.areAlmostEqual(oldPointA.y, oldPointB.y) || RectilinearRouterEx.areAlmostEqual(oldPointA.x, oldPointB.x))) break;
                int halfWayX = oldPointA.x == 0 ? 0 : oldPointA.x / 2;
                halfWayX += oldPointB.x == 0 ? 0 : oldPointB.x / 2;
                if ((isFirst || isLast) && Math.abs(oldPointB.x - oldPointA.x) / 2 < minDistFromSide) {
                    if (isFirst) {
                        aPlus = new Point(oldPointA.x + minDistFromSide, oldPointA.y);
                        bMinus = new Point(oldPointA.x + minDistFromSide, oldPointB.y);
                        oldPointB.x = oldPointA.x + 2 * minDistFromSide;
                    } else if (isLast) {
                        aPlus = new Point(oldPointB.x - minDistFromSide, oldPointA.y);
                        bMinus = new Point(oldPointB.x - minDistFromSide, oldPointB.y);
                    }
                } else {
                    aPlus = new Point(halfWayX, oldPointA.y);
                    bMinus = new Point(halfWayX, oldPointB.y);
                }
                newPoints.addPoint(aPlus);
                newPoints.addPoint(bMinus);
                break;
            }
            case 2: {
                if (isFirst && isLast && RectilinearRouterEx.areGrosslyEqual(oldPointA.x, oldPointB.x)) {
                    newPoints.removeAllPoints();
                    int midX = (oldPointA.x + oldPointB.x) / 2;
                    newPoints.addPoint(new Point(midX, oldPointA.y));
                    newPoints.addPoint(new Point(midX, oldPointB.y));
                    return;
                }
                if (!isFirst && !isLast && (RectilinearRouterEx.areAlmostEqual(oldPointA.y, oldPointB.y) || RectilinearRouterEx.areAlmostEqual(oldPointA.x, oldPointB.x))) break;
                int halfWayY = oldPointA.y / 2 + oldPointB.y / 2;
                int i = -1;
                if (conn.getSourceAnchor() instanceof IModelAwareAnchor) {
                    i = ((IModelAwareAnchor)conn.getSourceAnchor()).getOrderNumber();
                }
                int otheri = -1;
                if (conn.getTargetAnchor() instanceof IModelAwareAnchor) {
                    otheri = ((IModelAwareAnchor)conn.getTargetAnchor()).getOrderNumber();
                }
                i = oldPointA.y < oldPointB.y ? i : otheri;
                boolean AisAboveB = oldPointA.y < oldPointB.y && oldPointA.x < oldPointB.x;
                IMapMode mm = MapModeUtil.getMapMode((IFigure)conn);
                if (i != -1) {
                    halfWayY = AisAboveB ? (halfWayY += i * mm.DPtoLP(10)) : (halfWayY -= i * mm.DPtoLP(10));
                }
                if ((isFirst || isLast) && Math.abs(oldPointB.y - oldPointA.y) / 2 < minDistFromSide) {
                    int signedMinDistFromSide;
                    int n = signedMinDistFromSide = oldPointB.y > oldPointA.y ? minDistFromSide : -minDistFromSide;
                    if (isFirst) {
                        aPlus = new Point(oldPointA.x, oldPointA.y + signedMinDistFromSide);
                        bMinus = new Point(oldPointB.x, oldPointA.y + signedMinDistFromSide);
                        if (!isLast) {
                            oldPointB.y = oldPointA.y + 2 * signedMinDistFromSide;
                        }
                    } else if (isLast) {
                        aPlus = new Point(oldPointB.x, oldPointB.y - signedMinDistFromSide);
                        bMinus = new Point(oldPointB.x, oldPointB.y - signedMinDistFromSide);
                    }
                } else {
                    aPlus = new Point(oldPointA.x, halfWayY);
                    bMinus = new Point(oldPointB.x, halfWayY);
                }
                newPoints.addPoint(aPlus);
                newPoints.addPoint(bMinus);
            }
        }
        if (newPoints.size() > 3) {
            Point last = newPoints.getLastPoint();
            Point beforeLast = newPoints.getPoint(newPoints.size() - 2);
            if (RectilinearRouterEx.areAlmostEqual(beforeLast.x, oldPointB.x) && RectilinearRouterEx.areAlmostEqual(last.x, oldPointB.x)) {
                newPoints.removePoint(newPoints.size() - 1);
            } else if (RectilinearRouterEx.areAlmostEqual(beforeLast.y, oldPointB.y) && RectilinearRouterEx.areAlmostEqual(last.y, oldPointB.y)) {
                newPoints.removePoint(newPoints.size() - 1);
            }
        }
        newPoints.addPoint(oldPointB);
    }

    public PointList routeClosestDistance(Connection conn) {
        PointList newLine = this.routeFromConstraint(conn);
        Point ptOrig = new Point(newLine.getFirstPoint());
        Point ptTerm = new Point(newLine.getLastPoint());
        if (this.normalizeBehavior == 2 && RectilinearRouterEx.areGrosslyEqual(ptOrig.x, ptTerm.x)) {
            newLine.removeAllPoints();
            int midX = (ptOrig.x + ptTerm.x) / 2;
            newLine.addPoint(new Point(midX, ptOrig.y));
            newLine.addPoint(new Point(midX, ptTerm.y));
            return newLine;
        }
        newLine.removeAllPoints();
        newLine.addPoint(ptOrig);
        IMapMode mm = MapModeUtil.getMapMode((IFigure)conn);
        int extra = mm.DPtoLP(16);
        if (this.normalizeBehavior == 4) {
            if (!RectilinearRouterEx.areAlmostEqual(ptOrig.x, ptTerm.x)) {
                newLine.addPoint(new Point(ptOrig.x, ptTerm.y));
            }
        } else if (!RectilinearRouterEx.areAlmostEqual(ptOrig.y, ptTerm.y)) {
            if (this.normalizeBehavior == 3 && ptOrig.x >= ptTerm.x || this.normalizeBehavior == 3 && ptOrig.x + extra >= ptTerm.x && !RectilinearRouterEx.areVaguelyEqual(ptOrig.y, ptTerm.y)) {
                newLine.addPoint(ptTerm);
                return newLine;
            }
            Point ptAlignedWithOrig = null;
            PointList oldLine = this.routeFromConstraint(conn);
            oldLine.removePoint(0);
            oldLine.removePoint(oldLine.size() - 1);
            int i = 0;
            while (i < oldLine.size()) {
                Point bp = oldLine.getPoint(i);
                if (bp.y == ptOrig.y && this.normalizeBehavior == 3 && bp.x < ptTerm.x && bp.x > ptOrig.x) {
                    ptAlignedWithOrig = bp;
                    break;
                }
                if (bp.x == ptOrig.x && this.normalizeBehavior == 2) {
                    ptAlignedWithOrig = bp;
                    break;
                }
                ++i;
            }
            if (ptAlignedWithOrig == null) {
                if (this.normalizeBehavior == 2) {
                    ptAlignedWithOrig = new Point(ptOrig.x, (ptOrig.y + ptTerm.y) / 2);
                } else if (this.normalizeBehavior == 3) {
                    ptAlignedWithOrig = new Point((ptOrig.x + ptTerm.x) / 2, ptOrig.y);
                }
            }
            if (this.normalizeBehavior == 2) {
                Point abovePoint;
                if (ptAlignedWithOrig.y == ptOrig.y) {
                    ptAlignedWithOrig.y += extra;
                }
                Point belowPoint = ptTerm.y > ptOrig.y ? ptTerm : ptOrig;
                Point point = abovePoint = belowPoint == ptOrig ? ptTerm : ptOrig;
                if (ptAlignedWithOrig.y > belowPoint.y || ptAlignedWithOrig.y < abovePoint.y) {
                    boolean AisAboveB;
                    ptAlignedWithOrig.y = (ptOrig.y + ptTerm.y) / 2;
                    int i2 = RectilinearRouterEx.safeGetOrderNumber(conn.getSourceAnchor());
                    int otheri = RectilinearRouterEx.safeGetOrderNumber(conn.getTargetAnchor());
                    i2 = ptOrig.y < ptTerm.y ? i2 : otheri;
                    boolean bl = AisAboveB = ptOrig.y < ptTerm.y && ptOrig.x > ptTerm.x;
                    if (i2 != -1) {
                        ptAlignedWithOrig.y = AisAboveB ? (ptAlignedWithOrig.y += i2 * mm.DPtoLP(10)) : (ptAlignedWithOrig.y -= i2 * mm.DPtoLP(10));
                    }
                }
                newLine.addPoint(ptAlignedWithOrig);
                newLine.addPoint(new Point(ptTerm.x, ptAlignedWithOrig.y));
            } else {
                if (ptAlignedWithOrig.x == ptOrig.x) {
                    ptAlignedWithOrig.x += extra;
                }
                newLine.addPoint(ptAlignedWithOrig.x, ptOrig.y);
                newLine.addPoint(ptAlignedWithOrig.x, ptTerm.y);
            }
        }
        newLine.addPoint(ptTerm);
        return newLine;
    }

    private static int safeGetOrderNumber(ConnectionAnchor ca) {
        if (ca instanceof IModelAwareAnchor) {
            return ((IModelAwareAnchor)ca).getOrderNumber();
        }
        return 1;
    }

    protected void routeAroundSelfForClosestDistance(Connection conn, PointList newLine) {
        Point ptOrig = newLine.getPoint(0);
        Point ptTerm = newLine.getLastPoint();
        if (3 == this.normalizeBehavior || 4 == this.normalizeBehavior) {
            IMapMode mm = MapModeUtil.getMapMode((IFigure)conn);
            int tolerance = mm.DPtoLP(3);
            int extra = mm.DPtoLP(16);
            if (ptOrig.x >= ptTerm.x || ptOrig.x + extra >= ptTerm.x && !RectilinearRouterEx.areVaguelyEqual(ptOrig.y, ptTerm.y)) {
                Rectangle target;
                Rectangle src;
                newLine.setSize(newLine.size() - 1);
                Rectangle rectangle = src = conn.getSourceAnchor().getOwner() == null ? null : this.getOwnerBounds(conn.getSourceAnchor()).getCopy();
                if (src == null) {
                    src = new Rectangle(ptOrig.getCopy().translate(new Dimension(-extra, -extra / 2)), ptOrig);
                } else {
                    if (4 == this.normalizeBehavior) {
                        IFigure fig = conn.getSourceAnchor().getOwner();
                        while (fig != null) {
                            if (fig instanceof SubProcessFigure) break;
                            fig = fig.getParent();
                        }
                        if (fig == null) {
                            fig = conn.getSourceAnchor().getOwner();
                        }
                        src = fig.getBounds().getCopy();
                        fig.translateToAbsolute((Translatable)src);
                    } else {
                        conn.getSourceAnchor().getOwner().translateToAbsolute((Translatable)src);
                    }
                    conn.translateToRelative((Translatable)src);
                }
                Rectangle rectangle2 = target = conn.getTargetAnchor().getOwner() == null ? null : this.getOwnerBounds(conn.getTargetAnchor()).getCopy();
                if (target == null) {
                    target = new Rectangle(ptTerm.getCopy().translate(new Dimension(extra, -extra / 2)), ptTerm);
                } else {
                    conn.getTargetAnchor().getOwner().translateToAbsolute((Translatable)target);
                    conn.translateToRelative((Translatable)target);
                }
                int heightOwnerSrc = src.height;
                int heightOwnerTarget = target.height;
                int topRightSrcY = src.y;
                int bottomRightSrcY = src.y + src.height;
                int topLeftTargetY = target.y;
                int bottomLeftTargetY = target.y + target.height;
                int aboveY = -1;
                int farRightX = -1;
                if (4 != this.normalizeBehavior && topRightSrcY > bottomLeftTargetY + extra) {
                    PointList oldLine = this.routeFromConstraint(conn);
                    aboveY = oldLine.getMidpoint().y;
                    if (topRightSrcY < aboveY || bottomLeftTargetY > aboveY) {
                        aboveY = (topRightSrcY + bottomLeftTargetY) / 2;
                    }
                    farRightX = ptOrig.x + extra;
                } else if (topLeftTargetY > bottomRightSrcY + extra) {
                    PointList oldLine = this.routeFromConstraint(conn);
                    aboveY = oldLine.getMidpoint().y;
                    if (topLeftTargetY < aboveY || bottomRightSrcY > aboveY) {
                        aboveY = (topLeftTargetY + bottomRightSrcY) / 2;
                    }
                    farRightX = ptOrig.x + extra;
                } else {
                    int midYSrc;
                    int belowDelta;
                    int aboveDelta;
                    int aboveYone;
                    int extraY = Math.max(extra, Math.min(heightOwnerSrc / 2, heightOwnerTarget / 2));
                    PointList oldLine = this.routeFromConstraint(conn);
                    int belowYone = oldLine.getMidpoint().y;
                    if (bottomLeftTargetY + extraY > belowYone || bottomRightSrcY + extraY < belowYone) {
                        belowYone = Math.max(bottomLeftTargetY, bottomRightSrcY);
                    }
                    if ((aboveYone = oldLine.getMidpoint().y) < topRightSrcY + extraY || aboveYone > topLeftTargetY + extraY) {
                        aboveYone = Math.min(topRightSrcY, topLeftTargetY);
                    }
                    aboveY = 4 != this.normalizeBehavior ? belowYone + extraY : ((aboveDelta = Math.max(ptOrig.y - aboveYone, ptTerm.y - aboveYone)) - (belowDelta = Math.max(belowYone - ptOrig.y, belowYone - ptTerm.y)) > tolerance ? belowYone + extraY : (belowDelta - aboveDelta > tolerance ? aboveYone - extraY : (ptOrig.y + tolerance > (midYSrc = src.getCenter().y) ? belowYone + extraY : aboveYone - extraY)));
                    farRightX = Math.max(ptOrig.x + extra, ptTerm.x + extra + target.width);
                }
                int farLeft = ptTerm.x - extra;
                if (4 == this.normalizeBehavior) {
                    Point srcLeft = src.getLeft();
                    conn.getSourceAnchor().getOwner().translateToRelative((Translatable)srcLeft);
                    if (ptTerm.y < ptOrig.y) {
                        farLeft = Math.min(farLeft, srcLeft.x + extra);
                    }
                }
                Point origPlus = new Point(farRightX, ptOrig.y);
                Point origAbove = new Point(origPlus.x, aboveY);
                Point termMinus = new Point(farLeft, ptTerm.y);
                Point termAbove = new Point(termMinus.x, aboveY);
                if (4 != this.normalizeBehavior) {
                    newLine.addPoint(origPlus);
                    newLine.addPoint(origAbove);
                } else {
                    newLine.setSize(1);
                    Point orig = newLine.getFirstPoint();
                    if (orig.y + extra > termAbove.y) {
                        termAbove.y = ptOrig.y = orig.y + extra;
                    } else {
                        ptOrig.y = termAbove.y;
                    }
                    newLine.addPoint(ptOrig);
                }
                newLine.addPoint(termAbove);
                newLine.addPoint(termMinus);
                newLine.addPoint(ptTerm);
            } else if (4 == this.normalizeBehavior) {
                Point orig = newLine.getFirstPoint();
                if (ptOrig.y < orig.y) {
                    ptOrig.y = orig.y + extra;
                }
                if (ptOrig.y > ptTerm.y && conn.getSourceAnchor().getOwner() != null) {
                    IFigure fig = conn.getSourceAnchor().getOwner();
                    while (fig != null) {
                        if (fig instanceof SubProcessFigure) break;
                        fig = fig.getParent();
                    }
                    if (fig == null) {
                        return;
                    }
                    Rectangle src = fig.getBounds().getCopy();
                    fig.translateToAbsolute((Translatable)src);
                    conn.translateToRelative((Translatable)src);
                    Point termMinus = new Point(ptTerm.x - extra, ptTerm.y);
                    Point termBelow = new Point(termMinus.x, ptOrig.y);
                    newLine.setSize(newLine.size() - 2);
                    newLine.addPoint(ptOrig);
                    newLine.addPoint(termBelow);
                    newLine.addPoint(termMinus);
                    newLine.addPoint(ptTerm);
                }
            }
        }
    }

    protected Rectangle getOwnerBounds(ConnectionAnchor anchor) {
        for (Object child : anchor.getOwner().getChildren()) {
            if (!(child instanceof ActivityNodeFigure)) continue;
            for (Object childOfChild : ((ActivityNodeFigure)child).getChildren()) {
                if (!(childOfChild instanceof ActivityDiamondFigure) && !(childOfChild instanceof ActivityOvalFigure)) continue;
                return ((IFigure)childOfChild).getBounds().getCopy();
            }
        }
        return anchor.getOwner().getBounds().getCopy();
    }
}

