/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.tools.UnspecifiedTypeCreationTool;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.stp.bpmn.commands.IElementTypeEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.providers.BpmnElementTypes;

public class UnspecifiedActivityTypeCreationToolEx
extends UnspecifiedTypeCreationTool {
    private boolean isActivity;
    private boolean isArtifact;

    public UnspecifiedActivityTypeCreationToolEx(List elementTypes, boolean unloadWhenFinished) {
        super(elementTypes);
        super.setUnloadWhenFinished(unloadWhenFinished);
        for (Object object : elementTypes) {
            if (object instanceof IElementTypeEx) {
                this.isActivity = true;
                break;
            }
            if (object != BpmnElementTypes.Group_1004 && object != BpmnElementTypes.Group_2006 && object != BpmnElementTypes.TextAnnotation_1002 && object != BpmnElementTypes.TextAnnotation_2004 && object != BpmnElementTypes.DataObject_1003 && object != BpmnElementTypes.DataObject_2005) continue;
            this.isArtifact = true;
            break;
        }
    }

    protected void updateTargetRequest() {
        if (!this.isActivity) {
            super.updateTargetRequest();
        } else {
            CreateRequest req = this.getCreateRequest();
            if (this.isInState(4)) {
                Point loq = this.getStartLocation();
                Rectangle bounds = new Rectangle(loq, loq);
                Dimension delta = this.getDragMoveDelta();
                int size = Math.max(Math.abs(delta.width), Math.abs(delta.height));
                bounds.union(loq.getTranslated(UnspecifiedActivityTypeCreationToolEx.sgn(delta.width) * size, UnspecifiedActivityTypeCreationToolEx.sgn(delta.height) * size));
                req.setSize(bounds.getSize());
                req.setLocation(bounds.getLocation());
                req.getExtendedData().clear();
            } else {
                req.setSize(null);
                req.setLocation(this.getLocation());
            }
        }
    }

    private EditPart findParent(EditPart part) {
        if (part instanceof PoolPoolCompartmentEditPart || part instanceof SubProcessSubProcessBodyCompartmentEditPart || part instanceof BpmnDiagramEditPart) {
            return part;
        }
        if (part == null) {
            throw new IllegalArgumentException("Could not find parent");
        }
        return this.findParent(part.getParent());
    }

    protected boolean updateTargetUnderMouse() {
        boolean b = super.updateTargetUnderMouse();
        if (this.isArtifact && this.getTargetEditPart() instanceof IGraphicalEditPart && this.getTargetRequest() != null) {
            Point loq = this.getStartLocation();
            Rectangle bounds = new Rectangle(loq, loq);
            bounds.union(loq.getTranslated(this.getDragMoveDelta()));
            Rectangle fig = ((IGraphicalEditPart)this.getTargetEditPart()).getFigure().getBounds().getCopy();
            ((IGraphicalEditPart)this.getTargetEditPart()).getFigure().translateToAbsolute((Translatable)fig);
            if (!fig.contains(bounds)) {
                b = true;
                this.setTargetEditPart(this.findParent(this.getTargetEditPart().getParent()));
            }
        }
        return b;
    }

    private static int sgn(int i) {
        return i < 0 ? -1 : 1;
    }

    protected void selectAddedObject(EditPartViewer viewer, Collection objects) {
        ArrayList editparts = new ArrayList();
        for (Object object : objects) {
            Object editPart;
            if (!(object instanceof IAdaptable) || (editPart = viewer.getEditPartRegistry().get(((IAdaptable)object).getAdapter(View.class))) == null) continue;
            editparts.add(editPart);
        }
    }
}

