/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.base;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stp.common.validator.core.IMessage;
import org.eclipse.stp.common.validator.core.IReporter;

public class MemoryReporter
implements IReporter {
    private List messages = new ArrayList();
    private int errorCount = 0;
    private int warnCount = 0;

    public void addMessage(IMessage message) {
        if (1 == message.getSeverity()) {
            ++this.errorCount;
        } else if (2 == message.getSeverity()) {
            ++this.warnCount;
        }
        this.messages.add(message);
    }

    public void cancel() {
    }

    public List getErrorList() {
        ArrayList<IMessage> out = new ArrayList<IMessage>();
        for (IMessage message : this.messages) {
            if (1 != message.getSeverity()) continue;
            out.add(message);
        }
        return out;
    }

    public List getWarningList() {
        ArrayList<IMessage> out = new ArrayList<IMessage>();
        for (IMessage message : this.messages) {
            if (2 != message.getSeverity()) continue;
            out.add(message);
        }
        return out;
    }

    public int getErrorsCount() {
        return this.errorCount;
    }

    public List getMessages() {
        return this.messages;
    }

    public int getWarningsCount() {
        return this.warnCount;
    }

    public boolean isCanceled() {
        return false;
    }

    public void removeAllMessages() {
        this.messages.clear();
    }
}

