/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.common.validator.core.impl.service;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.eclipse.stp.common.validator.core.impl.service.DOMHelper;
import org.eclipse.stp.common.validator.core.impl.service.XPathHelper;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSResourceResolver;
import org.w3c.dom.ls.LSSerializer;
import org.xml.sax.SAXException;

public class InlineSchemaHelper
implements DOMErrorHandler,
LSResourceResolver {
    private static final Logger LOG = Logger.getLogger(InlineSchemaHelper.class);
    private Document wsdlDocument = null;
    private URI documentLocation;
    private Map schemasMap = null;
    private Map xsModelMap = null;
    private List errors = new ArrayList();
    private static DocumentBuilder theDocumentBuilder = null;

    public InlineSchemaHelper(Document wsdlDoc, URI documentLocation) {
        this.wsdlDocument = wsdlDoc;
        this.documentLocation = documentLocation;
    }

    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        if (systemId == null) {
            Object obj = this.schemasMap.get(namespaceURI);
            if (obj != null) {
                Document doc = (Document)obj;
                LSInput lsInputObj = this.createLSInput(doc.getDocumentElement());
                return lsInputObj;
            }
            LOG.error((Object)("Resolver is asked for unresolved [" + namespaceURI + "] namespace schema"));
        } else {
            try {
                Document doc = InlineSchemaHelper.getDocumentBuilder().parse(this.documentLocation.resolve(systemId).toString());
                LSInput lsInputObj = this.createLSInput(doc.getDocumentElement());
                return lsInputObj;
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {
                // empty catch block
            }
        }
        return null;
    }

    public boolean handleError(DOMError error) {
        LOG.error((Object)("DOM Error while loading XS Model: " + error.getMessage()));
        this.errors.add(error.getMessage());
        return false;
    }

    public static XSLoader getXSLoaderInstance() {
        XSLoader xsLoader = null;
        System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
        DOMImplementationRegistry registry = null;
        try {
            registry = DOMImplementationRegistry.newInstance();
            XSImplementation impl = (XSImplementation)registry.getDOMImplementation("XS-Loader");
            xsLoader = impl.createXSLoader(null);
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to instantiate the Xerces XS Loader", (Throwable)e);
        }
        return xsLoader;
    }

    private LSInput createLSInput(Element schemaElem) {
        DOMImplementationLS impl = null;
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to obtain DOM LS Implementation", (Throwable)e);
        }
        LSOutput lsOutput = impl.createLSOutput();
        LSSerializer lsSerializer = impl.createLSSerializer();
        lsOutput.setEncoding("UTF-8");
        ByteArrayOutputStream btOutputStream = new ByteArrayOutputStream();
        lsOutput.setByteStream(btOutputStream);
        lsSerializer.write(schemaElem, lsOutput);
        LSInput lsInputObj = impl.createLSInput();
        ByteArrayInputStream btInputStream = new ByteArrayInputStream(btOutputStream.toByteArray());
        lsInputObj.setByteStream(btInputStream);
        return lsInputObj;
    }

    public boolean lookupElement(QName elementName) {
        boolean bExists = false;
        Object obj = this.xsModelMap.get(elementName.getNamespaceURI());
        if (obj != null) {
            XSModel xsModel = (XSModel)obj;
            XSElementDeclaration decl = null;
            decl = xsModel.getElementDeclaration(elementName.getLocalPart(), elementName.getNamespaceURI());
            if (decl != null) {
                LOG.debug((Object)("The [" + elementName + "] element located"));
                bExists = true;
            } else {
                LOG.debug((Object)("The [" + elementName + "] element cannot be located in the inline schemas"));
            }
        }
        return bExists;
    }

    public XSModel getGrammar(Element schemaElement) {
        XSLoader schemaLoader = InlineSchemaHelper.getXSLoaderInstance();
        DOMConfiguration config = schemaLoader.getConfig();
        config.setParameter("error-handler", this);
        config.setParameter("resource-resolver", this);
        config.setParameter("validate", Boolean.TRUE);
        XSModel grammar = null;
        LSInput lsInputObj = this.createLSInput(schemaElement);
        grammar = schemaLoader.load(lsInputObj);
        if (grammar != null) {
            LOG.debug((Object)"The XSD Model successfully reloaded");
        }
        return grammar;
    }

    public List getErrorsList() {
        return this.errors;
    }

    private NodeList getInlineSchemasList() {
        NodeList schemas = XPathHelper.getXPathResultList(this.wsdlDocument.getDocumentElement(), "/wsdl:definitions/wsdl:types/xsd:schema");
        return schemas;
    }

    public boolean preparseInlineGrammars() {
        boolean bResult = false;
        Element typesElement = null;
        Element definitionElement = null;
        this.errors.clear();
        int extElemSize = 0;
        NodeList schemasList = this.getInlineSchemasList();
        extElemSize = schemasList.getLength();
        this.schemasMap = new HashMap(extElemSize);
        this.xsModelMap = new HashMap(extElemSize);
        int i = 0;
        while (i < extElemSize) {
            HashMap prefixMap = new HashMap();
            HashMap altPrefixMap = new HashMap();
            String targetNS = null;
            try {
                Element schemaElem = (Element)schemasList.item(i);
                targetNS = schemaElem.getAttribute("targetNamespace");
                LOG.debug((Object)("The schema with target namespace [" + targetNS + "] found"));
                if (typesElement == null) {
                    typesElement = (Element)schemaElem.getParentNode();
                }
                if (definitionElement == null) {
                    definitionElement = (Element)typesElement.getParentNode();
                }
                Node clonedNode = schemaElem.cloneNode(true);
                Document schemaDoc = this.extractSchemaDocument((Element)clonedNode);
                schemaElem = schemaDoc.getDocumentElement();
                DOMHelper.reloadPrefixesForNode(schemaElem, prefixMap);
                DOMHelper.reloadPrefixesForNode(typesElement, altPrefixMap);
                DOMHelper.reloadPrefixesForNode(definitionElement, altPrefixMap);
                for (Map.Entry objEntry : altPrefixMap.entrySet()) {
                    String sPrefix = "xmlns";
                    if (((String)objEntry.getKey()).length() != 0) {
                        sPrefix = String.valueOf(sPrefix) + ":" + (String)objEntry.getKey();
                    }
                    if (prefixMap.get(objEntry.getKey()) != null) continue;
                    schemaElem.setAttribute(sPrefix, (String)objEntry.getValue());
                }
                this.patchSchemaImports(schemaDoc);
                this.schemasMap.put(targetNS, schemaDoc);
            }
            catch (Exception e) {
                String errMsg = "Unexpected problem while preparing [" + targetNS + "] schema: [" + e.getMessage() + "]";
                LOG.error((Object)errMsg, (Throwable)e);
                this.errors.add(errMsg);
            }
            ++i;
        }
        for (Map.Entry objEntry : this.schemasMap.entrySet()) {
            Document schemaDoc = (Document)objEntry.getValue();
            String nsURI = (String)objEntry.getKey();
            XSModel xsModel = this.getGrammar(schemaDoc.getDocumentElement());
            if (xsModel == null) continue;
            this.xsModelMap.put(nsURI, xsModel);
        }
        bResult = this.errors.size() == 0;
        return bResult;
    }

    private Document extractSchemaDocument(Element schemaElement) {
        Document resSchema = null;
        DOMImplementationLS impl = null;
        try {
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            impl = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
        }
        catch (Exception e) {
            LOG.error((Object)"Unable to obtain DOM LS Implementation", (Throwable)e);
        }
        LSOutput lsOutput = impl.createLSOutput();
        LSSerializer lsSerializer = impl.createLSSerializer();
        lsOutput.setEncoding("UTF-8");
        ByteArrayOutputStream btOutputStream = new ByteArrayOutputStream();
        lsOutput.setByteStream(btOutputStream);
        lsSerializer.write(schemaElement, lsOutput);
        ByteArrayInputStream btInputStream = null;
        btInputStream = new ByteArrayInputStream(btOutputStream.toByteArray());
        try {
            resSchema = InlineSchemaHelper.getDocumentBuilder().parse(btInputStream);
        }
        catch (ParserConfigurationException e) {
            LOG.error((Object)"Cannot instantiate DocumentBuilder", (Throwable)e);
        }
        catch (SAXException e) {
            LOG.error((Object)"Unexpected problem during re-parsing of extracted schema", (Throwable)e);
        }
        catch (IOException e) {
            LOG.error((Object)"Unexpected problem during re-parsing of extracted schema", (Throwable)e);
        }
        return resSchema;
    }

    private void patchSchemaImports(Document schemaDoc) {
        QName typeQName;
        String type;
        Element elem;
        Element schemaElem = schemaDoc.getDocumentElement();
        String schemaTns = schemaElem.getAttribute("targetNamespace");
        LOG.debug((Object)("Patching schema with [" + schemaTns + "] target namespace"));
        NodeList byType = XPathHelper.getXPathResultList(schemaElem, "//xsd:*[@type]");
        NodeList byRef = XPathHelper.getXPathResultList(schemaElem, "//xsd:*[@ref]");
        NodeList byBase = XPathHelper.getXPathResultList(schemaElem, "//xsd:*[@base]");
        HashSet<String> refNamespaces = new HashSet<String>();
        int i = 0;
        while (i < byType.getLength()) {
            elem = (Element)byType.item(i);
            typeQName = DOMHelper.resolveReferenceQName(elem, type = elem.getAttribute("type"));
            if (typeQName != null) {
                refNamespaces.add(typeQName.getNamespaceURI());
            } else {
                LOG.error((Object)("Unable to resolve the type reference [" + type + "]"));
            }
            ++i;
        }
        i = 0;
        while (i < byRef.getLength()) {
            elem = (Element)byRef.item(i);
            typeQName = DOMHelper.resolveReferenceQName(elem, type = elem.getAttribute("ref"));
            if (typeQName != null) {
                refNamespaces.add(typeQName.getNamespaceURI());
            } else {
                LOG.error((Object)("Unable to resolve the type reference [" + type + "]"));
            }
            ++i;
        }
        i = 0;
        while (i < byBase.getLength()) {
            elem = (Element)byBase.item(i);
            typeQName = DOMHelper.resolveReferenceQName(elem, type = elem.getAttribute("base"));
            if (typeQName != null) {
                refNamespaces.add(typeQName.getNamespaceURI());
            } else {
                LOG.error((Object)("Unable to resolve the type reference [" + type + "]"));
            }
            ++i;
        }
        LOG.debug((Object)("The list of namespaces to be imported: " + refNamespaces));
        String xsdPrefix = DOMHelper.resolveNamespace(schemaElem, "http://www.w3.org/2001/XMLSchema");
        LOG.debug((Object)("The XSD Namespace is mapped to [" + xsdPrefix + "] prefix"));
        for (String uri : refNamespaces) {
            if ("http://www.w3.org/2001/XMLSchema".compareTo(uri) == 0 || schemaTns.compareTo(uri) == 0) continue;
            Element importElement = schemaDoc.createElementNS("http://www.w3.org/2001/XMLSchema", "import");
            if (xsdPrefix != null && xsdPrefix.length() != 0) {
                importElement.setPrefix(xsdPrefix);
            }
            importElement.setAttribute("namespace", uri);
            schemaElem.insertBefore(importElement, schemaElem.getFirstChild());
            LOG.debug((Object)("Import directive for [" + uri + "] namespace created"));
        }
    }

    private static DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (theDocumentBuilder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            theDocumentBuilder = factory.newDocumentBuilder();
        }
        return theDocumentBuilder;
    }
}

