/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.in.bpmn2im.popup.actions;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.stp.im.in.bpmn2im.Bpmn2ImWorkspaceOperation;
import org.eclipse.stp.im.in.bpmn2im.FixBpmnDiagramAction;
import org.eclipse.stp.im.in.bpmn2im.ui.dialogs.ListBpmnPoolsDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class Bpmn2ImAction
implements IObjectActionDelegate {
    private IFile bpmnFile = null;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        try {
            ListBpmnPoolsDialog selectPoolsDialog = new ListBpmnPoolsDialog(shell, this.bpmnFile);
            int status = selectPoolsDialog.open();
            if (status == 1 || selectPoolsDialog.getStatus() == 1) {
                MessageDialog.openInformation((Shell)shell, (String)" Information", (String)" Operation Cancelled");
                return;
            }
            List<String> idSelectedPools = selectPoolsDialog.getSelectedPools();
            if (idSelectedPools == null || idSelectedPools.isEmpty()) {
                MessageDialog.openInformation((Shell)shell, (String)" Information", (String)" No Pool Selected ");
                return;
            }
            FixBpmnDiagramAction operationFixBpmnDiagram = new FixBpmnDiagramAction(this.bpmnFile, idSelectedPools);
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)operationFixBpmnDiagram);
            Bpmn2ImWorkspaceOperation createIMOperation = new Bpmn2ImWorkspaceOperation(this.bpmnFile, idSelectedPools);
            PlatformUI.getWorkbench().getProgressService().run(true, false, (IRunnableWithProgress)createIMOperation);
            MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"Export BPMN To Intermediate Model Completed");
        }
        catch (InvocationTargetException x) {
            this.reportError(shell, x);
        }
        catch (InterruptedException x) {
            this.reportError(shell, x);
        }
        catch (Throwable e) {
            this.reportError(shell, e);
        }
    }

    private void reportError(Shell shell, Throwable x) {
        ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Error Occurred", (IStatus)Bpmn2ImAction.makeStatus(x));
    }

    public static IStatus makeStatus(Throwable x) {
        return new Status(4, "org.eclipse.stp.im.in.bpmn2im", 4, x.getMessage(), null);
    }

    public final void selectionChanged(IAction action, ISelection selection) {
        this.setBpmnFile((IFile)((StructuredSelection)selection).getFirstElement());
    }

    public IFile getBpmnFile() {
        return this.bpmnFile;
    }

    public void setBpmnFile(IFile bpmnFile) {
        this.bpmnFile = bpmnFile;
    }
}

