/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.im.out.sca.transform;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.ScaFactory;
import org.eclipse.stp.sca.Service;

public class SCAHandler {
    private DocumentRoot scaRoot = null;
    private ScaFactory scaFactory = ScaFactory.eINSTANCE;
    private Composite composite = null;

    public SCAHandler() {
        this.scaRoot = this.scaFactory.createDocumentRoot();
        this.composite = this.scaFactory.createComposite();
        this.scaRoot.setComposite(this.composite);
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Service createCompositeService(String name) {
        Service service = this.scaFactory.createService();
        service.setName(name);
        this.composite.getService().add((Object)service);
        return service;
    }

    public Component createComponent(String name) {
        Component component = this.scaFactory.createComponent();
        component.setName(name);
        this.composite.getComponent().add((Object)component);
        return component;
    }

    public ComponentService createComponentService(Component parent, String name) {
        ComponentService compServ = this.scaFactory.createComponentService();
        compServ.setName(name);
        parent.getService().add((Object)compServ);
        return compServ;
    }

    public ComponentReference createComponentRef(Component parent, String name) {
        ComponentReference compRef = this.scaFactory.createComponentReference();
        compRef.setName(name);
        parent.getReference().add((Object)compRef);
        return compRef;
    }

    public void persistSCA(URI uri) throws IOException {
        ResourceSetImpl rs = new ResourceSetImpl();
        Resource resource = rs.createResource(uri);
        resource.getContents().add((Object)this.scaRoot);
        resource.save(Collections.EMPTY_MAP);
    }
}

