/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

public class DOMHelper {
    public boolean documentEquals(Document document1, Document document2) {
        boolean ret = false;
        if (document1 != null && document2 != null) {
            document1.normalize();
            document2.normalize();
            NodeIterator myIt = ((DocumentTraversal)((Object)document1)).createNodeIterator(document1, -1, null, true);
            NodeIterator hisIt = ((DocumentTraversal)((Object)document2)).createNodeIterator(document2, -1, null, true);
            Node myNode = myIt.nextNode();
            Node hisNode = hisIt.nextNode();
            while (ret && myNode != null) {
                ret = false;
                if (hisNode != null && myNode.getNodeType() == hisNode.getNodeType()) {
                    if (myNode instanceof Element && !(ret = DOMHelper.compareAttributes((Element)myNode, (Element)hisNode))) break;
                    String myVal = myNode.getNodeValue();
                    String hisVal = hisNode.getNodeValue();
                    ret = myVal != null && hisVal != null ? myVal.trim().equals(hisVal.trim()) : myVal == null && hisVal == null;
                }
                myNode = myIt.nextNode();
                hisNode = hisIt.nextNode();
            }
        } else {
            ret = document1 == null && document2 == null;
        }
        return ret;
    }

    private static boolean compareAttributes(Element myNode, Element hisNode) {
        boolean ret = true;
        NamedNodeMap map = myNode.getAttributes();
        int i = 0;
        while (i < map.getLength()) {
            Attr att = (Attr)map.item(i);
            ret = att.getValue().equals(hisNode.getAttribute(att.getName()));
            ++i;
        }
        ret = ret && map.getLength() == hisNode.getAttributes().getLength();
        return ret;
    }

    public static String getXPath(Node node) {
        StringBuffer buf = new StringBuffer("");
        while (node != null) {
            StringBuffer fragment = null;
            if (node instanceof Element) {
                fragment = DOMHelper.computeXPathFragment((Element)node);
                node = node.getParentNode();
            } else if (node instanceof Attr) {
                fragment = DOMHelper.computeXPathFragment((Attr)node);
                node = ((Attr)node).getOwnerElement();
            } else {
                node = node.getParentNode();
            }
            if (fragment == null) continue;
            buf.insert(0, fragment);
        }
        return new String(buf);
    }

    private static StringBuffer computeXPathFragment(Attr at) {
        StringBuffer ret = new StringBuffer("/@").append(at.getNodeName());
        return ret;
    }

    private static StringBuffer computeXPathFragment(Element el) {
        StringBuffer ret = new StringBuffer("/");
        int num = 1;
        String localName = el.getLocalName();
        String prefixName = el.getPrefix();
        if (prefixName == null) {
            prefixName = "";
        }
        String namespaceURI = el.getNamespaceURI();
        Node node = el;
        while ((node = node.getPreviousSibling()) != null) {
            Node similarElem;
            if (!(node instanceof Element) || localName.compareTo((similarElem = node).getLocalName()) != 0) continue;
            String similarElemPrefix = similarElem.getPrefix();
            if (similarElemPrefix == null) {
                similarElemPrefix = "";
            }
            if (!prefixName.equals(similarElemPrefix) && (namespaceURI == null || namespaceURI.compareTo(similarElem.getNamespaceURI()) != 0)) continue;
            ++num;
        }
        if (prefixName != null) {
            ret.append(prefixName);
            ret.append(":");
        }
        ret.append(localName);
        ret.append("[");
        ret.append(num);
        ret.append("]");
        return ret;
    }
}

