/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.common.utils;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.NamespaceContext;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceResolver
implements NamespaceContext {
    private static Logger log = Logger.getLogger(NamespaceResolver.class);
    private Map nsMapping = new HashMap();
    private static Map nsStandardMapping = new HashMap();
    public static final String WSDL_NS = "http://schemas.xmlsoap.org/wsdl/";
    public static final String WSDL_PREFIX = "wsdl";
    public static final String DOC_NS = "http://types.sopware.org/service/Documentation/1.0";
    public static final String DOC_PREFIX = "doc";
    public static final String SDX_NS = "http://types.sopware.org/service/ServiceDescription/2.0";
    public static final String SDX_PREFIX = "sdx";
    public static final String XSD_NS = "http://www.w3.org/2001/XMLSchema";
    public static final String XSD_PREFIX = "xsd";
    public static final String SPOL_NS = "http://types.sopware.org/qos/SOPPolicy/1.0";
    public static final String SPOL_PREFIX = "spol";
    public static final String SOPA_NS = "http://types.sopware.org/qos/SOPAssertions/1.0";
    public static final String SOPA_PREFIX = "sopa";
    public static final String PP_NS = "http://types.sopware.org/qos/ParticipantPolicy/1.0";
    public static final String PP_PREFIX = "pp";
    public static final String SPDX_NS = "http://types.sopware.org/service/ServiceProviderDescription/1.0";
    public static final String SPDX_PREFIX = "spdx";
    public static final String SOAP_NS = "http://schemas.xmlsoap.org/wsdl/soap/";
    public static final String SOAP_PREFIX = "soap";
    public static final String JMS_NS = "http://schemas.xmlsoap.org/wsdl/jms/";
    public static final String JMS_PREFIX = "jms";
    public static final String PLNK_NS = "http://schemas.xmlsoap.org/ws/2003/05/partner-link/";
    public static final String PLNK_PREFIX = "plnk";
    private static final String PREFIX_GEN_BASE = "svn";
    private int prefixIndex = 0;
    private Node resolverContextNode = null;

    static {
        nsStandardMapping.put(WSDL_PREFIX, WSDL_NS);
        nsStandardMapping.put(DOC_PREFIX, DOC_NS);
        nsStandardMapping.put(SDX_PREFIX, SDX_NS);
        nsStandardMapping.put(XSD_PREFIX, XSD_NS);
        nsStandardMapping.put(SPOL_PREFIX, SPOL_NS);
        nsStandardMapping.put(SOPA_PREFIX, SOPA_NS);
        nsStandardMapping.put(SOAP_PREFIX, SOAP_NS);
        nsStandardMapping.put(JMS_PREFIX, JMS_NS);
        nsStandardMapping.put(PP_PREFIX, PP_NS);
        nsStandardMapping.put(SPDX_PREFIX, SPDX_NS);
        nsStandardMapping.put(PLNK_PREFIX, PLNK_NS);
    }

    protected NamespaceResolver(Document document) {
        this(document, document.getDocumentElement());
    }

    protected NamespaceResolver(Document document, Node context) {
        try {
            this.resolverContextNode = context != null ? context : document.getDocumentElement();
            Element el = document.getDocumentElement();
            if (el != null) {
                NamespaceResolver.reloadMappings(this.nsMapping, el);
            }
        }
        catch (Exception err) {
            log.error((Object)("Problem while loading namespaces: " + err.getMessage()), (Throwable)err);
        }
    }

    public String allocatePrefix(String namespaceURI) {
        String reservedPrefix = null;
        reservedPrefix = NamespaceResolver.getPrefixForDefaultNamespace(namespaceURI);
        if (reservedPrefix == null) {
            reservedPrefix = PREFIX_GEN_BASE + String.valueOf(this.prefixIndex++);
        }
        boolean check4Conflict = true;
        while (check4Conflict) {
            check4Conflict = false;
            String mappedNs = this.getNamespaceURI(reservedPrefix);
            if (mappedNs == null || mappedNs.compareTo(namespaceURI) == 0) continue;
            reservedPrefix = PREFIX_GEN_BASE + String.valueOf(this.prefixIndex++);
            check4Conflict = true;
        }
        this.nsMapping.put(reservedPrefix, namespaceURI);
        return reservedPrefix;
    }

    public static void reloadMappings(Map mappings, Element context) {
        NamedNodeMap attribs = context.getAttributes();
        int nAttribs = attribs.getLength();
        int i = 0;
        while (i < nAttribs) {
            String prefixValue = attribs.item(i).getNodeName();
            String prefix = null;
            prefix = prefixValue.startsWith("xmlns:") ? prefixValue.substring("xmlns:".length()) : (prefixValue.compareTo("xmlns") == 0 ? "" : null);
            if (prefix != null) {
                String nsValue = attribs.item(i).getNodeValue();
                mappings.put(prefix, nsValue);
            }
            ++i;
        }
    }

    public String getNamespaceURI(String prefix, Node context) {
        Object mapping;
        String ns = null;
        if (!context.getOwnerDocument().equals(this.resolverContextNode.getOwnerDocument())) {
            log.warn((Object)"Owner documents for resolver context node and passed context node differs");
        } else if (1 == context.getNodeType()) {
            Node actualContext = context;
            while (actualContext != null && ns == null) {
                HashMap localMapping = new HashMap();
                NamespaceResolver.reloadMappings(localMapping, (Element)actualContext);
                Object mapping2 = localMapping.get(prefix);
                if (mapping2 != null) {
                    ns = (String)mapping2;
                    continue;
                }
                if ((actualContext = actualContext.getParentNode()) != null && actualContext.getNodeType() == 1) continue;
                actualContext = null;
            }
        }
        if (ns == null && (mapping = nsStandardMapping.get(prefix)) != null) {
            ns = (String)mapping;
        }
        return ns;
    }

    public static String getPrefixForDefaultNamespace(String namespace) {
        String prefix = null;
        for (Map.Entry entry : nsStandardMapping.entrySet()) {
            if (((String)entry.getValue()).compareTo(namespace) != 0) continue;
            prefix = (String)entry.getKey();
            break;
        }
        return prefix;
    }

    public String getNamespaceURI(String prefix) {
        return this.getNamespaceURI(prefix, this.resolverContextNode);
    }

    public String getPrefix(String namespaceURI) {
        String prefix = null;
        if (namespaceURI != null) {
            for (Map.Entry entry : this.nsMapping.entrySet()) {
                String entryValue = (String)entry.getValue();
                if (entryValue.compareTo(namespaceURI) != 0) continue;
                prefix = (String)entry.getKey();
                break;
            }
        }
        return prefix != null ? prefix : NamespaceResolver.getPrefixForDefaultNamespace(namespaceURI);
    }

    private static void getKeysFromMap(Set keys, Map map, String filterValue) {
        for (Map.Entry entry : map.entrySet()) {
            String entryValue = (String)entry.getValue();
            if (entryValue.compareTo(filterValue) != 0) continue;
            keys.add(entry.getKey());
        }
    }

    public Iterator getPrefixes(String namespaceURI) {
        HashSet listPrefixes = new HashSet();
        NamespaceResolver.getKeysFromMap(listPrefixes, nsStandardMapping, namespaceURI);
        NamespaceResolver.getKeysFromMap(listPrefixes, this.nsMapping, namespaceURI);
        Node context = this.getContext() != null ? this.getContext().getParentNode() : null;
        while (context != null) {
            if (1 == context.getNodeType()) {
                HashMap localMapping = new HashMap();
                NamespaceResolver.reloadMappings(localMapping, (Element)context);
                NamespaceResolver.getKeysFromMap(listPrefixes, localMapping, namespaceURI);
            }
            context = context.getParentNode();
        }
        return listPrefixes.iterator();
    }

    public Node getContext() {
        return this.resolverContextNode;
    }

    public void setContext(Element context) {
        this.resolverContextNode = context;
        this.nsMapping.clear();
        NamespaceResolver.reloadMappings(this.nsMapping, context);
    }
}

