/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.model.impl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.eclipse.stp.policy.model.Assertion;
import org.eclipse.stp.policy.model.Policy;
import org.eclipse.stp.policy.model.impl.EditorDOMHelper;
import org.eclipse.stp.policy.model.impl.PolicyImpl;
import org.eclipse.stp.policy.model.impl.PolicyProvider;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AssertionImpl
implements Assertion {
    private Element element;
    private Policy policy = null;

    public AssertionImpl(Element element) {
        this.element = element;
        Element policyElement = this.getNestedPolicyElement();
        if (policyElement != null) {
            this.policy = new PolicyImpl(policyElement);
        }
    }

    private Element getNestedPolicyElement() {
        NodeList nl = this.element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Element element;
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && PolicyImpl.isValidRootElement(element = (Element)node)) {
                return element;
            }
            ++i;
        }
        return null;
    }

    public Element getElement() {
        return this.element;
    }

    public short getType() {
        return 5;
    }

    public boolean isOptional() {
        String optional = this.element.getAttributeNS(Q_ATTR_OPTIONAL.getNamespaceURI(), Q_ATTR_OPTIONAL.getLocalPart());
        if (optional != null && optional.length() != 0) {
            return Boolean.valueOf(optional);
        }
        return false;
    }

    public void setOptional(boolean optional) {
        if (optional) {
            this.element.setAttributeNS(Q_ATTR_OPTIONAL.getNamespaceURI(), Q_ATTR_OPTIONAL.getLocalPart(), Boolean.toString(optional));
        } else {
            this.element.removeAttributeNS(Q_ATTR_OPTIONAL.getNamespaceURI(), Q_ATTR_OPTIONAL.getLocalPart());
        }
    }

    public QName getName() {
        return new QName(this.element.getNamespaceURI(), this.element.getLocalName(), this.element.getPrefix());
    }

    public void addAttribute(String attributeName, String value) {
        this.element.setAttribute(attributeName, value);
    }

    public String getAttributeValue(String attributeName) {
        return this.element.getAttribute(attributeName);
    }

    public Iterator getAttributes() {
        NamedNodeMap nnm = this.element.getAttributes();
        ArrayList<String> attributes = new ArrayList<String>(nnm.getLength());
        int i = 0;
        while (i < nnm.getLength()) {
            Node node = nnm.item(i);
            attributes.add(node.getNodeName());
            ++i;
        }
        return attributes.iterator();
    }

    public void removeAttribute(String attributeName) {
        this.element.removeAttribute(attributeName);
    }

    public Policy createNestedPolicy() {
        if (this.policy != null) {
            throw new IllegalStateException();
        }
        this.policy = PolicyImpl.create(this.element);
        return this.policy;
    }

    public Policy getNestedPolicy() {
        return this.policy;
    }

    public void removePolicy() {
        if (this.policy instanceof PolicyImpl) {
            EditorDOMHelper.removeNodeAndWhitespace(((PolicyImpl)this.policy).getElement());
        }
        this.policy = null;
    }

    public void serialize(Element parentElement) {
        PolicyProvider provider = new PolicyProvider(parentElement.getOwnerDocument());
        Element element = provider.createElement(parentElement, this.getName());
        NamedNodeMap nnm = this.getElement().getAttributes();
        int i = 0;
        while (i < nnm.getLength()) {
            Attr attr = (Attr)nnm.item(i);
            element.setAttributeNS(attr.getNamespaceURI(), attr.getNodeName(), attr.getValue());
            ++i;
        }
        if (this.policy != null) {
            this.policy.serialize(element);
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof AssertionImpl) {
            return this.element.equals(((AssertionImpl)obj).element);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return this.element.hashCode();
    }
}

