/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.editparts;

import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Panel;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.stp.policy.wtp.editor.editparts.EditPartNavigationHandlerUtil;
import org.eclipse.stp.policy.wtp.editor.editparts.PolicyContainerEditPart;
import org.eclipse.stp.policy.wtp.editor.editparts.PolicyEditPart;
import org.eclipse.stp.policy.wtp.editor.figures.CollapsibleFigure;
import org.eclipse.stp.policy.wtp.editor.figures.ExpandFigure;
import org.eclipse.stp.policy.wtp.editor.figures.TopLineAbstractBackground;
import org.eclipse.stp.policy.wtp.editor.integration.XefOpenExternalEditorHelper;
import org.eclipse.stp.policy.wtp.editor.model.AssertionModel;
import org.eclipse.swt.graphics.Color;
import org.eclipse.wst.wsdl.ui.internal.asd.design.DesignViewGraphicsConstants;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editparts.BaseEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.editpolicies.ASDSelectionEditPolicy;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.BaseLinkIconFigure;
import org.eclipse.wst.wsdl.ui.internal.asd.util.IOpenExternalEditorHelper;

public class AssertionEditPart
extends BaseEditPart {
    private Label label;
    private IFigure contentPane;
    private ExpandFigure expandFigure;
    private Color unselectedColor = null;
    private MyMouseEventListener mouseEventListener;
    private BaseLinkIconFigure linkIconFigure;

    protected IFigure createFigure() {
        Panel figure = new Panel();
        figure.setBorder((Border)new TopLineAbstractBackground());
        ToolbarLayout toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        toolbarLayout.setMinorAlignment(1);
        figure.setLayoutManager((LayoutManager)toolbarLayout);
        Figure labelHolder = new Figure();
        toolbarLayout = new ToolbarLayout(true);
        toolbarLayout.setStretchMinorAxis(true);
        labelHolder.setLayoutManager((LayoutManager)toolbarLayout);
        int ident = PolicyEditPart.getIdent((EditPart)this);
        labelHolder.setBorder((Border)new MarginBorder(0, ident, 0, 0));
        figure.add((IFigure)labelHolder);
        this.expandFigure = new ExpandFigure();
        this.expandFigure.setBorder((Border)new MarginBorder(6, 3, 2, 2));
        labelHolder.add((IFigure)this.expandFigure);
        this.label = new Label();
        this.label.setBorder((Border)new MarginBorder(2, 0, 2, 2));
        this.label.setTextAlignment(1);
        labelHolder.add((IFigure)this.label);
        this.contentPane = new CollapsibleFigure();
        this.contentPane.setBorder((Border)new MarginBorder(0, ident + 16, 0, 0));
        toolbarLayout = new ToolbarLayout(false);
        toolbarLayout.setStretchMinorAxis(true);
        this.contentPane.setLayoutManager((LayoutManager)toolbarLayout);
        figure.add(this.contentPane);
        if (this.isReadOnly()) {
            this.label.setForegroundColor(DesignViewGraphicsConstants.readOnlyLabelColor);
            figure.setBackgroundColor(DesignViewGraphicsConstants.readOnlyTableOperationHeadingColor);
        } else {
            this.label.setForegroundColor(ColorConstants.black);
            figure.setBackgroundColor(DesignViewGraphicsConstants.tableOperationHeadingColor);
        }
        return figure;
    }

    public IFigure getContentPane() {
        return this.contentPane;
    }

    protected List getModelChildren() {
        AssertionModel assertionModel = (AssertionModel)((Object)this.getModel());
        return assertionModel.getModelChildren();
    }

    protected void createEditPolicies() {
        super.createEditPolicies();
        this.installEditPolicy("Selection Feedback", (EditPolicy)new ASDSelectionEditPolicy());
    }

    protected void refreshVisuals() {
        super.refreshVisuals();
        AssertionModel assertionModel = (AssertionModel)((Object)this.getModel());
        this.label.setText(assertionModel.getText());
        this.label.setIcon(assertionModel.getImage());
        this.expandFigure.setVisible(!this.getModelChildren().isEmpty());
    }

    public void addFeedback() {
        if (this.unselectedColor == null) {
            this.unselectedColor = this.getFigure().getBackgroundColor();
            this.getFigure().setBackgroundColor(DesignViewGraphicsConstants.tableCellSelectionColor);
        }
    }

    public void removeFeedback() {
        if (this.unselectedColor != null) {
            this.getFigure().setBackgroundColor(this.unselectedColor);
            this.unselectedColor = null;
        }
    }

    public EditPart getRelativeEditPart(int direction) {
        EditPart editPart = super.getRelativeEditPart(direction);
        editPart = EditPartNavigationHandlerUtil.translateOperationPolicyEditPart((EditPart)this, editPart, direction);
        return editPart;
    }

    public void activate() {
        super.activate();
        if (this.getPolicyRootEditPart() != null) {
            this.linkIconFigure = new BaseLinkIconFigure((AbstractGraphicalEditPart)this);
            this.getPolicyRootEditPart().getLinkIconColumn().add((IFigure)this.linkIconFigure);
            IFigure primaryLayer = this.getLayer("Primary Layer");
            this.mouseEventListener = new MyMouseEventListener();
            primaryLayer.addMouseMotionListener((MouseMotionListener)this.mouseEventListener);
            primaryLayer.addMouseListener((MouseListener)this.mouseEventListener);
        }
    }

    public void deactivate() {
        IFigure fig;
        PolicyContainerEditPart ep;
        super.deactivate();
        if (this.mouseEventListener != null) {
            IFigure primaryLayer = this.getLayer("Primary Layer");
            primaryLayer.removeMouseMotionListener((MouseMotionListener)this.mouseEventListener);
            primaryLayer.removeMouseListener((MouseListener)this.mouseEventListener);
            this.mouseEventListener = null;
        }
        if ((ep = this.getPolicyRootEditPart()) != null && this.linkIconFigure != null && (fig = ep.getLinkIconColumn()).getChildren().contains(this.linkIconFigure)) {
            fig.remove((IFigure)this.linkIconFigure);
            this.linkIconFigure = null;
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open" && this.expandFigure.isVisible()) {
            this.expandFigure.setExpanded(!this.expandFigure.isExpanded());
            this.getContentPane().setVisible(this.expandFigure.isExpanded());
            this.refresh();
        }
    }

    private void refreshLinkFigure(Point point) {
        IOpenExternalEditorHelper openHelper = this.getExternalEditorOpener();
        if (openHelper != null && openHelper.linkApplicable()) {
            if (openHelper.isValid()) {
                this.linkIconFigure.setLinkIconStyle(BaseLinkIconFigure.VALID_SCHEMA_LINK_STYLE);
                Rectangle linkBounds = this.linkIconFigure.getBounds();
                Rectangle figureBounds = this.getFigure().getBounds();
                Rectangle labelBounds = this.label.getBounds();
                Rectangle entireBounds = new Rectangle(figureBounds.x, figureBounds.y, figureBounds.width + linkBounds.width, labelBounds.height);
                if (entireBounds.contains(point)) {
                    this.emphasizeLinkFigure();
                } else {
                    this.unemphasizeLinkFigure();
                }
            } else {
                this.linkIconFigure.setLinkIconStyle(BaseLinkIconFigure.INVALID_SCHEMA_LINK_STYLE);
            }
        }
    }

    private PolicyContainerEditPart getPolicyRootEditPart() {
        EditPart ep = this.getParent();
        while (ep != null && !(ep instanceof PolicyContainerEditPart)) {
            ep = ep.getParent();
        }
        if (ep instanceof PolicyContainerEditPart) {
            return (PolicyContainerEditPart)ep;
        }
        return null;
    }

    private void emphasizeLinkFigure() {
        this.linkIconFigure.setColor(ColorConstants.blue);
    }

    private void unemphasizeLinkFigure() {
        this.linkIconFigure.setColor(ColorConstants.lightGray);
    }

    private void openExternalEditor(Point point) {
        IOpenExternalEditorHelper openHelper;
        Rectangle linkFigBounds = this.linkIconFigure.getBounds();
        if (linkFigBounds.contains(point) && (openHelper = this.getExternalEditorOpener()) != null && openHelper.linkApplicable()) {
            openHelper.openExternalEditor();
        }
    }

    private IOpenExternalEditorHelper getExternalEditorOpener() {
        IOpenExternalEditorHelper openExternalEditorHelper = XefOpenExternalEditorHelper.getExternalEditorOpener();
        if (openExternalEditorHelper != null) {
            openExternalEditorHelper.setModel(this.getModel());
        }
        return openExternalEditorHelper;
    }

    private class MyMouseEventListener
    extends MouseMotionListener.Stub
    implements MouseListener {
        private MyMouseEventListener() {
        }

        public void mouseReleased(MouseEvent me) {
        }

        public void mouseDoubleClicked(MouseEvent me) {
        }

        public void mouseMoved(MouseEvent me) {
            Point pointer = me.getLocation();
            AssertionEditPart.this.refreshLinkFigure(pointer);
        }

        public void mousePressed(MouseEvent me) {
            Point pointer = me.getLocation();
            AssertionEditPart.this.openExternalEditor(pointer);
        }
    }
}

