/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.editparts;

import java.util.List;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editparts.LayerManager;
import org.eclipse.stp.policy.wtp.editor.editparts.PolicyContainerEditPart;
import org.eclipse.stp.policy.wtp.editor.editparts.PolicyEditPart;
import org.eclipse.wst.wsdl.ui.internal.asd.design.figures.ComponentReferenceConnection;

class EditPartNavigationHandlerUtil {
    private EditPartNavigationHandlerUtil() {
    }

    static EditPart translateOperationPolicyEditPart(EditPart ownerPart, EditPart nextPart, int direction) {
        if (direction == 8) {
            EditPart result = null;
            EditPart e = ownerPart;
            while (e != null) {
                if (e instanceof PolicyEditPart) {
                    result = e;
                    break;
                }
                e = e.getParent();
            }
            if (result != null) {
                return EditPartNavigationHandlerUtil.getSourceConnectionEditPart((AbstractGraphicalEditPart)((PolicyEditPart)result));
            }
            return null;
        }
        if (direction == 4 && (nextPart == null || nextPart instanceof PolicyContainerEditPart)) {
            nextPart = EditPartNavigationHandlerUtil.getNextPolicy(ownerPart);
        }
        if (direction == 16) {
            return null;
        }
        return nextPart;
    }

    static EditPart getNextPolicy(EditPart editPart) {
        EditPart result = null;
        EditPart e = editPart;
        while (e != null) {
            if (e instanceof PolicyEditPart) {
                result = EditPartNavigationHandlerUtil.getNextSibling(e);
                break;
            }
            e = e.getParent();
        }
        return result;
    }

    static EditPart getNextSibling(EditPart editPart) {
        List children;
        int index;
        EditPart result = null;
        EditPart parent = editPart.getParent();
        if (parent != null && (index = (children = parent.getChildren()).indexOf(editPart)) + 1 < children.size()) {
            result = (EditPart)children.get(index + 1);
        }
        return result;
    }

    static EditPart getSourceConnectionEditPart(AbstractGraphicalEditPart editPart) {
        EditPart result = null;
        EditPartViewer viewer = editPart.getViewer();
        LayerManager manager = (LayerManager)editPart.getViewer().getEditPartRegistry().get(LayerManager.ID);
        IFigure layer = manager.getLayer((Object)"Connection Layer");
        for (Figure figure : layer.getChildren()) {
            ComponentReferenceConnection componentReferenceConnection;
            ConnectionAnchor targetAnchor;
            if (!(figure instanceof ComponentReferenceConnection) || (targetAnchor = (componentReferenceConnection = (ComponentReferenceConnection)figure).getTargetAnchor()).getOwner() != editPart.getFigure()) continue;
            ConnectionAnchor sourceAnchor = componentReferenceConnection.getSourceAnchor();
            IFigure sourceFigure = sourceAnchor.getOwner();
            EditPart part = null;
            while (part == null && sourceFigure != null) {
                part = (EditPart)viewer.getVisualPartMap().get(sourceFigure);
                sourceFigure = sourceFigure.getParent();
            }
            result = part;
            break;
        }
        return result;
    }
}

