/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.editor.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stp.policy.wtp.editor.Activator;
import org.eclipse.stp.policy.wtp.editor.Logger;
import org.osgi.service.prefs.BackingStoreException;

public class ProjectSettings {
    private IProject project;
    private boolean overridesDefaults = false;
    private String schemasPath;
    private static final String SETTINGS_KEY = "org.eclipse.stp.policy.wtp.editor.settings";
    private static final String SCHEMA_PATH = "org.eclipse.stp.policy.wtp.editor.schema.path";
    private static final String OVERRIDES = "org.eclipse.stp.policy.wtp.editor.overrides.global";

    public static ProjectSettings getSettings(IProject project) {
        ProjectSettings settings = null;
        try {
            settings = (ProjectSettings)project.getSessionProperty(ProjectSettings.getSessionPropertyName());
        }
        catch (CoreException e) {
            Logger.error(e);
        }
        if (settings == null) {
            settings = new ProjectSettings(project);
        }
        return settings;
    }

    private ProjectSettings(IProject project) {
        this.project = project;
        ProjectScope projectContext = new ProjectScope(project);
        IEclipsePreferences pref = projectContext.getNode(Activator.getPluginId());
        if (pref != null) {
            this.setOverridesDefaults(Boolean.valueOf(pref.get(OVERRIDES, "false")));
            this.setSchemasPath(pref.get(SCHEMA_PATH, "schemas"));
        }
    }

    private static QualifiedName getSessionPropertyName() {
        return new QualifiedName(Activator.getPluginId(), SETTINGS_KEY);
    }

    public boolean isOverridesDefaults() {
        return this.overridesDefaults;
    }

    public void setOverridesDefaults(boolean overridesDefaults) {
        if (!overridesDefaults) {
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            this.setSchemasPath(store.getString(SCHEMA_PATH));
        }
        this.overridesDefaults = overridesDefaults;
    }

    public String getSchemasPath() {
        return this.schemasPath;
    }

    public void setSchemasPath(String schemasPath) {
        this.schemasPath = schemasPath;
    }

    public void save() {
        try {
            this.project.setSessionProperty(ProjectSettings.getSessionPropertyName(), (Object)this);
        }
        catch (CoreException e) {
            Logger.error(e);
        }
        ProjectScope projectContext = new ProjectScope(this.project);
        IEclipsePreferences pref = projectContext.getNode(Activator.getPluginId());
        if (pref != null) {
            try {
                pref.put(OVERRIDES, String.valueOf(this.isOverridesDefaults()));
                pref.put(SCHEMA_PATH, this.getSchemasPath());
                pref.flush();
            }
            catch (BackingStoreException bse) {
                Logger.warn(bse.getLocalizedMessage());
            }
        }
    }
}

