/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.policy.wtp.validation.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.stp.common.validator.core.impl.SchemaTypeValidator;
import org.eclipse.stp.common.validator.exception.SOPValidationException;
import org.eclipse.stp.policy.wtp.validation.ui.SchemaEntityDecl;
import org.eclipse.swt.widgets.Control;

public class UIControlValidator {
    private static SchemaTypeValidator typeValidator = SchemaTypeValidator.getInstance();
    private Map mapping = new HashMap();

    public void addControl(Control control, SchemaEntityDecl val) {
        this.mapping.put(control, val);
    }

    public String validate(Control control, String valueText) throws IllegalArgumentException {
        String errMsg = null;
        SchemaEntityDecl decl = (SchemaEntityDecl)this.mapping.get(control);
        if (decl != null && valueText != null) {
            try {
                if (1 == decl.getType()) {
                    errMsg = typeValidator.validateAttrib(decl.getSchemaURI(), decl.getEntityName(), valueText);
                } else if (2 == decl.getType()) {
                    errMsg = typeValidator.validateSimpleType(decl.getSchemaURI(), decl.getEntityName(), valueText);
                }
            }
            catch (SOPValidationException e) {
                errMsg = e.getMessage();
            }
        }
        return errMsg;
    }
}

