/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.classloader;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.stp.sca.common.classloader.ScaClassLoader;
import org.eclipse.stp.sca.common.java.ScaCommonJdtPlugin;

public class ScaJdtClassLoader
extends ScaClassLoader {
    public ScaJdtClassLoader(IJavaProject javaProject, ClassLoader parent) {
        super(ScaJdtClassLoader.getJavaProjectClasspath(javaProject), parent);
    }

    public static URL[] getJavaProjectClasspath(IJavaProject javaProject) {
        URL[] urls = null;
        try {
            ArrayList<URL> urlList = new ArrayList<URL>();
            String projectLocation = javaProject.getProject().getLocationURI().toString();
            String binLocation = String.valueOf(javaProject.getOutputLocation().toString().replace(String.valueOf(javaProject.getProject().getName()) + "/", "")) + "/";
            URI uri = new URI(String.valueOf(projectLocation) + binLocation);
            urlList.add(uri.toURL());
            IClasspathEntry[] iClasspathEntryArray = javaProject.getResolvedClasspath(false);
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpEntry = iClasspathEntryArray[n2];
                urlList.add(new URI("file:/" + cpEntry.getPath().toString().replace(" ", "%20")).toURL());
                ++n2;
            }
            urls = new URL[urlList.size()];
            int i = 0;
            while (i < urlList.size()) {
                urls[i] = (URL)urlList.get(i);
                ++i;
            }
            return urls;
        }
        catch (URISyntaxException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common.java", e.getMessage(), (Throwable)e);
            ScaCommonJdtPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (MalformedURLException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common.java", e.getMessage(), (Throwable)e);
            ScaCommonJdtPlugin.getDefault().getLog().log((IStatus)status);
        }
        catch (JavaModelException e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common.java", e.getMessage(), (Throwable)e);
            ScaCommonJdtPlugin.getDefault().getLog().log((IStatus)status);
        }
        return new URL[0];
    }
}

