/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.java.composite2java;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.JavaImplementation;
import org.eclipse.stp.sca.JavaInterface;
import org.eclipse.stp.sca.PropertyValue;
import org.eclipse.stp.sca.Reference;
import org.eclipse.stp.sca.Service;
import org.eclipse.stp.sca.Wire;
import org.eclipse.stp.sca.common.java.Messages;
import org.eclipse.stp.sca.common.java.composite2java.JComposite;
import org.eclipse.stp.sca.common.java.composite2java.JImplementation;
import org.eclipse.stp.sca.common.java.composite2java.JInterface;
import org.eclipse.stp.sca.common.java.composite2java.JProperty;
import org.eclipse.stp.sca.common.java.composite2java.JReference;
import org.eclipse.stp.sca.common.java.utils.JDTUtils;
import org.eclipse.stp.sca.provider.ScaItemProviderAdapterFactory;

public class CompositeToJavaModel {
    public static JComposite getJavaModelFromComposite(IFile compositeFile) throws InvocationTargetException {
        ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        adapterFactory.addAdapterFactory((AdapterFactory)new ResourceItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ScaItemProviderAdapterFactory());
        adapterFactory.addAdapterFactory((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
        BasicCommandStack commandStack = new BasicCommandStack();
        AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)adapterFactory, (CommandStack)commandStack, new HashMap());
        Resource resource = null;
        try {
            URI uri = URI.createFileURI((String)compositeFile.getLocation().toString());
            resource = editingDomain.getResourceSet().getResource(uri, true);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e, NLS.bind((String)Messages.CompositeToJavaModel_0, (Object)compositeFile.getName()));
        }
        DocumentRoot documentRoot = (DocumentRoot)resource.getContents().get(0);
        return CompositeToJavaModel.getJavaModelFromComposite(documentRoot);
    }

    public static JComposite getJavaModelFromComposite(DocumentRoot documentRoot) {
        JInterface ji2;
        JInterface ji;
        String name;
        Composite c = documentRoot.getComposite();
        if (c == null) {
            return null;
        }
        JComposite jc = new JComposite();
        for (Service s : c.getService()) {
            if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
            name = ((JavaInterface)s.getInterface()).getInterface();
            ji = jc.getInterface(name);
            if (ji == null && JDTUtils.validateJavaTypeName(name, null) == null) {
                ji = new JInterface();
                ji.setName(name);
                jc.putInterface(ji.getName(), ji);
            }
            if (s.getPromote2() == null || s.getPromote2().getInterface() == null || !(s.getPromote2().getInterface() instanceof JavaInterface)) continue;
            name = ((JavaInterface)s.getPromote2().getInterface()).getInterface();
            ji2 = jc.getInterface(name);
            if (ji2 == null && JDTUtils.validateJavaTypeName(name, null) == null) {
                ji2 = new JInterface();
                ji2.setName(name);
                jc.putInterface(ji2.getName(), ji2);
            }
            if (ji == null) continue;
            ji2.putInterface(ji.getName(), ji);
        }
        for (Reference r : c.getReference()) {
            if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
            name = ((JavaInterface)r.getInterface()).getInterface();
            ji = jc.getInterface(name);
            if (ji == null && JDTUtils.validateJavaTypeName(name, null) == null) {
                ji = new JInterface();
                ji.setName(name);
                jc.putInterface(ji.getName(), ji);
            }
            if (r.getPromote2() == null || r.getPromote2().getInterface() == null || !(r.getPromote2().getInterface() instanceof JavaInterface)) continue;
            name = ((JavaInterface)r.getPromote2().getInterface()).getInterface();
            ji2 = jc.getInterface(name);
            if (ji2 == null && JDTUtils.validateJavaTypeName(name, null) == null) {
                ji2 = new JInterface();
                ji2.setName(name);
                jc.putInterface(ji2.getName(), ji2);
            }
            if (ji == null) continue;
            ji.putInterface(ji2.getName(), ji2);
        }
        for (Component comp : c.getComponent()) {
            JInterface ji3;
            HashSet<JInterface> services = new HashSet<JInterface>();
            HashSet<JReference> references = new HashSet<JReference>();
            HashSet<JProperty> properties = new HashSet<JProperty>();
            for (ComponentService s : comp.getService()) {
                if (s.getInterface() == null || !(s.getInterface() instanceof JavaInterface)) continue;
                ji3 = jc.getInterface(((JavaInterface)s.getInterface()).getInterface());
                if (ji3 == null) {
                    ji3 = new JInterface();
                    ji3.setName(((JavaInterface)s.getInterface()).getInterface());
                    jc.putInterface(ji3.getName(), ji3);
                }
                services.add(ji3);
            }
            for (ComponentReference r : comp.getReference()) {
                if (r.getInterface() == null || !(r.getInterface() instanceof JavaInterface)) continue;
                ji3 = jc.getInterface(((JavaInterface)r.getInterface()).getInterface());
                if (ji3 == null) {
                    ji3 = new JInterface();
                    ji3.setName(((JavaInterface)r.getInterface()).getInterface());
                    jc.putInterface(ji3.getName(), ji3);
                }
                JReference jr = new JReference();
                jr.setType(ji3);
                jr.setName(r.getName());
                references.add(jr);
            }
            for (PropertyValue p : comp.getProperty()) {
                JProperty jp = new JProperty();
                jp.setName(p.getName());
                jp.setPrimitiveType("Object");
                properties.add(jp);
            }
            if (comp.getImplementation() == null || !(comp.getImplementation() instanceof JavaImplementation)) continue;
            String name2 = ((JavaImplementation)comp.getImplementation()).getClass_();
            JImplementation ji4 = jc.getImplementation(name2);
            if (ji4 == null && JDTUtils.validateJavaTypeName(name2, null) == null) {
                ji4 = new JImplementation();
                ji4.setName(name2);
                jc.putImplementation(ji4.getName(), ji4);
            }
            if (ji4 == null) continue;
            for (JInterface interf : services) {
                ji4.putInterface(interf.getName(), interf);
            }
            for (JReference ref : references) {
                ji4.putReference(ref.getName(), ref);
            }
            for (JProperty prop : properties) {
                ji4.putProperty(prop.getName(), prop);
            }
        }
        for (Wire w : c.getWire()) {
            JInterface target = null;
            JInterface source = null;
            if (w.getTarget2() != null && w.getTarget2().getInterface() != null && w.getTarget2().getInterface() instanceof JavaInterface) {
                target = jc.getInterface(((JavaInterface)w.getTarget2().getInterface()).getInterface());
            }
            if (w.getSource2() != null && w.getSource2().getInterface() != null && w.getSource2().getInterface() instanceof JavaInterface) {
                source = jc.getInterface(((JavaInterface)w.getSource2().getInterface()).getInterface());
            }
            if (target == null || source == null) continue;
            target.putInterface(source.getName(), source);
        }
        for (Component comp : c.getComponent()) {
            for (ComponentReference r : comp.getReference()) {
                JInterface target = null;
                JInterface source = null;
                if (r.getInterface() != null && r.getInterface() instanceof JavaInterface) {
                    source = jc.getInterface(((JavaInterface)r.getInterface()).getInterface());
                }
                if (r.getTarget2() != null && r.getTarget2().getInterface() != null && r.getTarget2().getInterface() instanceof JavaInterface) {
                    target = jc.getInterface(((JavaInterface)r.getTarget2().getInterface()).getInterface());
                }
                if (target == null || source == null) continue;
                target.putInterface(source.getName(), source);
            }
        }
        return jc;
    }
}

