/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.internal.provisional.builder;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.DocumentRoot;
import org.eclipse.stp.sca.common.internal.Messages;
import org.eclipse.stp.sca.common.internal.builder.ScaCustomDiagnostician;
import org.eclipse.stp.sca.common.internal.builder.ScaDependencyGraph;
import org.eclipse.stp.sca.common.internal.builder.ScaDependencyVertex;
import org.eclipse.stp.sca.common.internal.provisional.builder.ScaAbstractValidationExtension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScaValidator {
    private List<ScaAbstractValidationExtension> extensions = new ArrayList<ScaAbstractValidationExtension>();
    private ScaDependencyGraph graph = new ScaDependencyGraph();

    public boolean addValidationExtension(ScaAbstractValidationExtension o) {
        return this.extensions.add(o);
    }

    public boolean addAllValidationExtensions(Collection<? extends ScaAbstractValidationExtension> c) {
        return this.extensions.addAll(c);
    }

    public void clearResources() {
        this.graph.clearVertices();
    }

    public void loadResource(File file) {
        this.graph.loadVertex(file);
    }

    public void removeResource(File file) {
        this.graph.removeVertex(file);
    }

    public Map<Diagnostic, File> performValidation() {
        HashMap<Diagnostic, File> diagnostics = new HashMap<Diagnostic, File>();
        Iterator<Object> iterator = this.graph.findFilesEmfCouldNotLoad().iterator();
        if (iterator.hasNext()) {
            ScaDependencyVertex vertex = iterator.next();
            String filename = vertex.getFile().getName();
            String message = NLS.bind((String)Messages.IncrementalBuilder_2, (Object)filename);
            BasicDiagnostic d = new BasicDiagnostic(4, vertex.getFile().getAbsolutePath(), 0, message, new Object[0]);
            diagnostics.put((Diagnostic)d, vertex.getFile());
            return diagnostics;
        }
        iterator = this.graph.findFilesWithWrongName().iterator();
        if (iterator.hasNext()) {
            ScaDependencyVertex vertex = iterator.next();
            String filename = vertex.getFile().getName();
            String message = NLS.bind((String)Messages.IncrementalBuilder_3, (Object)filename);
            DocumentRoot eObject = null;
            if (vertex.getEmfResource() != null) {
                DocumentRoot root = (DocumentRoot)vertex.getEmfResource().getContents().get(0);
                eObject = root.getComposite() == null ? root : root.getComposite();
            }
            BasicDiagnostic d = new BasicDiagnostic(4, vertex.getFile().getAbsolutePath(), 0, message, new Object[]{eObject});
            diagnostics.put((Diagnostic)d, vertex.getFile());
            return diagnostics;
        }
        iterator = this.graph.findFilesWithSameIds().iterator();
        if (iterator.hasNext()) {
            ScaDependencyVertex vertex = iterator.next();
            String message = NLS.bind((String)Messages.IncrementalBuilder_5, (Object[])new Object[]{vertex.getName().getLocalPart(), vertex.getName().getNamespaceURI()});
            DocumentRoot eObject = null;
            if (vertex.getEmfResource() != null) {
                DocumentRoot root = (DocumentRoot)vertex.getEmfResource().getContents().get(0);
                eObject = root.getComposite() == null ? root : root.getComposite();
            }
            BasicDiagnostic d = new BasicDiagnostic(4, vertex.getFile().getAbsolutePath(), 0, message, new Object[]{eObject});
            diagnostics.put((Diagnostic)d, vertex.getFile());
            return diagnostics;
        }
        iterator = this.graph.findDependencyCycles().entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            File file = ((ScaDependencyVertex)entry.getKey()).getFile();
            String message = NLS.bind((String)Messages.IncrementalBuilder_8, entry.getValue());
            DocumentRoot eObject = null;
            if (((ScaDependencyVertex)entry.getKey()).getEmfResource() != null) {
                DocumentRoot root = (DocumentRoot)((ScaDependencyVertex)entry.getKey()).getEmfResource().getContents().get(0);
                eObject = root.getComposite() == null ? root : root.getComposite();
            }
            BasicDiagnostic d = new BasicDiagnostic(4, file.getAbsolutePath(), 0, message, new Object[]{eObject});
            diagnostics.put((Diagnostic)d, file);
            return diagnostics;
        }
        for (ScaDependencyVertex vertex : this.graph.getFilesToValidateWithEmf()) {
            URI uri;
            if (vertex.getEmfResource() == null) continue;
            DocumentRoot root = (DocumentRoot)vertex.getEmfResource().getContents().get(0);
            Diagnostic diagnostic = null;
            try {
                diagnostic = new ScaCustomDiagnostician().validate((EObject)root);
            }
            catch (Exception e) {
                diagnostic = new BasicDiagnostic(4, e.getMessage(), 0, Messages.ScaIncrementalBuilder_3, new Object[0]);
            }
            if (diagnostic.getSeverity() != 0) {
                diagnostics.put(diagnostic, vertex.getFile());
            }
            if ((uri = root.eResource().getURI()).isPlatform()) continue;
            for (ScaAbstractValidationExtension ext : this.extensions) {
                if (!ext.initialize(root, vertex.getFile())) continue;
                diagnostics.putAll(ext.validatePreRequisites());
                diagnostics.putAll(ext.validateInterfaceCompatibilityInPromotes());
                diagnostics.putAll(ext.validateInterfaceCompatibilityInWires());
                diagnostics.putAll(ext.validateInterfaceImplementations());
                diagnostics.putAll(ext.validateReferencesInImplementations());
                diagnostics.putAll(ext.validateOthers());
            }
        }
        return diagnostics;
    }
}

