/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.common.utils;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.stp.sca.common.ScaCommonPlugin;
import org.eclipse.stp.sca.common.internal.provisional.filters.ScaResourceFiltersEPManager;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceUtils {
    public static List<IFile> getFiles(IContainer container, String extension) {
        ArrayList<IFile> result = new ArrayList<IFile>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 1: {
                        String fileExtension = resource.getFileExtension().toLowerCase();
                        if (!fileExtension.equals(extension) && !fileExtension.equals("*")) break;
                        result.add((IFile)resource);
                        break;
                    }
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.addAll(ResourceUtils.getFiles((IContainer)subFolder, extension));
                        break;
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<IFolder> getFolders(IContainer container) {
        ArrayList<IFolder> result = new ArrayList<IFolder>();
        try {
            IResource[] resources;
            IResource[] iResourceArray = resources = container.members();
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                IResource resource = iResourceArray[n2];
                switch (resource.getType()) {
                    case 2: {
                        IFolder subFolder = (IFolder)resource;
                        result.add(subFolder);
                        result.addAll(ResourceUtils.getFolders((IContainer)subFolder));
                    }
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static IFile getIFileFromEditor() {
        try {
            IEditorPart editorPart = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            return ((FileEditorInput)editorPart.getEditorInput()).getFile();
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.stp.sca.common", "Error while trying to get the file from the active editor.", (Throwable)e);
            ScaCommonPlugin.getDefault().getLog().log((IStatus)status);
            return null;
        }
    }

    public static IResource[] getDirectValidChildren(IContainer container, List<String> extensions, List<IResource> resourcesToSkip) {
        IResource[] res;
        if (container instanceof IProject && !((IProject)container).isOpen()) {
            return new IResource[0];
        }
        try {
            res = container.members();
        }
        catch (CoreException e) {
            e.printStackTrace();
            res = new IResource[]{};
        }
        ArrayList<IResource> resources = new ArrayList<IResource>();
        IResource[] iResourceArray = res;
        int n = res.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if (!resourcesToSkip.contains(r)) {
                String extension;
                if (r instanceof IContainer) {
                    IResource[] subRes = ResourceUtils.getDirectValidChildren((IContainer)r, extensions, resourcesToSkip);
                    if (subRes.length > 0) {
                        resources.add(r);
                    }
                } else if (r instanceof IFile && extensions.contains(extension = ((IFile)r).getFileExtension())) {
                    resources.add(r);
                }
            }
            ++n2;
        }
        res = new IResource[resources.size()];
        return resources.toArray(res);
    }

    public static IResource[] getDirectValidChildren(IContainer container, String[] extensions, List<IResource> resourcesToSkip) {
        return ResourceUtils.getDirectValidChildren(container, Arrays.asList(extensions), resourcesToSkip);
    }

    public static File getPluginBinaryPath(String pluginId, String binaryFolderName) {
        if (binaryFolderName == null || binaryFolderName.trim().length() == 0) {
            binaryFolderName = "bin";
        }
        try {
            File binaryFolder;
            File bundleFile = FileLocator.getBundleFile((Bundle)Platform.getBundle((String)pluginId));
            if (bundleFile.isFile()) {
                return bundleFile;
            }
            if (bundleFile.isDirectory() && (binaryFolder = new File(bundleFile, binaryFolderName)).exists() && binaryFolder.isDirectory()) {
                return binaryFolder;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static IFile getIFile(File file) {
        Path path = new Path(file.getAbsolutePath());
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)path);
    }

    public static IFile getCompositeFile(String compositeName) {
        if (compositeName == null) {
            return null;
        }
        IFile result = null;
        IFile currentCompositeFile = ResourceUtils.getIFileFromEditor();
        if (currentCompositeFile == null) {
            return null;
        }
        IProject project = currentCompositeFile.getProject();
        List<IFile> compo = ResourceUtils.getFiles((IContainer)project, "composite");
        Iterator<IFile> composites = ScaResourceFiltersEPManager.getInstance().filterAllowedFiles(compo).iterator();
        while (result == null && composites.hasNext()) {
            IFile compositeFile = composites.next();
            if (!compositeName.equals(compositeFile.getName())) continue;
            result = compositeFile;
        }
        if (result == null) {
            try {
                IProject[] projects = project.getReferencedProjects();
                int i = 0;
                while (result == null && i < projects.length) {
                    List<IFile> compo2 = ResourceUtils.getFiles((IContainer)projects[i], "composite");
                    Iterator<IFile> compositesIt = ScaResourceFiltersEPManager.getInstance().filterAllowedFiles(compo2).iterator();
                    while (result == null && compositesIt.hasNext()) {
                        IFile compositeFile = compositesIt.next();
                        if (!compositeName.equals(compositeFile.getName())) continue;
                        result = compositeFile;
                    }
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return result;
    }
}

