/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.diagram.edit.commands;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.stp.sca.BaseReference;
import org.eclipse.stp.sca.BaseService;
import org.eclipse.stp.sca.diagram.edit.policies.ScaBaseItemSemanticEditPolicy;

public class BaseReferenceTarget2ReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject referenceOwner;
    private final EObject oldEnd;
    private final EObject newEnd;

    public BaseReferenceTarget2ReorientCommand(ReorientReferenceRelationshipRequest request) {
        super(request.getLabel(), null, (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.referenceOwner = request.getReferenceOwner();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.referenceOwner instanceof BaseReference)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof BaseService) || !(this.newEnd instanceof BaseReference)) {
            return false;
        }
        return ScaBaseItemSemanticEditPolicy.LinkConstraints.canExistBaseReferenceTarget2_4004(this.getNewSource(), this.getOldTarget());
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof BaseService) || !(this.newEnd instanceof BaseService)) {
            return false;
        }
        return ScaBaseItemSemanticEditPolicy.LinkConstraints.canExistBaseReferenceTarget2_4004(this.getOldSource(), this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() {
        this.getOldSource().setTarget2(null);
        this.getNewSource().setTarget2(this.getOldTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected CommandResult reorientTarget() {
        this.getOldSource().setTarget2(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.referenceOwner);
    }

    protected BaseReference getOldSource() {
        return (BaseReference)this.referenceOwner;
    }

    protected BaseReference getNewSource() {
        return (BaseReference)this.newEnd;
    }

    protected BaseService getOldTarget() {
        return (BaseService)this.oldEnd;
    }

    protected BaseService getNewTarget() {
        return (BaseService)this.newEnd;
    }
}

