/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.formeditor;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.stp.sca.formeditor.Messages;
import org.eclipse.stp.sca.formeditor.pages.AbstractPage;
import org.eclipse.stp.sca.formeditor.pages.OverviewPage;
import org.eclipse.stp.sca.formeditor.pages.components.ComponentsPage;
import org.eclipse.stp.sca.formeditor.pages.includes.IncludesPage;
import org.eclipse.stp.sca.formeditor.pages.policies.PoliciesPage;
import org.eclipse.stp.sca.formeditor.pages.properties.PropertiesPage;
import org.eclipse.stp.sca.formeditor.pages.references.ReferencesPage;
import org.eclipse.stp.sca.formeditor.pages.services.ServicesPage;
import org.eclipse.stp.sca.formeditor.pages.wires.WiresPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IModelStateListener;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;

public class ScaFormEditor
extends FormEditor
implements ISelectionProvider,
IMenuListener,
IGotoMarker {
    private FormToolkit toolkit;
    private IDOMModel model;
    private AbstractPage overviewPage;
    private AbstractPage servicesPage;
    private AbstractPage referencesPage;
    private AbstractPage wiresPage;
    private AbstractPage ctsPage;
    private AbstractPage propertiesPage;
    private AbstractPage componentsPage;
    private AbstractPage includesPage;
    private AbstractPage policiesPage;
    private StructuredTextEditor editor;
    private static final String COMPOSITE_TEXT_EDITOR_ID = "org.eclipse.stp.sca.xmleditor.composite";
    private IFile editedFile;
    Map<String, AbstractPage> pages = new HashMap<String, AbstractPage>();

    protected FormToolkit createToolkit(Display display) {
        FormColors formColors = new FormColors(Display.getDefault());
        FormToolkit toolkit = new FormToolkit(formColors);
        return toolkit;
    }

    protected void addPages() {
        this.loadSharedModel();
        try {
            this.overviewPage = new OverviewPage(this, "org.eclipse.stp.sca.formeditor.overview", Messages.ScaFormEditor_1);
            this.addPage((IFormPage)this.overviewPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.overview", this.overviewPage);
            this.componentsPage = new ComponentsPage(this, "org.eclipse.stp.sca.formeditor.components", Messages.ScaFormEditor_3);
            this.addPage((IFormPage)this.componentsPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.components", this.componentsPage);
            this.servicesPage = new ServicesPage(this, "org.eclipse.stp.sca.formeditor.services", Messages.ScaFormEditor_2);
            this.addPage((IFormPage)this.servicesPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.services", this.servicesPage);
            this.referencesPage = new ReferencesPage(this, "org.eclipse.stp.sca.formeditor.references", Messages.ScaFormEditor_5);
            this.addPage((IFormPage)this.referencesPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.references", this.referencesPage);
            this.wiresPage = new WiresPage(this, "org.eclipse.stp.sca.formeditor.wires", Messages.ScaFormEditor_4);
            this.addPage((IFormPage)this.wiresPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.wires", this.wiresPage);
            this.propertiesPage = new PropertiesPage(this, "org.eclipse.stp.sca.formeditor.properties", Messages.ScaFormEditor_6);
            this.addPage((IFormPage)this.propertiesPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.properties", this.propertiesPage);
            this.includesPage = new IncludesPage(this, "org.eclipse.stp.sca.formeditor.includes", Messages.ScaFormEditor_7);
            this.addPage((IFormPage)this.includesPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.includes", this.includesPage);
            this.policiesPage = new PoliciesPage(this, "org.eclipse.stp.sca.formeditor.policies", Messages.ScaFormEditor_0);
            this.addPage((IFormPage)this.policiesPage);
            this.pages.put("org.eclipse.stp.sca.formeditor.policies", this.policiesPage);
            this.editor = new StructuredTextEditor();
            int index = this.addPage((IEditorPart)this.editor, this.getEditorInput());
            this.setPageText(index, Messages.ScaFormEditor_9);
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        this.updateEditor();
    }

    protected IEditorSite createSite(IEditorPart page) {
        Object site = null;
        site = page == this.editor ? new MultiPageEditorSite((MultiPageEditorPart)this, page){

            public String getId() {
                return ScaFormEditor.COMPOSITE_TEXT_EDITOR_ID;
            }
        } : super.createSite(page);
        return site;
    }

    protected void loadSharedModel() {
        try {
            this.editedFile = ((FileEditorInput)this.getEditorInput()).getFile();
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForEdit(this.editedFile);
            if (model == null) {
                model = StructuredModelManager.getModelManager().getModelForEdit(this.editedFile);
            }
            this.model = (IDOMModel)model;
            this.model.addModelStateListener(new IModelStateListener(){

                public void modelAboutToBeChanged(IStructuredModel model) {
                }

                public void modelAboutToBeReinitialized(IStructuredModel structuredModel) {
                }

                public void modelChanged(IStructuredModel model) {
                    ScaFormEditor.this.updateEditor();
                }

                public void modelDirtyStateChanged(IStructuredModel model, boolean isDirty) {
                }

                public void modelReinitialized(IStructuredModel structuredModel) {
                    ScaFormEditor.this.updateEditor();
                }

                public void modelResourceDeleted(IStructuredModel model) {
                }

                public void modelResourceMoved(IStructuredModel oldModel, IStructuredModel newModel) {
                }
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private void updateEditor() {
        for (AbstractPage page : this.pages.values()) {
            page.setDocument((Document)this.model.getDocument());
            if (page.getPartControl() == null) continue;
            page.updatePage();
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) {
        this.setSite((IWorkbenchPartSite)site);
        this.setInputWithNotify(editorInput);
        this.setPartName(editorInput.getName());
        site.setSelectionProvider((ISelectionProvider)this);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            this.model.save();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doSaveAs() {
        SaveAsDialog dialog = new SaveAsDialog(this.getSite().getShell());
        dialog.open();
        IPath path = dialog.getResult();
        if (path == null) {
            return;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            this.model.save(file);
            file.getProject().refreshLocal(2, (IProgressMonitor)monitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public ISelection getSelection() {
        return null;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
    }

    public void setSelection(ISelection selection) {
    }

    public void menuAboutToShow(IMenuManager manager) {
    }

    public void gotoMarker(IMarker marker) {
    }

    public void dispose() {
        if (this.model != null) {
            this.model.releaseFromEdit();
        }
        super.dispose();
    }

    public IFile getEditedFile() {
        return this.editedFile;
    }

    public void aboutToChangeModel() {
        this.model.aboutToChangeModel();
    }

    public void changedModel() {
        this.model.changedModel();
    }

    static /* synthetic */ void access$0(ScaFormEditor scaFormEditor) {
        scaFormEditor.updateEditor();
    }
}

