/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.introspection;

import org.eclipse.stp.sca.BaseService;
import org.eclipse.stp.sca.Component;
import org.eclipse.stp.sca.ComponentReference;
import org.eclipse.stp.sca.ComponentService;
import org.eclipse.stp.sca.Composite;
import org.eclipse.stp.sca.Wire;
import org.eclipse.stp.sca.introspection.IntrospectionUtils;
import org.eclipse.stp.sca.introspection.Resolver;

public class ReferenceResolver
implements Resolver {
    private ClassLoader classLoader;

    public ReferenceResolver(ClassLoader classLoaderC) {
        this.classLoader = classLoaderC;
    }

    public Composite resolve(Composite composite) {
        this.completeExistingReferences(composite);
        return composite;
    }

    private void completeExistingReferences(Composite composite) {
        for (Wire wire : composite.getWire()) {
            String componentName;
            Component component;
            if (wire.getTarget() != null && wire.getTarget().indexOf("/") == -1 && (component = IntrospectionUtils.getComponent(composite, componentName = wire.getTarget())).getService().size() == 1) {
                wire.setTarget2((ComponentService)component.getService().get(0));
            }
            if (wire.getSource() == null || wire.getSource().indexOf("/") != -1 || (component = IntrospectionUtils.getComponent(composite, componentName = wire.getSource())).getReference().size() != 1) continue;
            wire.setSource2((ComponentReference)component.getReference().get(0));
        }
        for (Component component : composite.getComponent()) {
            for (ComponentReference ref : component.getReference()) {
                String componentName;
                Component c;
                if (ref.getTarget() == null || ref.getTarget().indexOf("/") != -1 || (c = IntrospectionUtils.getComponent(composite, componentName = ref.getTarget())).getService().size() != 1) continue;
                ref.setTarget2((BaseService)c.getService().get(0));
            }
        }
    }
}

