/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.ontology.view.preferences;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.ontology.view.Messages;
import org.eclipse.stp.sca.ontology.view.preferences.OntologySourcesPreferences;
import org.eclipse.stp.sca.ontology.view.search.OntologyModelManager;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class OntologySourcesDialog
extends Dialog {
    private FormToolkit toolkit;
    private boolean useLocalSources = true;
    private boolean useRemoteSources = false;
    private TableViewer[] viewers = new TableViewer[2];
    private Map<String, Boolean> localOwlSources = OntologySourcesPreferences.getSavedLocations(true);
    private Map<String, Boolean> remoteOwlSources = OntologySourcesPreferences.getSavedLocations(false);
    private List<String> removedLocalOwlSources = new ArrayList<String>();
    private List<String> removedRemoteOwlSources = new ArrayList<String>();

    public OntologySourcesDialog(Shell parentShell) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.adapt(parent);
        this.toolkit.adapt(container);
        Form form = this.toolkit.createForm(container);
        form.setText(Messages.OwlSourcesDialog_0);
        form.getBody().setLayout((Layout)new GridLayout());
        CTabFolder folder = new CTabFolder(form.getBody(), 128);
        folder.setLayoutData((Object)new GridData(1808));
        this.toolkit.adapt((Composite)folder);
        this.createGeneralPreferencesTab(new CTabItem(folder, 0));
        this.createSourcesTab(new CTabItem(folder, 0), Messages.OwlSourcesDialog_1, 0);
        this.createSourcesTab(new CTabItem(folder, 0), Messages.OwlSourcesDialog_2, 1);
        return container;
    }

    private void createGeneralPreferencesTab(CTabItem item) {
        Composite container = this.toolkit.createComposite((Composite)item.getParent(), 0);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        Label label = this.toolkit.createLabel(container, Messages.OwlSourcesDialog_3);
        GridData layoutData = new GridData();
        layoutData.verticalIndent = 10;
        label.setLayoutData((Object)layoutData);
        Button b = this.toolkit.createButton(container, Messages.OwlSourcesDialog_4, 32);
        layoutData = new GridData();
        layoutData.verticalIndent = 10;
        layoutData.horizontalIndent = 20;
        b.setLayoutData((Object)layoutData);
        if (OntologySourcesPreferences.getSourcesUse(true)) {
            this.useLocalSources = true;
            b.setSelection(true);
        }
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OntologySourcesDialog.this.useLocalSources = ((Button)e.widget).getSelection();
            }
        });
        b = this.toolkit.createButton(container, Messages.OwlSourcesDialog_5, 32);
        layoutData = new GridData();
        layoutData.horizontalIndent = 20;
        b.setLayoutData((Object)layoutData);
        if (OntologySourcesPreferences.getSourcesUse(false)) {
            this.useRemoteSources = true;
            b.setSelection(true);
        }
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OntologySourcesDialog.this.useRemoteSources = ((Button)e.widget).getSelection();
            }
        });
        item.setText(Messages.OwlSourcesDialog_6);
        item.setControl((Control)container);
    }

    private void createSourcesTab(CTabItem item, String title, final int index) {
        final Map<String, Boolean> map = index == 0 ? this.localOwlSources : this.remoteOwlSources;
        Composite container = this.toolkit.createComposite((Composite)item.getParent());
        GridLayout layout = new GridLayout(2, false);
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        TableViewer viewer = new TableViewer(container, 101156);
        viewer.getTable().setLayoutData((Object)new GridData(1808));
        viewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object object) {
                if (object instanceof Map) {
                    return ((Map)object).keySet().toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        this.viewers[index] = viewer;
        viewer.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item = (TableItem)e.item;
                map.put(item.getText(), item.getChecked());
            }
        });
        viewer.setInput(map);
        TableItem[] tableItemArray = viewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem ti = tableItemArray[n2];
            ti.setChecked(map.get(ti.getText()).booleanValue());
            ++n2;
        }
        Composite buttons = this.toolkit.createComposite(container);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        Button b = this.toolkit.createButton(buttons, Messages.OwlSourcesDialog_7, 8);
        b.setLayoutData((Object)new GridData(768));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OntologySourcesDialog.this.addOwlSource(index);
            }
        });
        b = this.toolkit.createButton(buttons, Messages.OwlSourcesDialog_8, 8);
        b.setLayoutData((Object)new GridData(768));
        b.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OntologySourcesDialog.this.removeOwlSource(index);
            }
        });
        item.setText(title);
        item.setControl((Control)container);
    }

    protected void addOwlSource(int index) {
        if (index == 0) {
            FileDialog dlg = new FileDialog(this.getShell(), 2);
            dlg.setFilterExtensions(new String[]{"*.owl"});
            dlg.setText(Messages.OwlSourcesDialog_10);
            if (dlg.open() == null) {
                return;
            }
            File root = new File(dlg.getFilterPath());
            String[] stringArray = dlg.getFileNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                block8: {
                    String value;
                    String fileLocation = stringArray[n2];
                    File file = new File(root, fileLocation);
                    try {
                        value = file.toURI().toURL().toString();
                    }
                    catch (MalformedURLException e) {
                        break block8;
                    }
                    if (file.exists()) {
                        this.localOwlSources.put(value, false);
                        this.removedLocalOwlSources.remove(value);
                    }
                }
                ++n2;
            }
        } else {
            String value;
            IInputValidator validator = new IInputValidator(){

                public String isValid(String url) {
                    try {
                        new URL(url);
                    }
                    catch (MalformedURLException e) {
                        return Messages.OwlSourcesDialog_11;
                    }
                    return null;
                }
            };
            InputDialog dlg = new InputDialog(this.getShell(), Messages.OwlSourcesDialog_12, Messages.OwlSourcesDialog_13, "http://", validator);
            if (dlg.open() == 0 && (value = dlg.getValue()) != null) {
                this.remoteOwlSources.put(value, false);
                this.removedRemoteOwlSources.remove(value);
            }
        }
        this.viewers[index].refresh();
    }

    protected void removeOwlSource(int index) {
        if (this.viewers[index].getSelection().isEmpty()) {
            return;
        }
        String value = (String)((StructuredSelection)this.viewers[index].getSelection()).getFirstElement();
        if (index == 0) {
            this.localOwlSources.remove(value);
            this.removedLocalOwlSources.add(value);
        } else {
            this.remoteOwlSources.remove(value);
            this.removedRemoteOwlSources.add(value);
        }
        this.viewers[index].refresh();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.toolkit != null) {
            this.toolkit.adapt(parent);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected void okPressed() {
        IRunnableWithProgress loadingOperation = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        monitor.beginTask(Messages.OwlSourcesDialog_15, 3 + OntologySourcesDialog.this.localOwlSources.size() + OntologySourcesDialog.this.remoteOwlSources.size());
                        if (OntologySourcesDialog.this.useLocalSources) {
                            for (Map.Entry entry : OntologySourcesDialog.this.localOwlSources.entrySet()) {
                                monitor.setTaskName(NLS.bind((String)Messages.OwlSourcesDialog_16, entry.getKey()));
                                if (!((Boolean)entry.getValue()).booleanValue()) {
                                    OntologyModelManager.INSTANCE.removeModelFile((String)entry.getKey());
                                } else {
                                    OntologyModelManager.INSTANCE.addModelFile((String)entry.getKey());
                                }
                                monitor.worked(1);
                                if (!monitor.isCanceled()) continue;
                                throw new InterruptedException();
                            }
                        } else {
                            monitor.worked(OntologySourcesDialog.this.localOwlSources.size());
                        }
                        if (OntologySourcesDialog.this.useRemoteSources) {
                            for (Map.Entry entry : OntologySourcesDialog.this.remoteOwlSources.entrySet()) {
                                monitor.setTaskName(NLS.bind((String)Messages.OwlSourcesDialog_16, entry.getKey()));
                                if (!((Boolean)entry.getValue()).booleanValue()) {
                                    OntologyModelManager.INSTANCE.removeModelFile((String)entry.getKey());
                                } else {
                                    OntologyModelManager.INSTANCE.addModelFile((String)entry.getKey());
                                }
                                monitor.worked(1);
                                if (!monitor.isCanceled()) continue;
                                throw new InterruptedException();
                            }
                        } else {
                            monitor.worked(OntologySourcesDialog.this.remoteOwlSources.size());
                        }
                        monitor.setTaskName(Messages.OwlSourcesDialog_20);
                        for (String string : OntologySourcesDialog.this.removedLocalOwlSources) {
                            OntologyModelManager.INSTANCE.removeModelFile(string);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.setTaskName(Messages.OwlSourcesDialog_21);
                        for (String string : OntologySourcesDialog.this.removedRemoteOwlSources) {
                            OntologyModelManager.INSTANCE.removeModelFile(string);
                        }
                        monitor.worked(1);
                        if (monitor.isCanceled()) {
                            throw new InterruptedException();
                        }
                        monitor.setTaskName(Messages.OwlSourcesDialog_22);
                        OntologySourcesPreferences.setSourcesUse(OntologySourcesDialog.this.useLocalSources, true);
                        OntologySourcesPreferences.saveOwlSourcesLocation(OntologySourcesDialog.this.localOwlSources, true);
                        OntologySourcesPreferences.setSourcesUse(OntologySourcesDialog.this.useRemoteSources, false);
                        OntologySourcesPreferences.saveOwlSourcesLocation(OntologySourcesDialog.this.remoteOwlSources, false);
                        monitor.worked(1);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new ProgressMonitorDialog(shell).run(true, true, loadingOperation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.okPressed();
    }
}

