/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.hyperlinks;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.stp.sca.common.utils.DomUtils;
import org.eclipse.stp.sca.common.utils.ResourceUtils;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JavaFileHyperlinkDetector
implements IHyperlinkDetector {
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        IDocument document = textViewer.getDocument();
        Node node = this.getNodeByOffset(document, region.getOffset());
        if (node != null) {
            IRegion nodeRegion;
            String className;
            block17: {
                Element elt = null;
                if (node.getNodeType() == 1) {
                    elt = (Element)node;
                } else if (node.getNodeType() == 2) {
                    elt = ((Attr)node).getOwnerElement();
                }
                if (elt == null) {
                    return null;
                }
                String name = DomUtils.getNodeName((Node)elt).toLowerCase();
                className = null;
                if (name.equals("interface.java")) {
                    className = elt.getAttribute("interface");
                }
                if (name.equals("implementation.java")) {
                    className = elt.getAttribute("class");
                }
                if (className == null) {
                    return null;
                }
                nodeRegion = region;
                try {
                    IRegion lineRegion = document.getLineInformationOfOffset(region.getOffset());
                    String lineText = document.get(lineRegion.getOffset(), lineRegion.getLength());
                    if (lineText.contains(className)) {
                        int length = className.length();
                        int start = lineRegion.getOffset() + lineText.indexOf(className);
                        nodeRegion = new Region(start, length);
                        break block17;
                    }
                    return null;
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                }
            }
            IFile file = ResourceUtils.getIFileFromEditor();
            if (file == null) {
                return null;
            }
            IProject project = file.getProject();
            try {
                if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                    return null;
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
                return null;
            }
            IJavaProject jp = JavaCore.create((IProject)project);
            try {
                IType type = jp.findType(className);
                String cl = className;
                IRegion nr = nodeRegion;
                IHyperlink pomHyperlink = new IHyperlink(){

                    public IRegion getHyperlinkRegion() {
                        return nr;
                    }

                    public String getHyperlinkText() {
                        return cl;
                    }

                    public String getTypeLabel() {
                        return "Java SCA";
                    }

                    public void open() {
                        try {
                            if (type != null) {
                                JavaUI.openInEditor((IJavaElement)type, (boolean)true, (boolean)true);
                            } else {
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        MessageDialog.openWarning((Shell)new Shell(), (String)Messages.JavaFileHyperlinkDetector_0, (String)Messages.JavaFileHyperlinkDetector_1);
                                    }
                                });
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                return new IHyperlink[]{pomHyperlink};
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
        }
        return null;
    }

    private Node getNodeByOffset(IDocument document, int offset) {
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(document);
            IndexedRegion indexedRegion = model.getIndexedRegion(offset);
            if (indexedRegion == null) {
                indexedRegion = model.getIndexedRegion(offset - 1);
            }
            if (indexedRegion instanceof Node) {
                return (Node)indexedRegion;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

