/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.sca.xmleditor.preferences;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.layout.TreeColumnLayout;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stp.sca.xmleditor.Messages;
import org.eclipse.stp.sca.xmleditor.ScaXmlEditorPlugin;
import org.eclipse.stp.sca.xmleditor.preferences.DefaultPreferences;
import org.eclipse.stp.sca.xmleditor.preferences.ScaXmlPreferenceUtils;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlAttribute;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlElement;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlItem;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlNamespace;
import org.eclipse.stp.sca.xmleditor.preferences.beans.ScaXmlPlatform;
import org.eclipse.stp.sca.xmleditor.preferences.dialogs.AttributeEditionDialog;
import org.eclipse.stp.sca.xmleditor.preferences.dialogs.ElementEditionDialog;
import org.eclipse.stp.sca.xmleditor.preferences.dialogs.RootElementEditionDialog;
import org.eclipse.stp.sca.xmleditor.preferences.viewers.PlatformAndNsContentProvider;
import org.eclipse.stp.sca.xmleditor.preferences.viewers.ScaXmlContentProvider;
import org.eclipse.stp.sca.xmleditor.preferences.viewers.ScaXmlLabelProvider;
import org.eclipse.stp.sca.xmleditor.preferences.viewers.ScaXmlViewerFilter;
import org.eclipse.stp.sca.xmleditor.preferences.viewers.ScaXmlViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ScaXmlPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private TreeViewer nsViewer;
    private Map<ScaXmlPlatform.ScaXmlElementType, TreeViewer> viewers = new HashMap<ScaXmlPlatform.ScaXmlElementType, TreeViewer>();
    private Map<ScaXmlPlatform.ScaXmlElementType, Combo> combos = new HashMap<ScaXmlPlatform.ScaXmlElementType, Combo>();
    private List<ScaXmlPlatform> platforms = ScaXmlPreferenceUtils.getPlatformsFromPS();
    private ViewerSorter sorter = new ScaXmlViewerSorter();

    protected void performDefaults() {
        this.platforms = DefaultPreferences.getInstance().getDefaultPreferences();
        this.refreshViewers();
    }

    public boolean performOk() {
        this.performApply();
        return super.performOk();
    }

    protected void performApply() {
        ScaXmlPreferenceUtils.savePlatformsToPS(this.platforms);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(ScaXmlEditorPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.ScaXmlPreferencePage_0);
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4));
        container.setLayout((Layout)new GridLayout());
        TabFolder tabFolder = new TabFolder(container, 128);
        GridData gd = new GridData(1808);
        gd.heightHint = 375;
        gd.widthHint = 400;
        tabFolder.setLayoutData((Object)gd);
        this.createPlatformsControl(tabFolder);
        ScaXmlPlatform.ScaXmlElementType[] scaXmlElementTypeArray = ScaXmlPlatform.ScaXmlElementType.values();
        int n = scaXmlElementTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ScaXmlPlatform.ScaXmlElementType type = scaXmlElementTypeArray[n2];
            TreeViewer viewer = this.createItemsControl(tabFolder, type);
            this.viewers.put(type, viewer);
            ++n2;
        }
        return container;
    }

    private void refreshViewers() {
        this.nsViewer.setInput(this.platforms);
        this.nsViewer.refresh();
        this.nsViewer.expandAll();
        for (TreeViewer viewer : this.viewers.values()) {
            viewer.setInput(this.platforms);
            viewer.refresh();
            viewer.expandToLevel(1);
        }
    }

    private ScaXmlItem getSelectedItem(TreeViewer viewer) {
        if (viewer.getSelection().isEmpty()) {
            return null;
        }
        Object o = ((IStructuredSelection)viewer.getSelection()).getFirstElement();
        if (o instanceof ScaXmlItem) {
            return (ScaXmlItem)o;
        }
        return null;
    }

    private void updateNameSpaceCombo(Combo nsCombo, ScaXmlPlatform.ScaXmlElementType elementType) {
        nsCombo.removeAll();
        nsCombo.add("");
        for (ScaXmlPlatform platform : this.platforms) {
            Set<ScaXmlNamespace> nsList = elementType == ScaXmlPlatform.ScaXmlElementType.bindings ? platform.nsToBindings.keySet() : (elementType == ScaXmlPlatform.ScaXmlElementType.implementations ? platform.nsToImplementations.keySet() : platform.nsToInterfaces.keySet());
            for (ScaXmlNamespace ns : nsList) {
                nsCombo.add(ns.getName());
            }
        }
    }

    private TreeViewer createItemsControl(TabFolder tabFolder, ScaXmlPlatform.ScaXmlElementType elementType) {
        TabItem item = new TabItem(tabFolder, 0);
        String title = elementType.toString();
        title = String.valueOf(title.toUpperCase().charAt(0)) + title.substring(1);
        item.setText(title);
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        item.setControl((Control)comp);
        Composite filterComp = new Composite(comp, 0);
        filterComp.setLayout((Layout)new GridLayout(2, false));
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        filterComp.setLayoutData((Object)layoutData);
        Label filterLabel = new Label(filterComp, 0);
        filterLabel.setText(Messages.ScaXmlPreferencePage_2);
        Combo nsCombo = new Combo(filterComp, 12);
        nsCombo.setLayoutData((Object)new GridData(768));
        this.updateNameSpaceCombo(nsCombo, elementType);
        this.combos.put(elementType, nsCombo);
        Composite treeContainer = new Composite(comp, 0);
        treeContainer.setLayoutData((Object)new GridData(1808));
        TreeViewer viewer = new TreeViewer(treeContainer, 68356);
        viewer.getTree().setLayoutData((Object)new GridData(1808));
        viewer.getTree().setHeaderVisible(true);
        viewer.getTree().setLinesVisible(true);
        TreeColumn nameColumn = new TreeColumn(viewer.getTree(), 16384);
        nameColumn.setText(Messages.ScaXmlPreferencePage_3);
        nameColumn.setWidth(120);
        nameColumn.setResizable(false);
        TreeColumn informationColumn = new TreeColumn(viewer.getTree(), 0x1000000);
        informationColumn.setText(Messages.ScaXmlPreferencePage_4);
        informationColumn.setWidth(120);
        informationColumn.setResizable(false);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        columnLayout.setColumnData((Widget)nameColumn, (ColumnLayoutData)new ColumnWeightData(80, 120));
        columnLayout.setColumnData((Widget)informationColumn, (ColumnLayoutData)new ColumnWeightData(20, 120));
        treeContainer.setLayout((Layout)columnLayout);
        viewer.setContentProvider((IContentProvider)new ScaXmlContentProvider(elementType));
        viewer.setLabelProvider((IBaseLabelProvider)new ScaXmlLabelProvider());
        viewer.setSorter(this.sorter);
        viewer.setInput(this.platforms);
        viewer.expandToLevel(1);
        ScaXmlViewerFilter filter = new ScaXmlViewerFilter(null, elementType);
        viewer.addFilter((ViewerFilter)filter);
        nsCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String selectedNs = nsCombo.getText();
                filter.setNamespaceFilter(selectedNs);
                viewer.collapseAll();
                viewer.refresh();
                if (selectedNs.length() > 0) {
                    viewer.expandToLevel(2);
                } else {
                    viewer.expandToLevel(1);
                }
            }
        });
        this.createButtons(comp, viewer, elementType);
        return viewer;
    }

    private void createButtons(Composite comp, TreeViewer viewer, ScaXmlPlatform.ScaXmlElementType elementType) {
        Composite buttons = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        Button addElementButton = new Button(buttons, 8);
        addElementButton.setText(Messages.ScaXmlPreferencePage_5);
        addElementButton.setLayoutData((Object)new GridData(768));
        addElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlItem item = ScaXmlPreferencePage.this.getSelectedItem(viewer);
                if (item != null && item instanceof ScaXmlPlatform) {
                    RootElementEditionDialog dialog = new RootElementEditionDialog(comp.getShell(), elementType, (ScaXmlPlatform)item);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        viewer.refresh((Object)item, true);
                        ScaXmlElement newElement = dialog.getNewElement();
                        viewer.setSelection((ISelection)new StructuredSelection((Object)newElement), true);
                        viewer.getTree().setFocus();
                        for (Map.Entry entry : ScaXmlPreferencePage.this.combos.entrySet()) {
                            ScaXmlPreferencePage.this.updateNameSpaceCombo((Combo)entry.getValue(), (ScaXmlPlatform.ScaXmlElementType)((Object)entry.getKey()));
                        }
                    }
                } else if (item != null && item instanceof ScaXmlElement) {
                    ElementEditionDialog dialog = new ElementEditionDialog(comp.getShell(), elementType, (ScaXmlElement)item);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        viewer.refresh((Object)item, true);
                        ScaXmlElement newElement = dialog.getNewElement();
                        viewer.setSelection((ISelection)new StructuredSelection((Object)newElement), true);
                        viewer.getTree().setFocus();
                    }
                }
            }
        });
        Button addAttributeButton = new Button(buttons, 8);
        addAttributeButton.setText(Messages.ScaXmlPreferencePage_6);
        addAttributeButton.setLayoutData((Object)new GridData(768));
        addAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlItem item = ScaXmlPreferencePage.this.getSelectedItem(viewer);
                if (item != null) {
                    ScaXmlElement elt;
                    if (item instanceof ScaXmlElement) {
                        elt = (ScaXmlElement)item;
                    } else if (item instanceof ScaXmlAttribute) {
                        elt = ((ScaXmlAttribute)item).getElement();
                    } else {
                        return;
                    }
                    AttributeEditionDialog dialog = new AttributeEditionDialog(comp.getShell(), elt);
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        viewer.refresh((Object)elt, true);
                        ScaXmlAttribute newAttribute = dialog.getNewAttribute();
                        viewer.setSelection((ISelection)new StructuredSelection((Object)newAttribute), true);
                        viewer.getTree().setFocus();
                    }
                }
            }
        });
        Button editButton = new Button(buttons, 8);
        editButton.setText(Messages.ScaXmlPreferencePage_7);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlPreferencePage.this.editScaXmlItem(viewer, elementType);
            }
        });
        Button removeButton = new Button(buttons, 8);
        removeButton.setText(Messages.ScaXmlPreferencePage_8);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlItem item = ScaXmlPreferencePage.this.getSelectedItem(viewer);
                if (item != null) {
                    ScaXmlItem selection = null;
                    if (item instanceof ScaXmlElement) {
                        ScaXmlElement elt = (ScaXmlElement)item;
                        if (elt.getParent() != null) {
                            elt.getParent().children.remove(item);
                            selection = elt.getParent();
                        } else if (elt.getPlatform() != null) {
                            elt.getPlatform().remove(item);
                            selection = elt.getPlatform();
                            for (Map.Entry entry : ScaXmlPreferencePage.this.combos.entrySet()) {
                                ScaXmlPreferencePage.this.updateNameSpaceCombo((Combo)entry.getValue(), (ScaXmlPlatform.ScaXmlElementType)((Object)entry.getKey()));
                            }
                        }
                    } else if (item instanceof ScaXmlAttribute) {
                        ScaXmlElement elt = ((ScaXmlAttribute)item).getElement();
                        elt.attributes.remove(item);
                        selection = elt;
                    }
                    if (selection != null) {
                        viewer.refresh(selection, true);
                        viewer.setSelection((ISelection)new StructuredSelection((Object)selection), true);
                        viewer.getTree().setFocus();
                    }
                }
            }
        });
        addElementButton.setEnabled(false);
        addAttributeButton.setEnabled(false);
        editButton.setEnabled(false);
        removeButton.setEnabled(false);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection().isEmpty()) {
                    addElementButton.setEnabled(false);
                    addAttributeButton.setEnabled(false);
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                    return;
                }
                Object o = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (o instanceof ScaXmlPlatform) {
                    addElementButton.setEnabled(true);
                    addAttributeButton.setEnabled(false);
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                    return;
                }
                if (o instanceof ScaXmlElement) {
                    addElementButton.setEnabled(true);
                    addAttributeButton.setEnabled(true);
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                    return;
                }
                if (o instanceof ScaXmlAttribute) {
                    addElementButton.setEnabled(false);
                    addAttributeButton.setEnabled(true);
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                    return;
                }
            }
        });
        viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                ScaXmlPreferencePage.this.editScaXmlItem(viewer, elementType);
            }
        });
    }

    private void editScaXmlItem(TreeViewer viewer, ScaXmlPlatform.ScaXmlElementType elementType) {
        ScaXmlItem item = this.getSelectedItem(viewer);
        if (item != null && item instanceof ScaXmlElement) {
            ScaXmlElement elt = (ScaXmlElement)item;
            if (elt.getParent() != null) {
                ElementEditionDialog dialog = new ElementEditionDialog(viewer.getTree().getShell(), elementType, elt.getParent());
                dialog.setNewElement(elt);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    viewer.refresh((Object)item, true);
                    ScaXmlElement newElement = dialog.getNewElement();
                    viewer.setSelection((ISelection)new StructuredSelection((Object)newElement), true);
                    viewer.getTree().setFocus();
                }
            } else {
                RootElementEditionDialog dialog = new RootElementEditionDialog(viewer.getTree().getShell(), elementType, elt.getPlatform());
                dialog.setNewElement(elt);
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    viewer.refresh((Object)item, true);
                    ScaXmlElement newElement = dialog.getNewElement();
                    viewer.setSelection((ISelection)new StructuredSelection((Object)newElement), true);
                    viewer.getTree().setFocus();
                    for (Map.Entry<ScaXmlPlatform.ScaXmlElementType, Combo> entry : this.combos.entrySet()) {
                        this.updateNameSpaceCombo(entry.getValue(), entry.getKey());
                    }
                }
            }
        } else if (item != null && item instanceof ScaXmlAttribute) {
            AttributeEditionDialog dialog = new AttributeEditionDialog(viewer.getTree().getShell(), ((ScaXmlAttribute)item).getElement());
            dialog.setNewAttribute((ScaXmlAttribute)item);
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                viewer.refresh((Object)item, true);
                ScaXmlAttribute newAttribute = dialog.getNewAttribute();
                viewer.setSelection((ISelection)new StructuredSelection((Object)newAttribute), true);
                viewer.getTree().setFocus();
            }
        } else if (item != null && item instanceof ScaXmlPlatform) {
            viewer.expandToLevel((Object)item, 1);
        }
    }

    private void createPlatformsControl(TabFolder tabFolder) {
        TabItem platformsItem = new TabItem(tabFolder, 0);
        platformsItem.setText(Messages.ScaXmlPreferencePage_9);
        Composite comp = new Composite((Composite)tabFolder, 0);
        comp.setLayout((Layout)new GridLayout(2, false));
        platformsItem.setControl((Control)comp);
        Composite treeContainer = new Composite(comp, 0);
        treeContainer.setLayoutData((Object)new GridData(1808));
        this.nsViewer = new TreeViewer(treeContainer, 68356);
        this.nsViewer.getTree().setLayoutData((Object)new GridData(1808));
        this.nsViewer.getTree().setHeaderVisible(true);
        this.nsViewer.getTree().setLinesVisible(true);
        TreeColumn column = new TreeColumn(this.nsViewer.getTree(), 16384);
        column.setText(Messages.ScaXmlPreferencePage_10);
        column.setWidth(120);
        column.setResizable(false);
        TreeColumnLayout columnLayout = new TreeColumnLayout();
        columnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(100, 120));
        treeContainer.setLayout((Layout)columnLayout);
        this.nsViewer.setContentProvider((IContentProvider)new PlatformAndNsContentProvider());
        this.nsViewer.setLabelProvider((IBaseLabelProvider)new ScaXmlLabelProvider());
        this.nsViewer.setSorter(this.sorter);
        this.nsViewer.setInput(this.platforms);
        this.nsViewer.expandAll();
        Composite buttons = new Composite(comp, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        buttons.setLayout((Layout)layout);
        buttons.setLayoutData((Object)new GridData(2));
        Button newPlatformButton = new Button(buttons, 8);
        newPlatformButton.setText(Messages.ScaXmlPreferencePage_11);
        newPlatformButton.setLayoutData((Object)new GridData(768));
        newPlatformButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlPreferencePage.this.editOrCreatePlatform(null, false);
            }
        });
        Button addNamespaceButton = new Button(buttons, 8);
        addNamespaceButton.setText(Messages.ScaXmlPreferencePage_12);
        addNamespaceButton.setLayoutData((Object)new GridData(768));
        addNamespaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlItem item = ScaXmlPreferencePage.this.getSelectedItem(ScaXmlPreferencePage.this.nsViewer);
                if (item == null) {
                    return;
                }
                ScaXmlPlatform platform = null;
                if (item instanceof ScaXmlPlatform) {
                    platform = (ScaXmlPlatform)item;
                } else if (item instanceof ScaXmlNamespace) {
                    platform = ((ScaXmlNamespace)item).getPlatform();
                }
                if (platform != null) {
                    ScaXmlPreferencePage.this.editOrCreateNamespace(null, platform, false);
                }
            }
        });
        Button editButton = new Button(buttons, 8);
        editButton.setText(Messages.ScaXmlPreferencePage_13);
        editButton.setLayoutData((Object)new GridData(768));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlPreferencePage.this.editOrCreateNsOrPlatform();
            }
        });
        Button removeButton = new Button(buttons, 8);
        removeButton.setText(Messages.ScaXmlPreferencePage_14);
        removeButton.setLayoutData((Object)new GridData(768));
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScaXmlItem item = ScaXmlPreferencePage.this.getSelectedItem(ScaXmlPreferencePage.this.nsViewer);
                if (item instanceof ScaXmlPlatform) {
                    int index = ScaXmlPreferencePage.this.platforms.indexOf(item);
                    ScaXmlPreferencePage.this.platforms.remove(item);
                    ScaXmlPreferencePage.this.refreshViewers();
                    if (index > 0) {
                        ScaXmlPreferencePage.this.nsViewer.setSelection((ISelection)new StructuredSelection(ScaXmlPreferencePage.this.platforms.get(index - 1)), true);
                    }
                    ScaXmlPreferencePage.this.nsViewer.getTree().setFocus();
                } else if (item instanceof ScaXmlNamespace) {
                    ScaXmlNamespace ns = (ScaXmlNamespace)item;
                    ScaXmlPlatform platform = ns.getPlatform();
                    platform.namespaces.remove(ns);
                    platform.nsToBindings.remove(ns);
                    platform.nsToImplementations.remove(ns);
                    platform.nsToInterfaces.remove(ns);
                    ScaXmlPreferencePage.this.nsViewer.refresh((Object)platform, true);
                    ScaXmlPreferencePage.this.nsViewer.setSelection((ISelection)new StructuredSelection((Object)platform), true);
                    ScaXmlPreferencePage.this.nsViewer.getTree().setFocus();
                }
            }
        });
        addNamespaceButton.setEnabled(false);
        newPlatformButton.setEnabled(true);
        editButton.setEnabled(false);
        removeButton.setEnabled(false);
        this.nsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (e.getSelection().isEmpty()) {
                    addNamespaceButton.setEnabled(false);
                    newPlatformButton.setEnabled(true);
                    editButton.setEnabled(false);
                    removeButton.setEnabled(false);
                    return;
                }
                Object o = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (o instanceof ScaXmlPlatform || o instanceof ScaXmlNamespace) {
                    addNamespaceButton.setEnabled(true);
                    newPlatformButton.setEnabled(true);
                    editButton.setEnabled(true);
                    removeButton.setEnabled(true);
                    return;
                }
            }
        });
        this.nsViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent arg0) {
                ScaXmlPreferencePage.this.editOrCreateNsOrPlatform();
            }
        });
    }

    private void editOrCreateNsOrPlatform() {
        ScaXmlItem item = this.getSelectedItem(this.nsViewer);
        if (item == null && this.nsViewer.getSelection().isEmpty()) {
            return;
        }
        if (item instanceof ScaXmlPlatform) {
            this.editOrCreatePlatform((ScaXmlPlatform)item, true);
        } else if (item instanceof ScaXmlNamespace) {
            this.editOrCreateNamespace((ScaXmlNamespace)item, ((ScaXmlNamespace)item).getPlatform(), true);
        }
    }

    private void editOrCreateNamespace(ScaXmlNamespace ns, ScaXmlPlatform selectedPlatform, boolean editMode) {
        String value = ns == null ? Messages.ScaXmlPreferencePage_1 : ns.getName();
        String title = editMode ? Messages.ScaXmlPreferencePage_16 : Messages.ScaXmlPreferencePage_17;
        String msg = editMode ? NLS.bind((String)Messages.ScaXmlPreferencePage_18, (Object)selectedPlatform.getName()) : NLS.bind((String)Messages.ScaXmlPreferencePage_20, (Object)selectedPlatform.getName());
        IInputValidator validator = new IInputValidator(){

            public String isValid(String text) {
                if (text.length() == 0) {
                    return Messages.ScaXmlPreferencePage_22;
                }
                if (selectedPlatform.namespaces.contains(new ScaXmlNamespace(text, null))) {
                    return NLS.bind((String)Messages.ScaXmlPreferencePage_23, (Object)selectedPlatform.getName());
                }
                return null;
            }
        };
        InputDialog dlg = new InputDialog(this.getShell(), title, msg, value, validator);
        if (dlg.open() != 0) {
            return;
        }
        if (ns == null) {
            ns = new ScaXmlNamespace(dlg.getValue(), selectedPlatform);
        } else if (!dlg.getValue().equals(ns.getName())) {
            selectedPlatform.namespaces.remove(ns);
            ns.setName(dlg.getValue());
        }
        selectedPlatform.namespaces.add(ns);
        this.nsViewer.refresh((Object)selectedPlatform, true);
        this.nsViewer.setSelection((ISelection)new StructuredSelection((Object)ns), true);
        this.nsViewer.getTree().setFocus();
        for (Map.Entry<ScaXmlPlatform.ScaXmlElementType, Combo> entry : this.combos.entrySet()) {
            this.updateNameSpaceCombo(entry.getValue(), entry.getKey());
        }
    }

    private void editOrCreatePlatform(ScaXmlPlatform platform, boolean editMode) {
        String initialValue = platform == null ? Messages.ScaXmlPreferencePage_25 : platform.getName();
        String title = editMode ? Messages.ScaXmlPreferencePage_26 : Messages.ScaXmlPreferencePage_27;
        String msg = editMode ? NLS.bind((String)Messages.ScaXmlPreferencePage_28, (Object)initialValue) : Messages.ScaXmlPreferencePage_30;
        ScaXmlPlatform platformForValidator = platform;
        IInputValidator validator = new IInputValidator(){

            public String isValid(String text) {
                if (text.length() == 0) {
                    return Messages.ScaXmlPreferencePage_31;
                }
                for (ScaXmlPlatform p : ScaXmlPreferencePage.this.platforms) {
                    if (!p.getName().equals(text) || p == platformForValidator) continue;
                    return NLS.bind((String)Messages.ScaXmlPreferencePage_32, (Object)text);
                }
                return null;
            }
        };
        InputDialog dlg = new InputDialog(this.getShell(), title, msg, initialValue, validator);
        if (dlg.open() != 0) {
            return;
        }
        if (platform == null) {
            platform = new ScaXmlPlatform();
            this.platforms.add(platform);
        }
        if (!dlg.getValue().equals(platform.getName())) {
            platform.setName(dlg.getValue());
            this.refreshViewers();
        }
        this.nsViewer.setSelection((ISelection)new StructuredSelection((Object)platform), true);
        this.nsViewer.getTree().setFocus();
    }
}

