/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stp.bpmn.policies;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.FigureListener;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.Request;
import org.eclipse.gef.Tool;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.tools.SelectionTool;
import org.eclipse.gmf.runtime.common.ui.services.icon.IconService;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.ISurfaceEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.l10n.DiagramUIPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.tools.AbstractPopupBarTool;
import org.eclipse.gmf.runtime.diagram.ui.tools.PopupBarTool;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class PopupBarEditPolicyEx
extends DiagramAssistantEditPolicy {
    private final GraphicalEditPart _thisPart;
    private static Image IMAGE_POPUPBAR_PLUS = DiagramUIPluginImages.get((String)"icons/popupbar_plus.gif");
    private static Image IMAGE_POPUPBAR = DiagramUIPluginImages.get((String)"icons/popupbar.gif");
    private Point _lastRePointForBalloonPosition;
    private static int BALLOON_Y_OFFSET = 10;
    private static double BALLOON_X_OFFSET_RHS = 0.65;
    private static double BALLOON_X_OFFSET_LHS = 0.25;
    private static int ACTION_HGT = 35;
    private static int ACTION_WIDTH = 30;
    private static int ACTION_BUTTON_START_X = 5;
    private static int ACTION_BUTTON_START_Y = 5;
    private static int ACTION_MARGIN_RIGHT = 10;
    private static int POPUPBAR_ACTIVATEONHOVER = 1;
    private static int POPUPBAR_MOVE_FIGURE = 2;
    private static int POPUPBAR_DISPLAYATMOUSEHOVERLOCATION = 4;
    private static int POPUPBAR_ONDIAGRAMACTIVATED = 16;
    private static int POPUPBAR_HOST_IS_CONNECTION = 32;
    private int myPopupBarFlags = POPUPBAR_ACTIVATEONHOVER;
    private double myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    private IFigure myBalloon = null;
    private List myPopupBarDescriptors = new ArrayList();
    protected List imagesToBeDisposed = new ArrayList();
    private PopupBarMouseListener myMouseKeyListener = new PopupBarMouseListener();
    private OwnerMovedListener myOwnerMovedListener = new OwnerMovedListener();

    public PopupBarEditPolicyEx() {
        this._thisPart = null;
    }

    public PopupBarEditPolicyEx(GraphicalEditPart thisPart) {
        this._thisPart = thisPart;
    }

    protected boolean isDiagramAssistant(Object object) {
        return object instanceof RoundedRectangleWithTail || object instanceof PopupBarLabelHandle;
    }

    public void mouseHover(MouseEvent me) {
        if (!this.isDiagramAssistant(me.getSource())) {
            this.setAvoidHidingDiagramAssistant(false);
        }
        this.setMouseLocation(me.getLocation());
        if (this.getIsDisplayAtMouseHoverLocation()) {
            this.showDiagramAssistantAfterDelay(this.getAppearanceDelayLocationSpecific());
        } else if (this.shouldShowDiagramAssistant()) {
            this.showDiagramAssistant(this.getMouseLocation());
        }
    }

    public void mouseMoved(MouseEvent me) {
        Object srcObj;
        if (this.getIsDisplayAtMouseHoverLocation() && (srcObj = me.getSource()) != null && srcObj.equals(this.getHostFigure())) {
            this.hideDiagramAssistant();
        }
        this.setAvoidHidingDiagramAssistant(true);
        this.setMouseLocation(me.getLocation());
        if (!this.getIsDisplayAtMouseHoverLocation()) {
            if (!this.isDiagramAssistant(me.getSource())) {
                this.setAvoidHidingDiagramAssistant(false);
            }
            this.showDiagramAssistantAfterDelay(this.getAppearanceDelay());
        }
    }

    private void setFlag(int bit, boolean b) {
        if (b) {
            this.myPopupBarFlags |= bit;
        } else if (this.getFlag(bit)) {
            this.myPopupBarFlags ^= bit;
        }
    }

    private boolean getFlag(int bit) {
        return (this.myPopupBarFlags & bit) > 0;
    }

    private void setPopupBarOnDiagramActivated(boolean bVal) {
        this.setFlag(POPUPBAR_ONDIAGRAMACTIVATED, bVal);
    }

    private boolean getPopupBarOnDiagramActivated() {
        return this.getFlag(POPUPBAR_ONDIAGRAMACTIVATED);
    }

    protected void setHostConnection(boolean bVal) {
        this.setFlag(POPUPBAR_HOST_IS_CONNECTION, bVal);
    }

    protected boolean isHostConnection() {
        return this.getFlag(POPUPBAR_HOST_IS_CONNECTION);
    }

    protected void populatePopupBars() {
        this.fillPopupBarDescriptors();
        List types = ModelingAssistantService.getInstance().getTypesForPopupBar((IAdaptable)this.getHost());
        for (Object type : types) {
            if (!(type instanceof IElementType)) continue;
            this.addPopupBarDescriptor((IElementType)type, IconService.getInstance().getIcon((IAdaptable)((IElementType)type)));
        }
    }

    protected void fillPopupBarDescriptors() {
    }

    private boolean isSelectionToolActive() {
        Tool theTool;
        return this.getHost().getParent() != null && this.getHost().isActive() && (theTool = this.getHost().getViewer().getEditDomain().getActiveTool()) != null && theTool instanceof SelectionTool;
    }

    protected boolean shouldShowDiagramAssistant() {
        if (!super.shouldShowDiagramAssistant()) {
            return false;
        }
        if (this.getIsDisplayAtMouseHoverLocation()) {
            if (this.isHostConnection()) {
                return this.isSelectionToolActive();
            }
            if (this.getPopupBarOnDiagramActivated()) {
                return this.isSelectionToolActive();
            }
            return false;
        }
        return this.isSelectionToolActive();
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage, DragTracker theTracker, String theTip) {
        PopupBarDescriptor desc = new PopupBarDescriptor(theTip, theImage, elementType, theTracker);
        this.myPopupBarDescriptors.add(desc);
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage, DragTracker theTracker) {
        String theInputStr = DiagramUIMessages.PopupBar_AddNew;
        String theTip = NLS.bind((String)theInputStr, (Object)elementType.getDisplayName());
        this.addPopupBarDescriptor(elementType, theImage, theTracker, theTip);
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage) {
        this.addPopupBarDescriptor(elementType, theImage, (DragTracker)new PopupBarToolEx(this, this.getHost(), elementType));
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage, String theTip) {
        PopupBarToolEx theTracker = new PopupBarToolEx(this, this.getHost(), elementType);
        PopupBarDescriptor desc = new PopupBarDescriptor(theTip, theImage, elementType, (DragTracker)theTracker);
        this.myPopupBarDescriptors.add(desc);
    }

    protected void addPopupBarDescriptor(IElementType elementType, Image theImage, CreateRequest theRequest) {
        PopupBarTool theTracker = new PopupBarTool(this.getHost(), theRequest);
        this.addPopupBarDescriptor(elementType, theImage, (DragTracker)theTracker);
    }

    protected List getPopupBarDescriptors() {
        return this.myPopupBarDescriptors;
    }

    private void initPopupBars() {
        List theList = this.getPopupBarDescriptors();
        if (theList.isEmpty()) {
            return;
        }
        this.myBalloon = this.createPopupBarFigure();
        if (theList.size() > 4) {
            int half = theList.size() / 2 + theList.size() % 2;
            int iTotal = ACTION_WIDTH * half + ACTION_MARGIN_RIGHT;
            this.getBalloon().setSize(iTotal, ACTION_HGT * 2 + 2 * ACTION_BUTTON_START_Y);
        } else {
            int iTotal = ACTION_WIDTH * theList.size() + ACTION_MARGIN_RIGHT;
            this.getBalloon().setSize(iTotal, ACTION_HGT + 2 * ACTION_BUTTON_START_Y);
        }
        int xLoc = ACTION_BUTTON_START_X;
        int yLoc = ACTION_BUTTON_START_Y;
        int halphIdx = theList.size() > 4 ? theList.size() / 2 + theList.size() % 2 - 1 : -1;
        int idx = 0;
        while (idx < theList.size()) {
            PopupBarDescriptor theDesc = (PopupBarDescriptor)theList.get(idx);
            PopupBarLabelHandle b = new PopupBarLabelHandle(theDesc.getDragTracker(), theDesc.getIcon());
            Rectangle r1 = new Rectangle();
            r1.setLocation(xLoc, yLoc);
            xLoc += ACTION_WIDTH;
            r1.setSize(ACTION_WIDTH, ACTION_HGT - ACTION_MARGIN_RIGHT);
            Label l = new Label();
            l.setText(theDesc.getToolTip());
            b.setToolTip((IFigure)l);
            b.setPreferredSize(ACTION_WIDTH, ACTION_HGT);
            b.setBounds(r1);
            this.getBalloon().add((IFigure)b);
            b.addMouseMotionListener((MouseMotionListener)this);
            b.addMouseListener((MouseListener)this.myMouseKeyListener);
            if (idx == halphIdx) {
                yLoc = ACTION_BUTTON_START_Y + ACTION_HGT;
                xLoc = ACTION_BUTTON_START_X;
            }
            ++idx;
        }
    }

    String getPreferenceName() {
        return "Global.showPopupBars";
    }

    protected boolean isDiagramAssistantShowing() {
        return this.getBalloon() != null;
    }

    private IFigure getBalloon() {
        return this.myBalloon;
    }

    protected IFigure createPopupBarFigure() {
        return new RoundedRectangleWithTail();
    }

    protected void showDiagramAssistant(Point referencePoint) {
        if (this.getBalloon() != null && this.getBalloon().getParent() != null) {
            return;
        }
        if (this.myPopupBarDescriptors.isEmpty()) {
            this.populatePopupBars();
            this.initPopupBars();
            if (this.myPopupBarDescriptors.isEmpty()) {
                return;
            }
        }
        this.getBalloon().addMouseMotionListener((MouseMotionListener)this);
        this.getBalloon().addMouseListener((MouseListener)this.myMouseKeyListener);
        IFigure layer = this.getLayer("Handle Layer");
        layer.add(this.getBalloon());
        if (referencePoint == null) {
            referencePoint = this.getHostFigure().getBounds().getCenter();
        }
        if (this._thisPart != null) {
            Point center = this._thisPart.getFigure().getBounds().getCenter();
            referencePoint.y = center.y;
        }
        Point thePoint = this.getBalloonPosition(referencePoint);
        this.getBalloon().setLocation(thePoint);
        if (!this.shouldAvoidHidingDiagramAssistant()) {
            this.hideDiagramAssistantAfterDelay(this.getDisappearanceDelay());
        }
    }

    protected boolean getIsDisplayAtMouseHoverLocation() {
        return this.getFlag(POPUPBAR_DISPLAYATMOUSEHOVERLOCATION);
    }

    protected void setIsDisplayAtMouseHoverLocation(boolean bVal) {
        this.setFlag(POPUPBAR_DISPLAYATMOUSEHOVERLOCATION, bVal);
    }

    private Point getBalloonPosition(Point referencePoint) {
        this._lastRePointForBalloonPosition = referencePoint.getCopy();
        ((GraphicalEditPart)this.getHost()).getFigure().translateToAbsolute((Translatable)this._lastRePointForBalloonPosition);
        Point thePoint = new Point();
        boolean atMouse = this.getIsDisplayAtMouseHoverLocation();
        int descriptorsCount = this.getPopupBarDescriptors().size();
        if (atMouse) {
            Control ctrl1;
            thePoint.setLocation(referencePoint);
            this.getHostFigure().translateToAbsolute((Translatable)thePoint);
            this.getBalloon().translateToRelative((Translatable)thePoint);
            thePoint.y -= ACTION_HGT;
            if (descriptorsCount > 4) {
                thePoint.y -= ACTION_HGT;
            }
            if (this.willBalloonBeClipped(thePoint) && (ctrl1 = this.getHost().getViewer().getControl()) instanceof FigureCanvas) {
                FigureCanvas figureCanvas = (FigureCanvas)ctrl1;
                Viewport vp = figureCanvas.getViewport();
                Rectangle vpRect = vp.getClientArea();
                Dimension dim = this.getBalloon().getSize();
                Rectangle rcBounds = this.getHostFigure().getBounds().getCopy();
                this.getHostFigure().translateToAbsolute((Translatable)rcBounds);
                this.getBalloon().translateToRelative((Translatable)rcBounds);
                if (thePoint.y < vpRect.y) {
                    thePoint.y = vpRect.y;
                }
                if (thePoint.x + dim.width >= vpRect.x + vpRect.width) {
                    thePoint.x = Math.max(vpRect.right() - dim.width, Math.max(vpRect.x, rcBounds.x));
                }
            }
        } else {
            Dimension theoffset = new Dimension();
            Rectangle rcBounds = this.getHostFigure().getBounds().getCopy();
            this.getHostFigure().translateToAbsolute((Translatable)rcBounds);
            this.getBalloon().translateToRelative((Translatable)rcBounds);
            theoffset.height = -(BALLOON_Y_OFFSET + ACTION_HGT);
            theoffset.width = (int)((double)rcBounds.width * this.myBallonOffsetPercent);
            if (this._thisPart != null) {
                theoffset.height += rcBounds.height / 2;
                thePoint.y = rcBounds.y + theoffset.height;
                thePoint.x = rcBounds.x + rcBounds.width / 2 + 32;
            } else {
                thePoint.x = rcBounds.x + theoffset.width;
                thePoint.y = rcBounds.y + theoffset.height;
            }
            if (this.isRightDisplay() && this.willBalloonBeClipped(thePoint)) {
                this.setLeftHandDisplay();
                theoffset.width = (int)((double)rcBounds.width * this.myBallonOffsetPercent);
                thePoint.x = rcBounds.x + theoffset.width;
            }
        }
        Point refPointCopy = referencePoint.getCopy();
        this.getHostFigure().translateToRelative((Translatable)refPointCopy);
        this.getBalloon().translateToRelative((Translatable)refPointCopy);
        return thePoint;
    }

    private boolean willBalloonBeClipped(Point pnt) {
        Control ctrl1 = this.getHost().getViewer().getControl();
        if (ctrl1 instanceof FigureCanvas) {
            FigureCanvas figureCanvas = (FigureCanvas)ctrl1;
            Viewport vp = figureCanvas.getViewport();
            Rectangle vpRect = vp.getClientArea();
            Dimension dim = this.getBalloon().getSize();
            if (pnt.x + dim.width >= vpRect.x + vpRect.width || pnt.y < vpRect.y) {
                return true;
            }
        }
        return false;
    }

    private void teardownPopupBar() {
        this.getBalloon().removeMouseMotionListener((MouseMotionListener)this);
        this.getBalloon().removeMouseListener((MouseListener)this.myMouseKeyListener);
        IFigure layer = this.getLayer("Handle Layer");
        if (this.myBalloon.getParent() != null) {
            layer.remove(this.myBalloon);
        }
        this.myBalloon = null;
        this.myPopupBarDescriptors.clear();
        this.setRightHandDisplay();
        Iterator iter = this.imagesToBeDisposed.iterator();
        while (iter.hasNext()) {
            ((Image)iter.next()).dispose();
        }
        this.imagesToBeDisposed.clear();
    }

    protected void hideDiagramAssistant() {
        if (this.getBalloon() != null) {
            this.teardownPopupBar();
        }
    }

    protected void showDiagramAssistantAfterDelay(int theDelay) {
        if (!this.isDiagramAssistantShowing()) {
            super.showDiagramAssistantAfterDelay(theDelay);
        }
    }

    public void activate() {
        super.activate();
        this.getHostFigure().addMouseListener((MouseListener)this.myMouseKeyListener);
        this.getHostFigure().addFigureListener((FigureListener)this.myOwnerMovedListener);
        if (this.getHost() instanceof ISurfaceEditPart) {
            this.setIsDisplayAtMouseHoverLocation(true);
        }
    }

    public void deactivate() {
        this.getHostFigure().removeMouseListener((MouseListener)this.myMouseKeyListener);
        this.getHostFigure().removeFigureListener((FigureListener)this.myOwnerMovedListener);
        super.deactivate();
    }

    protected void setRightHandDisplay() {
        this.myBallonOffsetPercent = BALLOON_X_OFFSET_RHS;
    }

    protected void setLeftHandDisplay() {
        this.myBallonOffsetPercent = BALLOON_X_OFFSET_LHS;
    }

    protected boolean isRightDisplay() {
        return BALLOON_X_OFFSET_RHS == this.myBallonOffsetPercent;
    }

    protected int getAppearanceDelayLocationSpecific() {
        return this.getAppearanceDelay();
    }

    private class PopupBarDescriptor {
        private String _tooltip = new String();
        private Image _icon = null;
        private IElementType _elementType;
        private DragTracker _dragTracker = null;

        public PopupBarDescriptor(String s, Image i, IElementType elementType, DragTracker theTracker) {
            this._tooltip = s;
            this._icon = i;
            this._dragTracker = theTracker;
            this._elementType = elementType;
        }

        public final IElementType getElementtype() {
            return this._elementType;
        }

        public final Image getIcon() {
            return this._icon;
        }

        public final DragTracker getDragTracker() {
            return this._dragTracker;
        }

        public final String getToolTip() {
            return this._tooltip;
        }
    }

    private class PopupBarLabelHandle
    extends Label
    implements Handle {
        private boolean myMouseOver;
        private Image myDisabledImage;
        private DragTracker myDragTracker;

        private Image getDisabledImage() {
            if (this.myDisabledImage != null) {
                return this.myDisabledImage;
            }
            Image theImage = this.getIcon();
            if (theImage == null) {
                return null;
            }
            this.myDisabledImage = new Image((Device)Display.getCurrent(), theImage, 1);
            PopupBarEditPolicyEx.this.imagesToBeDisposed.add(this.myDisabledImage);
            return this.myDisabledImage;
        }

        public PopupBarLabelHandle(DragTracker tracker, Image theImage) {
            super(theImage);
            this.myMouseOver = false;
            this.myDisabledImage = null;
            this.myDragTracker = null;
            this.myDragTracker = tracker;
            this.setOpaque(true);
            this.setBackgroundColor(ColorConstants.buttonLightest);
            this.calculateEnabled();
        }

        public Point getAccessibleLocation() {
            return null;
        }

        public DragTracker getDragTracker() {
            return this.myDragTracker;
        }

        protected void paintBorder(Graphics graphics) {
            super.paintBorder(graphics);
            if (this.myMouseOver) {
                Rectangle area = this.getClientArea();
                graphics.setForegroundColor(ColorConstants.black);
                graphics.setBackgroundColor(ColorConstants.white);
                graphics.drawFocus(area.x, area.y, area.width - 1, area.height - 1);
            }
        }

        public void handleMouseEntered(MouseEvent event) {
            this.calculateEnabled();
            super.handleMouseEntered(event);
            this.myMouseOver = true;
            this.repaint();
        }

        public void handleMouseExited(MouseEvent event) {
            super.handleMouseExited(event);
            this.myMouseOver = false;
            this.repaint();
        }

        public void handleMousePressed(MouseEvent event) {
            if (1 == event.button) {
                this.setFlag(POPUPBAR_MOVE_FIGURE, true);
            }
            super.handleMousePressed(event);
        }

        private void calculateEnabled() {
            if (this.myDragTracker != null && this.myDragTracker instanceof AbstractPopupBarTool) {
                AbstractPopupBarTool abarTool = (AbstractPopupBarTool)this.myDragTracker;
                this.setEnabled(abarTool.isCommandEnabled());
            } else {
                this.setEnabled(true);
            }
        }

        protected void paintFigure(Graphics graphics) {
            Image theImage;
            if (!this.isEnabled() && (theImage = this.getDisabledImage()) != null) {
                graphics.translate(this.bounds.x, this.bounds.y);
                graphics.drawImage(theImage, this.getIconLocation());
                graphics.translate(-this.bounds.x, -this.bounds.y);
                return;
            }
            super.paintFigure(graphics);
        }
    }

    private class RoundedRectangleWithTail
    extends RoundedRectangle {
        private Image myTailImage = null;
        private boolean bIsInit = false;
        private int myCornerDimension = 6;

        public RoundedRectangleWithTail() {
            this.setFill(true);
            this.setBackgroundColor(ColorConstants.buttonLightest);
            this.setForegroundColor(ColorConstants.lightGray);
            this.setVisible(true);
            this.setEnabled(true);
            this.setOpaque(true);
        }

        public void paintFigure(Graphics graphics) {
            int shiftWidth = 3;
            Image theTail = this.getTail();
            Rectangle theBounds = this.getBounds().getCopy();
            theBounds.height -= theTail.getBounds().height;
            theBounds.height -= shiftWidth;
            theBounds.x += shiftWidth;
            theBounds.width -= shiftWidth + 1;
            graphics.fillRoundRectangle(theBounds, this.myCornerDimension, this.myCornerDimension);
            graphics.drawRoundRectangle(theBounds, this.myCornerDimension, this.myCornerDimension);
            graphics.drawImage(theTail, theBounds.x + 6, theBounds.y + theBounds.height - 1);
        }

        private Image getTail() {
            if (!this.bIsInit) {
                if (PopupBarEditPolicyEx.this.getIsDisplayAtMouseHoverLocation() && !PopupBarEditPolicyEx.this.isHostConnection()) {
                    if (this.myTailImage == null) {
                        this.myTailImage = IMAGE_POPUPBAR_PLUS;
                        this.bIsInit = true;
                    }
                } else if (this.myTailImage == null) {
                    this.myTailImage = IMAGE_POPUPBAR;
                    this.bIsInit = true;
                }
            }
            return this.myTailImage;
        }
    }

    private class OwnerMovedListener
    implements FigureListener {
        private Point myPopupBarLastPosition = new Point(0, 0);

        OwnerMovedListener() {
        }

        boolean hasPositionChanged(Rectangle theBounds) {
            if (theBounds.x != this.myPopupBarLastPosition.x) {
                return true;
            }
            return theBounds.y != this.myPopupBarLastPosition.y;
        }

        public void figureMoved(IFigure source) {
            if (PopupBarEditPolicyEx.this.getFlag(POPUPBAR_MOVE_FIGURE) && this.hasPositionChanged(source.getBounds())) {
                PopupBarEditPolicyEx.this.hideDiagramAssistant();
            } else {
                PopupBarEditPolicyEx.this.setFlag(POPUPBAR_MOVE_FIGURE, false);
                Rectangle theBounds = source.getBounds();
                this.myPopupBarLastPosition.setLocation(theBounds.x, theBounds.y);
            }
        }
    }

    private class PopupBarMouseListener
    extends MouseListener.Stub {
        PopupBarMouseListener() {
        }

        public void mousePressed(MouseEvent me) {
            if (3 == me.button) {
                PopupBarEditPolicyEx.this.hideDiagramAssistant();
            }
            super.mousePressed(me);
            PopupBarEditPolicyEx.this.setPopupBarOnDiagramActivated(true);
        }

        public void mouseReleased(MouseEvent me) {
            super.mouseReleased(me);
        }
    }

    static final class PopupBarToolEx
    extends PopupBarTool {
        private final PopupBarEditPolicyEx _editPolicy;

        public PopupBarToolEx(PopupBarEditPolicyEx editPolicy, EditPart epHost, IElementType elementType) {
            super(epHost, elementType);
            this._editPolicy = editPolicy;
        }

        public PopupBarToolEx(PopupBarEditPolicyEx editPolicy, EditPart epHost, CreateRequest theRequest) {
            super(epHost, theRequest);
            this._editPolicy = editPolicy;
        }

        protected Command getCommand() {
            Request theRequest = this.getTargetRequest();
            if (!(theRequest instanceof CreateRequest) || this._editPolicy._lastRePointForBalloonPosition == null) {
                return super.getCommand();
            }
            ((CreateRequest)theRequest).setLocation(this._editPolicy._lastRePointForBalloonPosition);
            Command theCmd = this.getHost().getCommand(theRequest);
            if (theCmd != null && theCmd.canExecute()) {
                return theCmd;
            }
            return super.getCommand();
        }
    }
}

