/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************
 * Dates       		 Author              Changes
 * Dec 18, 2006      Antoine Toulm   Creation
 */
package org.eclipse.stp.bpmn.diagram.actions.activitytypes;

import java.net.URL;
import java.util.Iterator;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.ui.action.AbstractActionHandler;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.ActivityType;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.provider.ActivityItemProvider;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

/**
 * Abstract action to change the activity type of the selected
 * object into the one specified by the action.
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class ChangeActivityTypeAction extends AbstractActionHandler {

	/**
	 * The abstract constant which is completed by the name of the type
	 */
	public static final String ABSTRACT_ID = "setActivityTypeTo" ;
	/**
	 * the type that this action represents.
	 */
	private ActivityType _type;
	/**
	 * Default constructor
	 * @param workbenchPart
	 */
	public ChangeActivityTypeAction(IWorkbenchPart workbenchPart) {
		super(workbenchPart);
	}
	/**
	 * Default constructor
	 * @param workbenchPage
	 */
	public ChangeActivityTypeAction(IWorkbenchPage workbenchPage,String name) {
		super(workbenchPage);
		_type = ActivityType.get(name.substring(ABSTRACT_ID.length()));
	}
	
	/**
	 * Initializes the action.
	 */
	@Override
	public void init() {
		super.init();
		setId(ABSTRACT_ID + getActivityType().getName());
		setText(getActivityType().getName());
		try {
		setImageDescriptor(ImageDescriptor.createFromURL(
				(URL) new ActivityItemProvider(null).
				getImage(getActivityType())));
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	/**
	 * Runs the action through a command.
	 */
	@Override
	protected void doRun(IProgressMonitor progressMonitor) {
		IStructuredSelection selection = getStructuredSelection();
		if (selection == null || (selection.isEmpty())) {
			return;
		}
		if (selection.getFirstElement() instanceof IGraphicalEditPart) {
			IGraphicalEditPart part = (IGraphicalEditPart) selection.
				getFirstElement();
			final EObject object = ((IGraphicalEditPart) selection.
					getFirstElement()).resolveSemanticElement();
			if (object instanceof Activity) {
//				testFigure(part);
				
				part.getDiagramEditDomain().getDiagramCommandStack().
					execute(new ICommandProxy(new MyCommand(object) {

						@Override
						protected CommandResult doExecuteWithResult(
								IProgressMonitor monitor, IAdaptable info)
								throws ExecutionException {
							Activity act = (Activity) object;
							if (getActivityType().getValue() != 
								ActivityType.TASK && 
								(getActivityType().getValue() != 
									ActivityType.SUB_PROCESS)) {
								act.setLooping(false);
							}
							act.setActivityType(getActivityType());
							return CommandResult.newOKCommandResult();
						}}), progressMonitor);
				
			}
		}
	}

	/**
	 * Refreshing the action, setting it enabled if the selection is an Activity
	 * and the activity type is different of its activity type.
	 */
	public void refresh() {
		boolean forbidEnablement = false;
		if (getSelection() == null|| getSelection().isEmpty()) {
			forbidEnablement = true;
		}
		if (!(getSelection() instanceof IStructuredSelection)) {
			forbidEnablement = true;
		}
		if (forbidEnablement) {
			setEnabled(false);
			return;
		}
		Object selected = ((IStructuredSelection) getSelection()).
			getFirstElement();
		if (selected instanceof IGraphicalEditPart) {
			selected = ((IGraphicalEditPart) selected).
				getNotationView().getElement();
		}
		if (!(selected instanceof Activity)) {
			forbidEnablement = true;
		}
		if (selected instanceof SubProcess) {// changing an activity into a 
			// subprocess is too complicated for now.
			forbidEnablement = true;
		}
		if (forbidEnablement) {
			setEnabled(false);
			return;
		}
		if (((Activity) selected).getActivityType().getValue() 
				== getActivityType().getValue()) {
			forbidEnablement = true;
		}
		
		
		setEnabled(!forbidEnablement);
	} 

	public ActivityType getActivityType() {
		return _type;
	}
	
	
	/**
	 * Utility class used to simplify the use of AbstracTransactionalCommand.
	 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
	 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
	 */
	private abstract class MyCommand extends AbstractTransactionalCommand {
		public MyCommand(EObject elt) {
			super((TransactionalEditingDomain) AdapterFactoryEditingDomain.
					getEditingDomainFor(elt),
					"Setting the activity type of an activity",
					getWorkspaceFiles(elt));
		}
	}
	
	/**
	 * For debugging purposes, used to check on the integrity of the figures.
	 * @param part
	 */
	private void testFigure(IGraphicalEditPart part) {
		System.err.println("----------------- BEGINNING TEST -----------------"); // REMOVE
		System.err.println(part.resolveSemanticElement() instanceof Activity ? 
				(((Activity) part.resolveSemanticElement()).getName()) : ""); // REMOVE
		IFigure figure = part.getFigure();
		System.err.println(figure); // REMOVE
		for (Object fig : figure.getChildren()) {
			System.err.println("\t"+fig); // REMOVE
			for (Object f : ((IFigure) fig).getChildren()) {
				System.err.println("\t\t" + f); // REMOVE
				for (Object f2 : ((IFigure) f).getChildren()) {
					System.err.println("\t\t\t" + f2 + " " + 
							((IFigure) f2).getChildren()); // REMOVE
				}
			}
		}
//		Iterator iterator = ((ActivityEditPart) part).getEditPolicies();
//		while (iterator.hasNext()) {
//			System.err.println(iterator.next()); // REMOVE
//		}
		System.err.println("----------------- END TEST -----------------"); // REMOVE
	}
}
