/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/

package org.eclipse.stp.bpmn.diagram.part;

import org.eclipse.gef.Tool;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.stp.bpmn.tools.SelectionToolEx;

/**
 * Specialization of the diagram edit domain for bpmn diagrams.
 * <p>
 * There was a null pointer that started to appear in the default edit domain.
 * Could not find a better way to fix it than this.
 * Also this forces the default tool to be our very own SelectionToolEx
 * </p>
 * 
 * @author hmalphettes
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class BpmnDiagramEditDomain extends DiagramEditDomain {

    private Tool _defaultTool;
    
    public BpmnDiagramEditDomain(DiagramEditor editor) {
        super(editor);
    }
        
    /**
     * Not sure why but keep getting a null pointer when using the connection
     * tool if it is not started
     */
    public void loadDefaultTool() {
        setActiveTool(null);
        if (super.getPaletteViewer() != null) {
            super.getPaletteViewer().setActiveTool(
                    super.getPaletteViewer().getPaletteRoot().getDefaultEntry());
        } else {
            setActiveTool(getDefaultTool());
        }
    }

    @Override
    public Tool getDefaultTool() {
        if (_defaultTool == null) {
            _defaultTool = new SelectionToolEx();
        }
        return _defaultTool;
    }

    @Override
    public void setDefaultTool(Tool tool) {
        _defaultTool = tool;
        super.setDefaultTool(tool);
    }

    
    

}
