/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.dnd;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;

/**
 * Abstract implementation of IGenericEAnnotationDndHandler.
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public abstract class AbstractGenericEAnnotationDndHandler implements
		IGenericEAnnotationDndHandler {

	/* (non-Javadoc)
	 * @see org.eclipse.stp.bpmn.dnd.IGenericEAnnotationDndHandler#accept(org.eclipse.emf.ecore.EAnnotation, org.eclipse.emf.ecore.EModelElement)
	 */
	public IStatus accept(EAnnotation annotation, IGraphicalEditPart part) {
		if (part.getNotationView().getElement() instanceof EModelElement) {
		return accept(annotation,
				(EModelElement) part.getNotationView().getElement());
		}
		throw new IllegalArgumentException("The model element " +
				"delivered by the part is not an EModelElement");
	}

	/**{@link org.eclipse.stp.bpmn.dnd.IGenericEAnnotationDndHandler#accept(EAnnotation, IGraphicalEditPart)}
	 * @see 
	 * @param annotation
	 * @param modelElement
	 * @return
	 */
	public abstract IStatus accept(EAnnotation annotation,
			EModelElement modelElement);
	
	/* (non-Javadoc)
	 * @see org.eclipse.stp.bpmn.dnd.IGenericEAnnotationDndHandler#doPerformDrop(org.eclipse.emf.ecore.EAnnotation, org.eclipse.emf.ecore.EModelElement)
	 */
	public abstract boolean doPerformDrop(CompoundCommand command,
			EAnnotation annotation,EModelElement modelElement);

}
