/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.dnd;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;

/**
 * Interface dedicated to handle the drop of an EAnnotation on a EModelElement.
 * It extends the drag and drop edit policy by accepting the possibility of a 
 * drop on the model element, giving a IStatus object that may contain some 
 * feedback information. 
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public interface IGenericEAnnotationDndHandler {

	/**
	 * Method called when the edit policy is asked 
	 * if a drop is possible on the modelElement.
	 * @param annotation
	 * @param modelElement
	 * @return a IStatus object containing some feedback.
	 * IStatus.OK means that the drop operation would be accpeted there.
	 */
	public IStatus accept(EAnnotation annotation,IGraphicalEditPart part);
	
	/**
	 * Method called just before the drop operation is done.
	 * @param command the compound command which will be executed.
	 * The client may add command to the chain.
	 * @param annotation
	 * @param modelElement
	 * @return true to proceed to the drop of the annotation on the modelElement.
	 */
	public boolean doPerformDrop(CompoundCommand command,
			EAnnotation annotation,EModelElement modelElement);
}
