/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.dnd.file;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.stp.bpmn.BpmnDiagram;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.dnd.AbstractGenericEAnnotationDndHandler;

/**
 * Handles the generic drag and drop of files on the modeler.
 * Allows the drop only on all shapes, but only one link to a file by
 * shape.
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class FileDndHandler extends AbstractGenericEAnnotationDndHandler {

	@Override
	public IStatus accept(EAnnotation annotation, EModelElement modelElement) {
		if (modelElement != null && (!(modelElement instanceof BpmnDiagram))) {
			if (modelElement.getEAnnotation(
					((EAnnotation) annotation).getSource()) != null) {
				return new Status(IStatus.OK,BpmnDiagramEditorPlugin.ID,
						IStatus.OK,"The previous link will be replaced",null);
			}
			return new Status(IStatus.OK,BpmnDiagramEditorPlugin.ID,
					IStatus.OK,"",null);
		}
		return Status.CANCEL_STATUS;
	}

	@Override
	public boolean doPerformDrop(CompoundCommand command,
			EAnnotation annotation, EModelElement modelElement) {
		if (modelElement.getEAnnotation(
				((EAnnotation) annotation).getSource()) != null) {

			TransactionalEditingDomain domain =((TransactionalEditingDomain) 
					AdapterFactoryEditingDomain.
					getEditingDomainFor(modelElement));
			command.append(RemoveCommand.create(domain,modelElement,
					EcorePackage.eINSTANCE.getEModelElement_EAnnotations(),
					modelElement.getEAnnotation(annotation.getSource())));


		}
		return true;
	}

}
