/**
 * Copyright (C) 2000-2006, Intalio Inc.
 *
 * The program(s) herein may be used and/or copied only with the
 * written permission of Intalio Inc. or in accordance with the terms
 * and conditions stipulated in the agreement/contract under which the
 * program(s) have been supplied.
 *
 * Dates       		 Author              Changes
 * Dec 21, 2006      Antoine Toulm   Creation
 */
package org.eclipse.stp.bpmn.export;

import java.io.ByteArrayOutputStream;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.ui.image.ImageFileFormat;
import org.eclipse.gmf.runtime.diagram.ui.render.clipboard.DiagramSVGGenerator;
import org.eclipse.gmf.runtime.diagram.ui.render.util.CopyToImageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;

/**
 * This extends the CopyImageUtil class
 * so that if the path given as a parameter is null,
 * it keeps the input stream in memory and may be retrieved.
 * @author <a href="mailto:atoulme@intalio.com">Antoine Toulm</a>
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class LazyCopyImageUtil extends CopyToImageUtil {

	private ByteArrayOutputStream _stream = new ByteArrayOutputStream();


	@Override
	protected void saveSVGToFile(IPath destination,
			DiagramSVGGenerator generator, IProgressMonitor monitor)
	throws CoreException {
		if (destination != null) {
			super.saveSVGToFile(destination, generator, monitor);
		} else {
			// populate the ByteArrayStream if there is one.
			if (_stream != null) {
				generator.stream(_stream);
			}
		}
	}


	/**
	 * @return the _stream
	 */
	public ByteArrayOutputStream getStream() {
		return _stream;
	}


	/**
	 * @param _stream the _stream to set
	 */
	public void setStream(ByteArrayOutputStream _stream) {
		this._stream = _stream;
	}

	@Override
	public List copyToImage(Diagram diagram, IPath destination,
			ImageFileFormat format, IProgressMonitor monitor,
			PreferencesHint preferencesHint) throws CoreException {
		List elts = super
				.copyToImage(diagram, destination, format, monitor, preferencesHint);
		return elts;
	}
}
