package org.eclipse.stp.bpmn.handles;

import org.eclipse.draw2d.PositionConstants;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.swt.graphics.Image;

public class ConnectionHandleForAssociation extends ConnectionHandleEx {

    public ConnectionHandleForAssociation(IGraphicalEditPart ownerEditPart, HandleDirection relationshipDirection, String tooltip) {
        super(ownerEditPart, relationshipDirection, tooltip);
    }

    @Override
    protected Image getImage(int side) {
        if (side == PositionConstants.WEST) {
            return isIncoming() ? DiagramUIPluginImagesEx
                    .get(DiagramUIPluginImagesEx.IMG_HANDLE_INCOMING_ASSOCIATION_WEST)
                    : DiagramUIPluginImagesEx
                        .get(DiagramUIPluginImagesEx.IMG_HANDLE_OUTGOING_ASSOCIATION_WEST);
        } else if (side == PositionConstants.EAST) {
            return isIncoming() ? DiagramUIPluginImagesEx
                    .get(DiagramUIPluginImagesEx.IMG_HANDLE_INCOMING_ASSOCIATION_EAST)
                    : DiagramUIPluginImagesEx
                        .get(DiagramUIPluginImagesEx.IMG_HANDLE_OUTGOING_ASSOCIATION_EAST);
        } else if (side == PositionConstants.SOUTH) {
            return isIncoming() ? DiagramUIPluginImagesEx
                .get(DiagramUIPluginImagesEx.IMG_HANDLE_INCOMING_ASSOCIATION_SOUTH)
                : DiagramUIPluginImagesEx
                    .get(DiagramUIPluginImagesEx.IMG_HANDLE_OUTGOING_ASSOCIATION_SOUTH);
        } else {
            return isIncoming() ? DiagramUIPluginImagesEx
                .get(DiagramUIPluginImagesEx.IMG_HANDLE_INCOMING_ASSOCIATION_NORTH)
                : DiagramUIPluginImagesEx
                    .get(DiagramUIPluginImagesEx.IMG_HANDLE_OUTGOING_ASSOCIATION_NORTH);
        }
    }
    
    
}
