/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IPrimaryEditPart;
import org.eclipse.gmf.runtime.diagram.ui.handles.ConnectionHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.tools.ConnectionHandleTool;
import org.eclipse.gmf.runtime.diagram.ui.internal.util.DiagramNotationType;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateUnspecifiedTypeConnectionRequest;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantService;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.StructuredSelection;

/**
 * Avoid direct edit at the end of the creation of the connection.
 * Prevent sequence connection from being created when they cross the boundary 
 * of a sub-process.
 * 
 * @author hmalphettes extends the internal tool to avoid to perform a direct edit
 * at the end of the creation. We could make it a preference.
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class ConnectionHandleToolEx extends ConnectionHandleTool {

    /**
     * @param connectionHandle
     */
    public ConnectionHandleToolEx(ConnectionHandle connectionHandle) {
        super(connectionHandle);
    }
    /**
     * Method selectAddedObject. Select the newly added connection
     */
    protected void selectAddedObject(EditPartViewer viewer,
            Collection objects) {
        final List editparts = new ArrayList();
        final EditPart[] primaryEP = new EditPart[1];
        for (Iterator i = objects.iterator(); i.hasNext();) {
            Object object = i.next();
            if (object instanceof IAdaptable) {
                Object editPart = viewer.getEditPartRegistry().get(
                        ((IAdaptable) object)
                                .getAdapter(View.class));

                if (editPart instanceof IPrimaryEditPart) {
                    editparts.add(editPart);
                }

//uncomment to put shape in direct edit mode.
//                // Priority is to put a shape into direct edit mode.
//                if (editPart instanceof ShapeEditPart) {
//                    primaryEP[0] = (ShapeEditPart) editPart;
//                }
            }
        }

        if (!editparts.isEmpty()) {
            viewer.setSelection(new StructuredSelection(editparts));

            // next section of code was removed as EDGE-1020 fix:
            // turn off auto edit mode after
            // connection creation
        }
    }
    
    /**
     * Override to filter the rel-types provided by the assistant service that
     * are the "attach-note" type of connection.
     * 
     * @see org.eclipse.gef.tools.TargetingTool#createTargetRequest()
     */
    protected Request createTargetRequest() {
        if (getConnectionHandle().isIncoming()) {
            List relTypes = ModelingAssistantService.getInstance().getRelTypesOnTarget(
                    getConnectionHandle().getOwner());
            relTypes.remove(DiagramNotationType.NOTE_ATTACHMENT);
            CreateUnspecifiedTypeConnectionRequest request = 
                new CreateUnspecifiedTypeConnectionRequest(
                    relTypes, false, getPreferencesHint());
            request.setDirectionReversed(true);
            return request;
        } else {
        	List relTypes = ModelingAssistantService.getInstance().
        	getRelTypesOnSource(getConnectionHandle().getOwner());
            relTypes.remove(DiagramNotationType.NOTE_ATTACHMENT);
            return new CreateUnspecifiedTypeConnectionRequest(
                    relTypes, false, getPreferencesHint());
        }
    }

    
}
