/******************************************************************************
 * Copyright (c) 2006, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 *******************************************************************************/
package org.eclipse.stp.bpmn.diagram.edit.policies;

import java.util.List;

import org.eclipse.gef.commands.Command;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.CreationEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest.ViewDescriptor;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnVisualIDRegistry;

/**
 * Set subprocess figure default size.
 * <p>
 * Make sure a non-executable command is returned when the container for the
 * element to create is not the host of this policy. (ie that an element created
 *  by this sub-process is indeed created in this same sub-process.
 * </p>
 * @author hmalphettes
 * @author vlevytskyy
 * @author <a href="http://www.intalio.com">&copy; Intalio, Inc.</a>
 */
public class SubProcessCreationEditPolicy extends CreationEditPolicy {

    @Override
    /**
     * Set subprocess figure default size
     */
    protected Command getCreateCommand(CreateViewRequest request) {
        List viewDescriptors = request.getViewDescriptors();
        for (Object viewDescriptor : viewDescriptors) {
            String semanticHints = BpmnVisualIDRegistry
                    .getType(org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart.VISUAL_ID);
            if (semanticHints.equals(((ViewDescriptor) viewDescriptor)
                            .getSemanticHint())) {
                if (request.getSize() == null) {
                    request.setSize(SubProcessEditPart.EXPANDED_SIZE);
                }
            }
        }
        return super.getCreateCommand(request);
    }

}
