/*
 * Copyright (c) 2007, Intalio Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     Intalio Inc. - initial API and implementation
 */
package org.eclipse.stp.bpmn.diagram.providers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.PositionConstants;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.ui.services.modelingassistant.ModelingAssistantProvider;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.window.Window;
import org.eclipse.stp.bpmn.Activity;
import org.eclipse.stp.bpmn.Artifact;
import org.eclipse.stp.bpmn.SubProcess;
import org.eclipse.stp.bpmn.commands.ElementTypeEx;
import org.eclipse.stp.bpmn.diagram.edit.parts.Activity2EditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.ActivityEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.BpmnDiagramEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.PoolPoolCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBodyCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.edit.parts.SubProcessSubProcessBorderCompartmentEditPart;
import org.eclipse.stp.bpmn.diagram.part.BpmnDiagramEditorPlugin;
import org.eclipse.stp.bpmn.tools.ConnectionValidator;
import org.eclipse.stp.bpmn.tools.EdgeConnectionValidator;
import org.eclipse.stp.bpmn.tools.MessageConnectionValidator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

/**
 * @generated
 */
public class BpmnModelingAssistantProvider extends ModelingAssistantProvider {

    /**
     * @generated
     */
    public List getTypesForPopupBarGen(IAdaptable host) {
        IGraphicalEditPart editPart = (IGraphicalEditPart) host
                .getAdapter(IGraphicalEditPart.class);
        if (editPart instanceof SubProcessEditPart) {
            List types = new ArrayList();
            types.add(BpmnElementTypes.Activity_2003);
            return types;
        }
        if (editPart instanceof PoolPoolCompartmentEditPart) {
            List types = new ArrayList();
            types.add(BpmnElementTypes.Activity_2001);
            types.add(BpmnElementTypes.SubProcess_2002);
            types.add(BpmnElementTypes.Lane_2007);
            types.add(BpmnElementTypes.TextAnnotation_2004);
            types.add(BpmnElementTypes.DataObject_2005);
            types.add(BpmnElementTypes.Group_2006);
            return types;
        }
        if (editPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            List types = new ArrayList();
            types.add(BpmnElementTypes.Activity_2001);
            types.add(BpmnElementTypes.SubProcess_2002);
            types.add(BpmnElementTypes.TextAnnotation_2004);
            types.add(BpmnElementTypes.DataObject_2005);
            types.add(BpmnElementTypes.Group_2006);
            return types;
        }
        if (editPart instanceof BpmnDiagramEditPart) {
            List types = new ArrayList();
            types.add(BpmnElementTypes.Pool_1001);
            types.add(BpmnElementTypes.TextAnnotation_1002);
            types.add(BpmnElementTypes.DataObject_1003);
            types.add(BpmnElementTypes.Group_1004);
            return types;
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * Make sure we don't do add things to the subprocesseditpart. we only we
     * want to add to its compartment.
     * 
     * @generated NOT
     */
    @SuppressWarnings("unchecked")
    public List getTypesForPopupBar(IAdaptable host) {
        IGraphicalEditPart editPart = (IGraphicalEditPart) host
                .getAdapter(IGraphicalEditPart.class);
        /*
         * Hugues: nope. if (editPart instanceof SubProcessEditPart) { List
         * types = new ArrayList(); types.add(BpmnElementTypes.Activity_2003);
         * return types; }
         * For some reason it is what gets generated. is there a mistake in the mapping file?
         */
        // added by hugues
        if (editPart instanceof SubProcessSubProcessBorderCompartmentEditPart) {
            List types = new ArrayList();
            types.addAll(BPMNElementTypesActivities
                    .getElementTypesForSubProcessBorder());
            return types;
        }
        // -- added by hugues.
        if (editPart instanceof PoolPoolCompartmentEditPart) {
            List types = new ArrayList();
            types.addAll(BPMNElementTypesActivities
                    .getElementTypesForPoolAndSubProcessBody());
            types.add(BpmnElementTypes.Lane_2007);
            types.add(BpmnElementTypes.TextAnnotation_2004);
            types.add(BpmnElementTypes.DataObject_2005);
            types.add(BpmnElementTypes.Group_2006);
            return types;
        }
        if (editPart instanceof SubProcessSubProcessBodyCompartmentEditPart) {
            List types = new ArrayList();
            types.addAll(BPMNElementTypesActivities
                    .getElementTypesForPoolAndSubProcessBody());
            types.add(BpmnElementTypes.TextAnnotation_2004);
            types.add(BpmnElementTypes.DataObject_2005);
            types.add(BpmnElementTypes.Group_2006);
            return types;
        }
        if (editPart instanceof BpmnDiagramEditPart) {
            List types = new ArrayList();
            types.add(BpmnElementTypes.Pool_1001);
            types.add(BpmnElementTypes.TextAnnotation_1002);
            types.add(BpmnElementTypes.DataObject_1003);
            types.add(BpmnElementTypes.Group_1004);
            return types;
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * @generated NOT
     */
    public List getRelTypesOnSource(IAdaptable source) {
        IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source
                .getAdapter(IGraphicalEditPart.class);

        if (sourceEditPart instanceof ActivityEditPart) {
            List types = new ArrayList();
            int handlePosition = ((ActivityEditPart) sourceEditPart)
                    .getHandlePosition();
			types.add(BpmnElementTypes.Association_3003);
            if ((handlePosition == PositionConstants.EAST)
                    || (handlePosition == PositionConstants.WEST)) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else {
                types.add(BpmnElementTypes.MessagingEdge_3002);
            }

            return types;
        }
        if (sourceEditPart instanceof Activity2EditPart) {
            List types = new ArrayList();
			types.add(BpmnElementTypes.Association_3003);
            types.add(BpmnElementTypes.SequenceEdge_3001);
            return types;
        }
        if (sourceEditPart instanceof SubProcessEditPart) {
            List types = new ArrayList();
			types.add(BpmnElementTypes.Association_3003);
            types.add(BpmnElementTypes.SequenceEdge_3001);
            return types;
        }
        if (editPartIsForArtifact(sourceEditPart)) {
        	List types = new ArrayList();
			types.add(BpmnElementTypes.Association_3003);
			return types;
		}
        return Collections.EMPTY_LIST;
    }
    
    private boolean editPartIsForArtifact(EditPart editPart) {
        	GraphicalEditPart se = (GraphicalEditPart)editPart;
        	return se.getNotationView().getElement() instanceof Artifact;
    }

    /**
     * @generated NOT
     */
    public List getRelTypesOnTarget(IAdaptable target) {
        IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target
                .getAdapter(IGraphicalEditPart.class);
        if (targetEditPart instanceof ActivityEditPart) {
            List types = new ArrayList();
			types.add(BpmnElementTypes.Association_3003);
            int handlePosition = ((ActivityEditPart) targetEditPart)
                    .getHandlePosition();
            if ((handlePosition == PositionConstants.EAST)
                    || (handlePosition == PositionConstants.WEST)) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else {
                types.add(BpmnElementTypes.MessagingEdge_3002);
            }

            return types;
        }
        if (targetEditPart instanceof Activity2EditPart) {
            List types = new ArrayList();
			types.add(BpmnElementTypes.Association_3003);
            types.add(BpmnElementTypes.SequenceEdge_3001);
            return types;
        }
        if (targetEditPart instanceof SubProcessEditPart) {
            List types = new ArrayList();
			types.add(BpmnElementTypes.Association_3003);
            types.add(BpmnElementTypes.SequenceEdge_3001);
            return types;
        }

        return Collections.EMPTY_LIST;
    }

    /**
     * @generated NOT
     */
    public List getRelTypesOnSourceAndTarget(IAdaptable source,
            IAdaptable target) {
        if (source.equals(target)) {
            return Collections.EMPTY_LIST;
        }
        IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source
                .getAdapter(IGraphicalEditPart.class);
        IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target
                .getAdapter(IGraphicalEditPart.class);

        if (sourceEditPart instanceof SubProcessEditPart) {
            List types = new ArrayList();
            if (targetEditPart instanceof ActivityEditPart) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else if (targetEditPart instanceof Activity2EditPart) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else if (targetEditPart instanceof SubProcessEditPart) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else if (editPartIsForArtifact(targetEditPart)) {
            	types.add(BpmnElementTypes.Association_3003);
            }

            return types;
        }

        if (sourceEditPart instanceof ActivityEditPart) {
            List types = new ArrayList();
            if (targetEditPart instanceof ActivityEditPart) {
                int handlePosition = ((ActivityEditPart) sourceEditPart)
                        .getHandlePosition();

                if (handlePosition == 0) {
                    // the connection is incoming
                    handlePosition = ((ActivityEditPart) targetEditPart)
                            .getHandlePosition();
                }

                if ((handlePosition == PositionConstants.EAST)
                        || (handlePosition == PositionConstants.WEST)) {
                    types.add(BpmnElementTypes.SequenceEdge_3001);
                } else {
                    types.add(BpmnElementTypes.MessagingEdge_3002);
                }
            } else if (targetEditPart instanceof Activity2EditPart) {
                // no incoming connections is allowed
                // types.add(BpmnElementTypes.SequenceEdge_3001);
            } else if (targetEditPart instanceof SubProcessEditPart) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else if (editPartIsForArtifact(targetEditPart)) {
            	types.add(BpmnElementTypes.Association_3003);
            }

            return types;
        }
        if (sourceEditPart instanceof Activity2EditPart) {
            List types = new ArrayList();
            if (targetEditPart instanceof ActivityEditPart) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else if (targetEditPart instanceof Activity2EditPart) {

            } else if (targetEditPart instanceof SubProcessEditPart) {
                types.add(BpmnElementTypes.SequenceEdge_3001);
            } else if (editPartIsForArtifact(targetEditPart)) {
            	types.add(BpmnElementTypes.Association_3003);            
            }

            return types;
        }
        return Collections.EMPTY_LIST;
    }

    /**
     * @generated NOT
     */
    public List getTypesForSource(IAdaptable target,
            IElementType relationshipType) {
        IGraphicalEditPart targetEditPart = (IGraphicalEditPart) target
                .getAdapter(IGraphicalEditPart.class);
        if (targetEditPart instanceof ActivityEditPart) {
            List types = new ArrayList();
            if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForMessagingEdgeSource());
            } else if (relationshipType == BpmnElementTypes.SequenceEdge_3001) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForSequenceEdgeSource());
            }  else if (relationshipType == BpmnElementTypes.Association_3003) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForAssociationSource());
            }
            return types;
        }
        if (targetEditPart instanceof Activity2EditPart) {
            return Collections.EMPTY_LIST;
        }
        if (targetEditPart instanceof SubProcessEditPart) {
            if (relationshipType == BpmnElementTypes.SequenceEdge_3001) {
                List types = new ArrayList();
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForSequenceEdgeSource());
                return types;
            }  else if (relationshipType == BpmnElementTypes.Association_3003) {
                List types = new ArrayList();
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForAssociationSource());
                return types;
            }
        }
        if (editPartIsForArtifact(targetEditPart) &&
            relationshipType == BpmnElementTypes.Association_3003) {
                List types = new ArrayList();
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForAssociationSource());
                return types;
        }
        
        /* what was geenrated
            if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
                types.add(BpmnElementTypes.Activity_2001);
            }
            if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
                types.add(BpmnElementTypes.Activity_2003);
            }
            return types;
        }
        if (targetEditPart instanceof Activity2EditPart) {
            List types = new ArrayList();
            if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
                types.add(BpmnElementTypes.Activity_2001);
            }
            if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
                types.add(BpmnElementTypes.Activity_2003);
            }
            return types;
        }*/
        return Collections.EMPTY_LIST;
    }

    public List getTypesForTarget(IAdaptable source,
            IElementType relationshipType) {
        IGraphicalEditPart sourceEditPart = (IGraphicalEditPart) source
                .getAdapter(IGraphicalEditPart.class);
        if (sourceEditPart instanceof ActivityEditPart) {
            List types = new ArrayList();
            if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForMessagingEdgeTarget());
            } else if (relationshipType == BpmnElementTypes.SequenceEdge_3001) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForSequenceEdgeTarget());
            }  else if (relationshipType == BpmnElementTypes.Association_3003) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForAssociationTarget());
            } 
            return types;
        }
        if (sourceEditPart instanceof Activity2EditPart) {
            if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
                return Collections.EMPTY_LIST;
            } else if (relationshipType == BpmnElementTypes.SequenceEdge_3001) {
                List types = new ArrayList();
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForSequenceEdgeTarget());
                return types;
            } else if (relationshipType == BpmnElementTypes.Association_3003) {
                List types = new ArrayList();
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForAssociationTarget());
                return types;
            }
        }
        if (sourceEditPart instanceof SubProcessEditPart) {
            List types = new ArrayList();
            if (relationshipType == BpmnElementTypes.SequenceEdge_3001) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForSequenceEdgeTarget());
            } else if (relationshipType == BpmnElementTypes.Association_3003) {
                types.addAll(BPMNElementTypesActivities
                        .getElementTypesForAssociationTarget());
            }
            return types;
        }

        return Collections.EMPTY_LIST;
    }

    /**
     * @generated
     */
    public EObject selectExistingElementForSource(IAdaptable target,
            IElementType relationshipType) {
        return selectExistingElement(target, getTypesForSource(target,
                relationshipType), relationshipType);
    }

    /**
     * @generated
     */
    public EObject selectExistingElementForTarget(IAdaptable source,
            IElementType relationshipType) {
        return selectExistingElement(source, getTypesForTarget(source,
                relationshipType), relationshipType);
    }

    /**
     * @generated NOT
     */
    protected EObject selectExistingElement(IAdaptable host, Collection types,
            IElementType relationshipType) {
        if (types.isEmpty()) {
            return null;
        }
        IGraphicalEditPart editPart = (IGraphicalEditPart) host
                .getAdapter(IGraphicalEditPart.class);
        if (editPart == null) {
            return null;
        }
        IGraphicalEditPart diagramEP = (IGraphicalEditPart) editPart.getRoot()
                .getContents();
        ConnectionValidator validator;
        if (relationshipType == BpmnElementTypes.MessagingEdge_3002) {
            validator = new MessageConnectionValidator();
        } else {
            validator = new EdgeConnectionValidator();
        }
        EditPart dep = editPart.getRoot().getContents();
        Diagram diagram = (Diagram) editPart.getRoot().getContents().getModel();
        Collection elements = new HashSet();
        for (Iterator it = diagram.getElement().eAllContents(); it.hasNext();) {
            EObject element = (EObject) it.next();
            if (isApplicableElement(element, types)
                    && (validator.canConnect(editPart, diagramEP.findEditPart(
                            null, element)))) {
                elements.add(element);
            }
        }
        if (elements.isEmpty()) {
            return null;
        }
        return selectElement((EObject[]) elements.toArray(new EObject[elements
                .size()]));
    }

    /**
     * @generated NOT
     */
    protected boolean isApplicableElement(EObject element, Collection types) {
        Collection<String> hints = new HashSet<String>();
        for (Iterator iter = types.iterator(); iter.hasNext();) {
            ElementTypeEx el = (ElementTypeEx) iter.next();
            hints.add(el.getSecondarySemanticHint());
        }

        String hint;

        if (element instanceof SubProcess) {
            hint = "SubProcess";
            return hints.contains(hint);
        } else if (element instanceof Activity) {
            hint = ((Activity) element).getActivityType().getLiteral();
            return hints.contains(hint);
        } else if (element instanceof Artifact) {
            System.err.println("TODO complete the BpmnModeleingAssistant for the artifacts.");
        }

        return false;
    }

    /**
     * @generated
     */
    protected EObject selectElement(EObject[] elements) {
        Shell shell = Display.getCurrent().getActiveShell();
        ILabelProvider labelProvider = new AdapterFactoryLabelProvider(
                BpmnDiagramEditorPlugin.getInstance()
                        .getItemProvidersAdapterFactory());
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(
                shell, labelProvider);
        dialog.setMessage("Available domain model elements:");
        dialog.setTitle("Select domain model element");
        dialog.setMultipleSelection(false);
        dialog.setElements(elements);
        EObject selected = null;
        if (dialog.open() == Window.OK) {
            selected = (EObject) dialog.getFirstResult();
        }
        return selected;
    }
}
